/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.DocumentProcessor;
import edu.stanford.nlp.process.StopList;
import java.io.File;

public class StoplistFilter<L, F>
implements DocumentProcessor<Word, Word, L, F> {
    private StopList stoplist;

    public StoplistFilter() {
        this(new StopList());
    }

    public StoplistFilter(String stoplistfile) {
        this(new StopList(new File(stoplistfile)));
    }

    public StoplistFilter(StopList stoplist) {
        this.stoplist = stoplist;
    }

    @Override
    public Document<L, F, Word> processDocument(Document<L, F, Word> in) {
        Document out2 = in.blankDocument();
        for (Word w : in) {
            if (this.stoplist.contains(w)) continue;
            out2.add(w);
        }
        return out2;
    }
}

