/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.util.Properties;
import junit.framework.TestCase;

public class SUTimeBritishITest
extends TestCase {
    public StanfordCoreNLP pipeline;

    public void setUp() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner");
        props.setProperty("sutime.language", "british");
        this.pipeline = new StanfordCoreNLP(props);
    }

    public String normalizedDate(CoreDocument doc) {
        return (String)doc.entityMentions().get(0).tokens().get(0).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
    }

    public void testBritishStyleDateRecognition() {
        Properties props = new Properties();
        CoreDocument britishDocumentOne = new CoreDocument("The event will be on 10/12/2017.");
        CoreDocument britishDocumentTwo = new CoreDocument("The event will be on 30/12/2017.");
        CoreDocument americanDocumentOne = new CoreDocument("The event will be on 10/12/2017.");
        CoreDocument americanDocumentTwo = new CoreDocument("The event will be on 30/12/2017.");
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner");
        props.setProperty("sutime.language", "british");
        this.pipeline = new StanfordCoreNLP(props);
        this.pipeline.annotate(britishDocumentOne);
        this.pipeline.annotate(britishDocumentTwo);
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner");
        props.setProperty("sutime.language", "english");
        this.pipeline = new StanfordCoreNLP(props);
        this.pipeline.annotate(americanDocumentOne);
        this.pipeline.annotate(americanDocumentTwo);
        System.err.println("---");
        System.err.println("doc 1: " + britishDocumentOne.text());
        System.err.println("doc 2: " + britishDocumentTwo.text());
        System.err.println("british date 1: " + this.normalizedDate(britishDocumentOne));
        System.err.println("british date 2: " + this.normalizedDate(britishDocumentTwo));
        System.err.println("american date 1: " + this.normalizedDate(americanDocumentOne));
        System.err.println("american date 2: " + this.normalizedDate(americanDocumentTwo));
        SUTimeBritishITest.assertEquals((String)this.normalizedDate(britishDocumentOne), (String)"2017-12-10");
        SUTimeBritishITest.assertEquals((String)this.normalizedDate(britishDocumentTwo), (String)"2017-12-30");
        SUTimeBritishITest.assertEquals((String)this.normalizedDate(americanDocumentOne), (String)"2017-10-12");
        SUTimeBritishITest.assertEquals((String)this.normalizedDate(americanDocumentTwo), null);
    }
}

