/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.CoreMapTest;
import edu.stanford.nlp.util.CoreMaps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;

public class CoreMapsTest
extends TestCase {
    public void testMaps() {
        Integer v;
        Random random = new Random();
        LinkedList<ArrayCoreMap> maps = new LinkedList<ArrayCoreMap>();
        for (int i = 0; i < 25; ++i) {
            ArrayCoreMap m = new ArrayCoreMap();
            m.set(CoreMapTest.IntegerA.class, random.nextInt());
            maps.add(m);
        }
        Map view = CoreMaps.asMap(maps, CoreMapTest.IntegerA.class);
        for (CoreMap coreMap : maps) {
            CoreMapsTest.assertTrue((boolean)view.containsKey(coreMap));
            CoreMapsTest.assertEquals(view.get(coreMap), coreMap.get(CoreMapTest.IntegerA.class));
            v = random.nextInt();
            coreMap.set(CoreMapTest.IntegerA.class, v);
            CoreMapsTest.assertEquals(view.get(coreMap), (Object)v);
            CoreMapsTest.assertEquals(view.get(coreMap), coreMap.get(CoreMapTest.IntegerA.class));
        }
        CoreMapsTest.assertEquals(new LinkedList(view.keySet()), maps);
        for (Map.Entry entry : view.entrySet()) {
            CoreMapsTest.assertEquals(((CoreMap)entry.getKey()).get(CoreMapTest.IntegerA.class), entry.getValue());
            v = random.nextInt();
            entry.setValue(v);
            CoreMapsTest.assertEquals(entry.getValue(), (Object)v);
            CoreMapsTest.assertEquals(((CoreMap)entry.getKey()).get(CoreMapTest.IntegerA.class), (Object)v);
        }
    }
}

