/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block;

import org.ejml.alg.block.BlockInnerMultiplication;
import org.ejml.data.D1Submatrix64F;

public class BlockInnerRankUpdate {
    public static void rankNUpdate(int n, double d, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2) {
        int n2 = d1Submatrix64F2.row1 - d1Submatrix64F2.row0;
        if (n2 > n) {
            throw new IllegalArgumentException("Height of B cannot be greater than the block length");
        }
        int n3 = d1Submatrix64F2.col1 - d1Submatrix64F2.col0;
        if (d1Submatrix64F.col1 - d1Submatrix64F.col0 != n3) {
            throw new IllegalArgumentException("A does not have the expected number of columns based on B's width");
        }
        if (d1Submatrix64F.row1 - d1Submatrix64F.row0 != n3) {
            throw new IllegalArgumentException("A does not have the expected number of rows based on B's width");
        }
        for (int i = d1Submatrix64F2.col0; i < d1Submatrix64F2.col1; i += n) {
            int n4 = d1Submatrix64F2.row0 * d1Submatrix64F2.original.numCols + i * n2;
            int n5 = Math.min(n, d1Submatrix64F2.col1 - i);
            int n6 = i - d1Submatrix64F2.col0 + d1Submatrix64F.row0;
            int n7 = Math.min(n, d1Submatrix64F.row1 - n6);
            for (int j = d1Submatrix64F2.col0; j < d1Submatrix64F2.col1; j += n) {
                int n8 = Math.min(n, d1Submatrix64F2.col1 - j);
                int n9 = n6 * d1Submatrix64F.original.numCols + (j - d1Submatrix64F2.col0 + d1Submatrix64F.col0) * n7;
                int n10 = d1Submatrix64F2.row0 * d1Submatrix64F2.original.numCols + j * n2;
                BlockInnerMultiplication.blockMultPlusTransA(d, d1Submatrix64F2.original.data, d1Submatrix64F2.original.data, d1Submatrix64F.original.data, n4, n10, n9, n2, n5, n8);
            }
        }
    }

    public static void symmRankNMinus_U(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2) {
        int n2 = d1Submatrix64F2.row1 - d1Submatrix64F2.row0;
        if (n2 > n) {
            throw new IllegalArgumentException("Height of B cannot be greater than the block length");
        }
        int n3 = d1Submatrix64F2.col1 - d1Submatrix64F2.col0;
        if (d1Submatrix64F.col1 - d1Submatrix64F.col0 != n3) {
            throw new IllegalArgumentException("A does not have the expected number of columns based on B's width");
        }
        if (d1Submatrix64F.row1 - d1Submatrix64F.row0 != n3) {
            throw new IllegalArgumentException("A does not have the expected number of rows based on B's width");
        }
        for (int i = d1Submatrix64F2.col0; i < d1Submatrix64F2.col1; i += n) {
            int n4 = d1Submatrix64F2.row0 * d1Submatrix64F2.original.numCols + i * n2;
            int n5 = Math.min(n, d1Submatrix64F2.col1 - i);
            int n6 = i - d1Submatrix64F2.col0 + d1Submatrix64F.row0;
            int n7 = Math.min(n, d1Submatrix64F.row1 - n6);
            for (int j = i; j < d1Submatrix64F2.col1; j += n) {
                int n8 = Math.min(n, d1Submatrix64F2.col1 - j);
                int n9 = n6 * d1Submatrix64F.original.numCols + (j - d1Submatrix64F2.col0 + d1Submatrix64F.col0) * n7;
                int n10 = d1Submatrix64F2.row0 * d1Submatrix64F2.original.numCols + j * n2;
                if (i == j) {
                    BlockInnerRankUpdate.multTransABlockMinus_U(d1Submatrix64F2.original.data, d1Submatrix64F.original.data, n4, n10, n9, n2, n5, n8);
                    continue;
                }
                BlockInnerRankUpdate.multTransABlockMinus(d1Submatrix64F2.original.data, d1Submatrix64F.original.data, n4, n10, n9, n2, n5, n8);
            }
        }
    }

    public static void symmRankNMinus_L(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2) {
        int n2 = d1Submatrix64F2.col1 - d1Submatrix64F2.col0;
        if (n2 > n) {
            throw new IllegalArgumentException("Width of B cannot be greater than the block length");
        }
        int n3 = d1Submatrix64F2.row1 - d1Submatrix64F2.row0;
        if (d1Submatrix64F.col1 - d1Submatrix64F.col0 != n3) {
            throw new IllegalArgumentException("A does not have the expected number of columns based on B's height");
        }
        if (d1Submatrix64F.row1 - d1Submatrix64F.row0 != n3) {
            throw new IllegalArgumentException("A does not have the expected number of rows based on B's height");
        }
        for (int i = d1Submatrix64F2.row0; i < d1Submatrix64F2.row1; i += n) {
            int n4 = Math.min(n, d1Submatrix64F2.row1 - i);
            int n5 = i * d1Submatrix64F2.original.numCols + n4 * d1Submatrix64F2.col0;
            int n6 = i - d1Submatrix64F2.row0 + d1Submatrix64F.row0;
            int n7 = Math.min(n, d1Submatrix64F.row1 - n6);
            for (int j = d1Submatrix64F2.row0; j <= i; j += n) {
                int n8 = Math.min(n, d1Submatrix64F2.row1 - j);
                int n9 = n6 * d1Submatrix64F.original.numCols + (j - d1Submatrix64F2.row0 + d1Submatrix64F.col0) * n7;
                int n10 = j * d1Submatrix64F2.original.numCols + n8 * d1Submatrix64F2.col0;
                if (i == j) {
                    BlockInnerRankUpdate.multTransBBlockMinus_L(d1Submatrix64F2.original.data, d1Submatrix64F.original.data, n5, n10, n9, n2, n4, n8);
                    continue;
                }
                BlockInnerRankUpdate.multTransBBlockMinus(d1Submatrix64F2.original.data, d1Submatrix64F.original.data, n5, n10, n9, n2, n4, n8);
            }
        }
    }

    protected static void multTransABlockMinus(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2;
        int n8 = n7 + n4 * n6;
        int n9 = n;
        while (n7 != n8) {
            int n10 = n9;
            int n11 = n3;
            int n12 = n10 + n5;
            int n13 = n7 + n6;
            while (n10 != n12) {
                double d = dArray[n10++];
                int n14 = n7;
                while (n14 != n13) {
                    int n15 = n11++;
                    dArray2[n15] = dArray2[n15] - d * dArray[n14++];
                }
            }
            n7 += n6;
            n9 += n5;
        }
    }

    protected static void multTransABlockMinus_U(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                double d = dArray[j * n5 + i + n];
                int n7 = j * n6 + n2 + i;
                int n8 = i * n6 + n3 + i;
                int n9 = n8 - i + n6;
                while (n8 != n9) {
                    int n10 = n8++;
                    dArray2[n10] = dArray2[n10] - d * dArray[n7++];
                }
            }
        }
    }

    protected static void multTransBBlockMinus(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        int n8 = n3;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = n7 + n4;
            int n11 = n2;
            int n12 = n8 + n6;
            while (n8 != n12) {
                int n13 = n7;
                int n14 = n11;
                double d = 0.0;
                while (n13 != n10) {
                    d += dArray[n13++] * dArray[n14++];
                }
                int n15 = n8++;
                dArray2[n15] = dArray2[n15] - d;
                n11 += n4;
            }
            ++n9;
            n7 += n4;
        }
    }

    protected static void multTransBBlockMinus_L(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < n5; ++i) {
            int n7 = i * n4 + n;
            int n8 = n7 + n4;
            int n9 = n2;
            int n10 = i * n6 + n3;
            int n11 = 0;
            while (n11 <= i) {
                double d = 0.0;
                int n12 = n7;
                int n13 = n9;
                while (n12 != n8) {
                    d += dArray[n12++] * dArray[n13++];
                }
                int n14 = n10 + n11;
                dArray2[n14] = dArray2[n14] - d;
                ++n11;
                n9 += n4;
            }
        }
    }
}

