/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref;

import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.hybrid.HybridCorefSystem;
import edu.stanford.nlp.coref.neural.NeuralCorefAlgorithm;
import edu.stanford.nlp.coref.statistical.ClusteringCorefAlgorithm;
import edu.stanford.nlp.coref.statistical.StatisticalCorefAlgorithm;
import java.util.Properties;

public interface CorefAlgorithm {
    public void runCoref(Document var1);

    public static CorefAlgorithm fromProps(Properties props, Dictionaries dictionaries) {
        CorefProperties.CorefAlgorithmType algorithm = CorefProperties.algorithm(props);
        if (algorithm == CorefProperties.CorefAlgorithmType.CLUSTERING) {
            return new ClusteringCorefAlgorithm(props, dictionaries);
        }
        if (algorithm == CorefProperties.CorefAlgorithmType.STATISTICAL) {
            return new StatisticalCorefAlgorithm(props, dictionaries);
        }
        if (algorithm == CorefProperties.CorefAlgorithmType.NEURAL) {
            return new NeuralCorefAlgorithm(props, dictionaries);
        }
        try {
            return new HybridCorefSystem(props, dictionaries);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating hybrid coref system", e);
        }
    }
}

