/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.misc;

import edu.stanford.nlp.coref.CorefAlgorithm;
import edu.stanford.nlp.coref.CorefSystem;
import edu.stanford.nlp.coref.CorefUtils;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.DocumentMaker;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FromFileCorefAlgorithm
implements CorefAlgorithm {
    private final Map<Integer, List<Pair<Integer, Integer>>> toMerge = new HashMap<Integer, List<Pair<Integer, Integer>>>();
    private int currentDocId = 0;

    public FromFileCorefAlgorithm(String savedLinkPath) {
        try (BufferedReader br = new BufferedReader(new FileReader(savedLinkPath));){
            br.lines().forEach(line -> {
                String[] split = line.split("\t");
                int did = Integer.valueOf(split[0]);
                List<Pair<Integer, Integer>> docMerges = this.toMerge.get(did);
                if (docMerges == null) {
                    docMerges = new ArrayList<Pair<Integer, Integer>>();
                    this.toMerge.put(did, docMerges);
                }
                if (split.length > 1) {
                    String[] pairs;
                    for (String pair : pairs = split[1].split(" ")) {
                        String[] ms = pair.split(",");
                        docMerges.add(new Pair<Integer, Integer>(Integer.valueOf(ms[0]), Integer.valueOf(ms[1])));
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading saved links", e);
        }
    }

    @Override
    public void runCoref(Document document) {
        if (this.toMerge.containsKey(this.currentDocId)) {
            for (Pair<Integer, Integer> pair : this.toMerge.get(this.currentDocId)) {
                CorefUtils.mergeCoreferenceClusters(pair, document);
            }
        }
        ++this.currentDocId;
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties("-props", args[0]);
        new CorefSystem(new DocumentMaker(props, new Dictionaries(props)), new FromFileCorefAlgorithm(args[1]), true, false).runOnConll(props);
    }
}

