/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.ClassifierCombiner;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.CoreUtilities;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;

public class ClassifierCombinerTest
extends TestCase {
    String[] words = new String[]{"Joe", "Smith", "drank", "44", "Budweiser", "cans", "at", "Monaco", "Brewing", "."};
    String[] tags = new String[]{"NNP", "NNP", "VBD", "CD", "NNP", "NNS", "IN", "NNP", "NNP", "."};
    String[] ans1 = new String[]{"PER", "PER", "O", "O", "ORG", "O", "O", "ORG", "ORG", "O"};
    String[] ans2 = new String[]{"O", "O", "O", "NUM", "O", "O", "O", "O", "O", "O"};
    String[] ans3 = new String[]{"O", "O", "O", "NUM", "PROD", "PROD", "O", "O", "O", "O"};
    String[] ans4 = new String[]{"PER", "PER", "O", "O", "O", "O", "O", "O", "O", "O"};
    String[] ans5 = new String[]{"O", "O", "O", "NUM", "PROD", "PROD", "O", "ORG", "ORG", "ORG"};
    String[] ans6 = new String[]{"O", "O", "O", "O", "O", "O", "O", "O", "O", "O"};
    String[] ans7 = new String[]{"PER", "PER", "O", "NUM", "PROD", "PROD", "O", "ORG", "ORG", "ORG"};
    String[] ans8 = new String[]{"O", "O", "O", "PROD", "PROD", "O", "O", "O", "O", "O"};
    String[] ans9 = new String[]{"O", "O", "O", "O", "O", "O", "O", "O", "O", "NUM"};
    String[] ans10 = new String[]{"O", "O", "O", "O", "O", "O", "O", "O", "NUM", "NUM"};
    String[] ans11 = new String[]{"O", "O", "O", "O", "PROD", "PROD", "O", "O", "O", "O"};
    String[] ans12 = new String[]{"O", "O", "O", "O", "O", "O", "O", "O", "NUM", "NUM"};
    String[] ans13 = new String[]{"O", "O", "O", "O", "O", "O", "NUM", "NUM", "O", "O"};
    String[] ans14 = new String[]{"O", "O", "O", "O", "O", "O", "FOO", "FOO", "O", "O"};
    String[] ans15 = new String[]{"O", "O", "PER", "PER", "O", "O", "O", "O", "O", "O"};
    String[] ans16 = new String[]{"O", "O", "FOO", "FOO", "O", "O", "O", "O", "O", "O"};
    String[] out1 = new String[]{"PER", "PER", "O", "NUM", "ORG", "O", "O", "ORG", "ORG", "O"};
    String[] out2 = new String[]{"PER", "PER", "O", "NUM", "PROD", "PROD", "O", "ORG", "ORG", "ORG"};
    String[] out3 = new String[]{"O", "O", "O", "NUM", "PROD", "PROD", "O", "ORG", "ORG", "ORG"};
    String[] out4 = new String[]{"O", "O", "O", "NUM", "O", "O", "O", "O", "O", "NUM"};
    String[] out5 = new String[]{"O", "O", "O", "NUM", "O", "O", "O", "O", "NUM", "NUM"};
    String[] out6 = new String[]{"O", "O", "O", "O", "O", "O", "NUM", "NUM", "NUM", "NUM"};
    String[] out7 = new String[]{"O", "O", "O", "O", "O", "O", "FOO", "FOO", "NUM", "NUM"};
    String[] out8 = new String[]{"PER", "PER", "PER", "PER", "O", "O", "O", "O", "O", "O"};
    String[] out9 = new String[]{"PER", "PER", "FOO", "FOO", "O", "O", "O", "O", "O", "O"};
    String[] out10 = new String[]{"PER", "PER", "O", "NUM", "PROD", "PROD", "O", "O", "O", "O"};

    public void testCombination() {
        this.runTest(this.ans1, this.ans2, this.out1, "NUM");
        this.runTest(this.ans1, this.ans3, this.out1, "NUM", "PROD");
        this.runTest(this.ans4, this.ans5, this.out2, "NUM", "PROD", "ORG");
        this.runTest(this.ans5, this.ans4, this.out2, "PER");
        this.runTest(this.ans6, this.ans7, this.out3, "NUM", "PROD", "ORG");
        this.runTest(this.ans6, this.ans7, this.out2, "NUM", "PROD", "ORG", "PER");
        this.runTest(this.ans1, this.ans8, this.ans1, "NUM", "PROD", "ORG", "PER");
        this.runTest(this.ans2, this.ans9, this.out4, "NUM");
        this.runTest(this.ans9, this.ans2, this.out4, "NUM");
        this.runTest(this.ans2, this.ans10, this.out5, "NUM");
        this.runTest(this.ans10, this.ans2, this.out5, "NUM");
        this.runTest(this.ans8, this.ans11, this.ans8, "PROD");
        this.runTest(this.ans11, this.ans8, this.ans11, "PROD");
        this.runTest(this.ans12, this.ans13, this.out6, "NUM");
        this.runTest(this.ans13, this.ans12, this.out6, "NUM");
        this.runTest(this.ans12, this.ans14, this.out7, "FOO");
        this.runTest(this.ans14, this.ans12, this.out7, "NUM");
        this.runTest(this.ans4, this.ans15, this.out8, "PER");
        this.runTest(this.ans15, this.ans4, this.out8, "PER");
        this.runTest(this.ans4, this.ans16, this.out9, "FOO");
        this.runTest(this.ans16, this.ans4, this.out9, "PER");
        this.runTest(this.ans3, this.ans4, this.out10, "PER", "NUM", "PROD");
        this.runTest(this.ans4, this.ans3, this.out10, "PER", "NUM", "PROD");
        this.runTest(this.ans2, this.ans3, this.ans3, "NUM", "PROD");
    }

    public void outputResults(String[] firstInput, String[] secondInput, String[] expectedOutput, String ... labels) {
        List<CoreLabel> input1 = CoreUtilities.toCoreLabelList(this.words, this.tags, firstInput);
        List<CoreLabel> input2 = CoreUtilities.toCoreLabelList(this.words, this.tags, secondInput);
        List<CoreLabel> result = CoreUtilities.toCoreLabelList(this.words, this.tags, expectedOutput);
        HashSet<String> auxLabels = new HashSet<String>();
        for (String label : labels) {
            auxLabels.add(label);
        }
        ClassifierCombiner.mergeTwoDocuments(input1, input2, auxLabels, "O");
        for (CoreLabel word : input1) {
            System.out.println(word.word() + " " + word.tag() + " " + (String)word.get(CoreAnnotations.AnswerAnnotation.class));
        }
    }

    public void runTest(String[] firstInput, String[] secondInput, String[] expectedOutput, String ... labels) {
        List<CoreLabel> input1 = CoreUtilities.toCoreLabelList(this.words, this.tags, firstInput);
        List<CoreLabel> input2 = CoreUtilities.toCoreLabelList(this.words, this.tags, secondInput);
        List<CoreLabel> result = CoreUtilities.toCoreLabelList(this.words, this.tags, expectedOutput);
        HashSet<String> auxLabels = new HashSet<String>();
        for (String label : labels) {
            auxLabels.add(label);
        }
        ClassifierCombiner.mergeTwoDocuments(input1, input2, auxLabels, "O");
        ClassifierCombinerTest.assertEquals(result, input1);
    }
}

