/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.machinereading.Extractor;
import edu.stanford.nlp.ie.machinereading.MachineReading;
import edu.stanford.nlp.ie.machinereading.structure.AnnotationUtils;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.EntityMentionFactory;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicEntityExtractor
implements Extractor {
    private static Redwood.RedwoodChannels log = Redwood.channels(BasicEntityExtractor.class);
    private static final long serialVersionUID = -4011478706866593869L;
    private CRFClassifier<CoreLabel> classifier;
    private static final Class<? extends CoreAnnotation<String>> annotationForWord = CoreAnnotations.TextAnnotation.class;
    private static final boolean SAVE_CONLL_2003 = false;
    protected String gazetteerLocation;
    protected Set<String> annotationsToSkip;
    protected boolean useSubTypes;
    protected boolean useBIO;
    protected EntityMentionFactory entityMentionFactory;
    public final Logger logger;
    protected boolean useNERTags;

    public BasicEntityExtractor(String gazetteerLocation, boolean useSubTypes, Set<String> annotationsToSkip, boolean useBIO, EntityMentionFactory factory, boolean useNERTags) {
        this.annotationsToSkip = annotationsToSkip;
        this.gazetteerLocation = gazetteerLocation;
        this.logger = Logger.getLogger(BasicEntityExtractor.class.getName());
        this.useSubTypes = useSubTypes;
        this.useBIO = useBIO;
        this.entityMentionFactory = factory;
        this.useNERTags = useNERTags;
    }

    @Override
    public void annotate(Annotation doc) {
        List sents = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        int sentCount = 1;
        for (CoreMap sentence : sents) {
            if (this.useNERTags) {
                this.makeAnnotationFromAllNERTags(sentence);
            } else {
                this.extractEntities(sentence, sentCount);
            }
            ++sentCount;
        }
    }

    public String getEntityTypeForTag(String tag) {
        return tag;
    }

    private CoreMap extractEntities(CoreMap sentence, int sentCount) {
        List<CoreLabel> testSentence = AnnotationUtils.sentenceEntityMentionsToCoreLabels(sentence, false, this.annotationsToSkip, null, this.useSubTypes, this.useBIO);
        List<CoreLabel> annotatedSentence = this.classifier.classify(testSentence);
        this.logger.finest("CLASSFIER OUTPUT: " + annotatedSentence);
        ArrayList<EntityMention> extractedEntities = new ArrayList<EntityMention>();
        int i = 0;
        String lastType = null;
        int startIndex = -1;
        for (CoreLabel label : annotatedSentence) {
            String type = (String)label.get(CoreAnnotations.AnswerAnnotation.class);
            if (type.equals("O")) {
                type = null;
            }
            if (type == null && lastType != null) {
                this.makeEntityMention(sentence, startIndex, i, lastType, extractedEntities, sentCount);
                this.logger.info("Found entity: " + extractedEntities.get(extractedEntities.size() - 1));
                startIndex = -1;
            } else if (lastType == null && type != null) {
                startIndex = i;
            } else if (lastType != null && type != null && (type.startsWith("B-") || lastType.startsWith("I-") && type.startsWith("I-") && !lastType.equals(type) || BasicEntityExtractor.notBIO(lastType) && BasicEntityExtractor.notBIO(type) && !lastType.equals(type))) {
                this.makeEntityMention(sentence, startIndex, i, lastType, extractedEntities, sentCount);
                this.logger.info("Found entity: " + extractedEntities.get(extractedEntities.size() - 1));
                startIndex = i;
            }
            lastType = type;
            ++i;
        }
        sentence.set(MachineReadingAnnotations.EntityMentionsAnnotation.class, extractedEntities);
        this.logger.finest("EXTRACTED ENTITIES: ");
        for (EntityMention e : extractedEntities) {
            this.logger.finest("\t" + e);
        }
        this.postprocessSentence(sentence, sentCount);
        return sentence;
    }

    public void postprocessSentence(CoreMap sentence, int sentCount) {
    }

    public void makeAnnotationFromGivenNERTag(CoreMap sentence, String nerTag, String entityType) {
        List words = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        List mentions = (List)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
        assert (words != null);
        assert (mentions != null);
        for (int start = 0; start < words.size(); ++start) {
            String ne;
            int end;
            for (end = start; end < words.size() && (ne = (String)((CoreLabel)words.get(end)).get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals(nerTag); ++end) {
            }
            if (end <= start) continue;
            EntityMention m = this.entityMentionFactory.constructEntityMention(EntityMention.makeUniqueId(), sentence, new Span(start, end), new Span(start, end), entityType, null, null);
            this.logger.info("Created " + entityType + " entity mention: " + m);
            start = end - 1;
            mentions.add(m);
        }
        sentence.set(MachineReadingAnnotations.EntityMentionsAnnotation.class, mentions);
    }

    public void makeAnnotationFromAllNERTags(CoreMap sentence) {
        List words = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        ArrayList<EntityMention> mentions = (ArrayList<EntityMention>)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
        assert (words != null);
        if (mentions == null) {
            this.logger.info("mentions are null");
            mentions = new ArrayList<EntityMention>();
        }
        for (int start = 0; start < words.size(); ++start) {
            int end;
            String lastneTag = null;
            String ne = null;
            for (end = start; end < words.size() && !(ne = (String)((CoreLabel)words.get(end)).get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("O") && (lastneTag == null || ne.equals(lastneTag)); ++end) {
                lastneTag = ne;
            }
            if (end <= start) continue;
            String entityType = this.getEntityTypeForTag(lastneTag);
            EntityMention m = this.entityMentionFactory.constructEntityMention(EntityMention.makeUniqueId(), sentence, new Span(start, end), new Span(start, end), entityType, null, null);
            this.logger.info("Created " + entityType + " entity mention: " + m);
            start = end - 1;
            mentions.add(m);
        }
        sentence.set(MachineReadingAnnotations.EntityMentionsAnnotation.class, mentions);
    }

    private static boolean notBIO(String label) {
        return !label.startsWith("B-") && !label.startsWith("I-");
    }

    public void makeEntityMention(CoreMap sentence, int start, int end, String label, List<EntityMention> entities, int sentCount) {
        assert (start >= 0);
        String identifier = BasicEntityExtractor.makeEntityMentionIdentifier(sentence, sentCount, entities.size());
        EntityMention entity = this.makeEntityMention(sentence, start, end, label, identifier);
        entities.add(entity);
    }

    public static String makeEntityMentionIdentifier(CoreMap sentence, int sentCount, int entId) {
        String docid = (String)sentence.get(CoreAnnotations.DocIDAnnotation.class);
        if (docid == null) {
            docid = "EntityMention";
        }
        String identifier = docid + "-" + entId + "-" + sentCount;
        return identifier;
    }

    public EntityMention makeEntityMention(CoreMap sentence, int start, int end, String label, String identifier) {
        Span span = new Span(start, end);
        String type = null;
        String subtype = null;
        if (!label.startsWith("B-") && !label.startsWith("I-")) {
            type = label;
            subtype = null;
        } else {
            type = label.substring(2);
            subtype = null;
        }
        EntityMention entity = this.entityMentionFactory.constructEntityMention(identifier, sentence, span, span, type, subtype, null);
        ClassicCounter<String> probs = new ClassicCounter<String>();
        probs.setCount(entity.getType(), 1.0);
        entity.setTypeProbabilities(probs);
        return entity;
    }

    public void runTestSet(List<List<CoreLabel>> testSet) {
        ClassicCounter<String> tp = new ClassicCounter<String>();
        ClassicCounter<String> fp = new ClassicCounter<String>();
        ClassicCounter<String> fn = new ClassicCounter<String>();
        ClassicCounter<String> actual = new ClassicCounter<String>();
        for (List<CoreLabel> labels : testSet) {
            ArrayList<CoreLabel> unannotatedLabels = new ArrayList<CoreLabel>();
            for (CoreLabel label : labels) {
                CoreLabel newLabel = new CoreLabel();
                newLabel.set(annotationForWord, label.get(annotationForWord));
                newLabel.set(CoreAnnotations.PartOfSpeechAnnotation.class, label.get(CoreAnnotations.PartOfSpeechAnnotation.class));
                unannotatedLabels.add(newLabel);
            }
            List<CoreLabel> annotatedLabels = this.classifier.classify(unannotatedLabels);
            int ind = 0;
            for (CoreLabel expectedLabel : labels) {
                CoreLabel annotatedLabel = annotatedLabels.get(ind);
                String answer = (String)annotatedLabel.get(CoreAnnotations.AnswerAnnotation.class);
                String expectedAnswer = (String)expectedLabel.get(CoreAnnotations.AnswerAnnotation.class);
                actual.incrementCount(expectedAnswer);
                if (!"O".equals(expectedAnswer) && expectedAnswer.equals(answer)) {
                    tp.incrementCount(answer);
                    System.out.println("True Positive:" + annotatedLabel);
                } else if (!"O".equals(answer)) {
                    fp.incrementCount(answer);
                    System.out.println("False Positive:" + annotatedLabel);
                } else if (!"O".equals(expectedAnswer)) {
                    fn.incrementCount(expectedAnswer);
                    System.out.println("False Negative:" + expectedLabel);
                }
                ++ind;
            }
        }
        actual.remove("O");
    }

    public void setAnnotationsToSkip(Set<String> annotationsToSkip) {
        this.annotationsToSkip = annotationsToSkip;
    }

    @Override
    public void train(Annotation doc) {
        List<List<CoreLabel>> trainingSet = AnnotationUtils.entityMentionsToCoreLabels(doc, this.annotationsToSkip, this.useSubTypes, this.useBIO);
        this.classifier = this.createClassifier();
        if (trainingSet.size() > 0) {
            this.classifier.train(Collections.unmodifiableCollection(trainingSet));
        }
    }

    public static void saveCoNLLFiles(String dir, Annotation dataset, boolean useSubTypes, boolean alreadyBIO) throws IOException {
        List sentences = (List)dataset.get(CoreAnnotations.SentencesAnnotation.class);
        String docid = null;
        PrintStream os = null;
        for (CoreMap sentence : sentences) {
            String myDocid = (String)sentence.get(CoreAnnotations.DocIDAnnotation.class);
            if (docid == null || !myDocid.equals(docid)) {
                if (os != null) {
                    os.close();
                }
                docid = myDocid;
                os = new PrintStream(new FileOutputStream(dir + File.separator + docid + ".conll"));
            }
            List<CoreLabel> labeledSentence = AnnotationUtils.sentenceEntityMentionsToCoreLabels(sentence, true, null, null, useSubTypes, alreadyBIO);
            assert (labeledSentence != null);
            String prev = null;
            for (CoreLabel word : labeledSentence) {
                String line;
                String[] toks;
                String l;
                String w = word.word().replaceAll("[ \t\n]+", "_");
                String t = (String)word.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                String nl = l = (String)word.get(CoreAnnotations.AnswerAnnotation.class);
                if (!alreadyBIO && !l.equals("O")) {
                    nl = prev != null && l.equals(prev) ? "I-" + l : "B-" + l;
                }
                if ((toks = (line = w + " " + t + " " + nl).split("[ \t\n]+")).length != 3) {
                    throw new RuntimeException("INVALID LINE: \"" + line + "\"");
                }
                os.printf("%s %s %s\n", w, t, nl);
                prev = l;
            }
            os.println();
        }
        if (os != null) {
            os.close();
        }
    }

    public static void saveCoNLL(PrintStream os, List<List<CoreLabel>> sentences, boolean alreadyBIO) {
        os.println("-DOCSTART- -X- O\n");
        for (List<CoreLabel> sent : sentences) {
            String prev = null;
            for (CoreLabel word : sent) {
                String line;
                String[] toks;
                String l;
                String w = word.word().replaceAll("[ \t\n]+", "_");
                String t = (String)word.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                String nl = l = (String)word.get(CoreAnnotations.AnswerAnnotation.class);
                if (!alreadyBIO && !l.equals("O")) {
                    nl = prev != null && l.equals(prev) ? "I-" + l : "B-" + l;
                }
                if ((toks = (line = w + " " + t + " " + nl).split("[ \t\n]+")).length != 3) {
                    throw new RuntimeException("INVALID LINE: \"" + line + "\"");
                }
                os.printf("%s %s %s\n", w, t, nl);
                prev = l;
            }
            os.println();
        }
    }

    private CRFClassifier<CoreLabel> createClassifier() {
        Properties props = new Properties();
        props.setProperty("macro", "true");
        props.setProperty("useIfInteger", "true");
        props.setProperty("featureFactory", "edu.stanford.nlp.ie.NERFeatureFactory");
        props.setProperty("saveFeatureIndexToDisk", "false");
        if (this.gazetteerLocation != null) {
            log.info("Using gazetteer: " + this.gazetteerLocation);
            props.setProperty("gazette", this.gazetteerLocation);
            props.setProperty("sloppyGazette", "true");
        }
        return new CRFClassifier<CoreLabel>(props);
    }

    public static BasicEntityExtractor load(String path, Class<? extends BasicEntityExtractor> entityClassifier, boolean preferDefaultGazetteer) throws ClassCastException, IOException, ClassNotFoundException {
        InputStream is = BasicEntityExtractor.class.getClassLoader().getResourceAsStream(path + ".extra");
        if (is == null) {
            is = new FileInputStream(path + ".extra");
        }
        ObjectInputStream in = new ObjectInputStream(is);
        String gazetteerLocation = (String)ErasureUtils.uncheckedCast(in.readObject());
        if (preferDefaultGazetteer) {
            gazetteerLocation = "edu/stanford/nlp/models/machinereading/nfl/NFLgazetteer.txt";
        }
        Set annotationsToSkip = (Set)ErasureUtils.uncheckedCast(in.readObject());
        Boolean useSubTypes = (Boolean)ErasureUtils.uncheckedCast(in.readObject());
        Boolean useBIO = (Boolean)ErasureUtils.uncheckedCast(in.readObject());
        in.close();
        is.close();
        BasicEntityExtractor extractor = (BasicEntityExtractor)MachineReading.makeEntityExtractor(entityClassifier, gazetteerLocation);
        extractor.classifier = CRFClassifier.getClassifier(path);
        extractor.annotationsToSkip = annotationsToSkip;
        extractor.useSubTypes = useSubTypes;
        extractor.useBIO = useBIO;
        return extractor;
    }

    @Override
    public void save(String path) throws IOException {
        this.classifier.serializeClassifier(path);
        FileOutputStream fos = new FileOutputStream(path + ".extra");
        ObjectOutputStream out2 = new ObjectOutputStream(fos);
        out2.writeObject(this.gazetteerLocation);
        out2.writeObject(this.annotationsToSkip);
        out2.writeObject(this.useSubTypes);
        out2.writeObject(this.useBIO);
        out2.close();
    }

    public static String labeledSentenceToString(List<CoreLabel> labeledSentence, boolean printNer) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (CoreLabel label : labeledSentence) {
            String word = label.getString(annotationForWord);
            String answer = label.getString(CoreAnnotations.AnswerAnnotation.class);
            String tag = label.getString(CoreAnnotations.PartOfSpeechAnnotation.class);
            sb.append(word).append("(").append(tag);
            if (!"O".equals(answer)) {
                sb.append(" ").append(answer);
            }
            if (printNer) {
                sb.append(" ner:").append(label.ner());
            }
            sb.append(") ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setLoggerLevel(Level level) {
        this.logger.setLevel(level);
    }
}

