/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.structure;

import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.EventMention;
import edu.stanford.nlp.ie.machinereading.structure.ExtractionObject;
import edu.stanford.nlp.ie.machinereading.structure.RelationMentionFactory;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IdentityHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class RelationMention
extends ExtractionObject {
    private static final long serialVersionUID = 8962289597607972827L;
    public static final Logger logger = Logger.getLogger(RelationMention.class.getName());
    private static int MENTION_COUNTER = 0;
    public static final String UNRELATED = "_NR";
    protected List<String> argNames;
    protected List<ExtractionObject> args;
    protected String signature;

    public RelationMention(String objectId, CoreMap sentence, Span span, String type, String subtype, List<ExtractionObject> args) {
        super(objectId, sentence, span, type, subtype);
        this.args = args;
        this.argNames = null;
        this.signature = null;
    }

    public RelationMention(String objectId, CoreMap sentence, Span span, String type, String subtype, List<ExtractionObject> args, List<String> argNames) {
        super(objectId, sentence, span, type, subtype);
        this.args = args;
        this.argNames = argNames;
        this.signature = null;
    }

    public RelationMention(String objectId, CoreMap sentence, Span span, String type, String subtype, ExtractionObject ... args) {
        this(objectId, sentence, span, type, subtype, Arrays.asList(args));
    }

    public boolean argsMatch(RelationMention rel) {
        return this.argsMatch(rel.getArgs());
    }

    public boolean argsMatch(ExtractionObject ... inputArgs) {
        return this.argsMatch(Arrays.asList(inputArgs));
    }

    public boolean argsMatch(List<ExtractionObject> inputArgs) {
        if (inputArgs.size() != this.args.size()) {
            return false;
        }
        for (int ind = 0; ind < this.args.size(); ++ind) {
            ExtractionObject a2;
            ExtractionObject a1 = this.args.get(ind);
            if (a1.equals(a2 = inputArgs.get(ind))) continue;
            return false;
        }
        return true;
    }

    public List<ExtractionObject> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public void setArgs(List<ExtractionObject> args) {
        this.args = args;
    }

    public List<EntityMention> getEntityMentionArgs() {
        ArrayList<EntityMention> ents = new ArrayList<EntityMention>();
        for (ExtractionObject o : this.args) {
            if (!(o instanceof EntityMention)) continue;
            ents.add((EntityMention)o);
        }
        return ents;
    }

    public ExtractionObject getArg(int argpos) {
        return this.args.get(argpos);
    }

    public List<String> getArgNames() {
        return this.argNames;
    }

    public void setArgNames(List<String> argNames) {
        this.argNames = argNames;
    }

    public void addArg(ExtractionObject a) {
        this.args.add(a);
    }

    public boolean isNegativeRelation() {
        return RelationMention.isUnrelatedLabel(this.getType());
    }

    public int getFirstSyntacticHeadPosition() {
        int pos = Integer.MAX_VALUE;
        for (ExtractionObject obj : this.args) {
            EntityMention em;
            if (!(obj instanceof EntityMention) || (em = (EntityMention)obj).getSyntacticHeadTokenPosition() >= pos) continue;
            pos = em.getSyntacticHeadTokenPosition();
        }
        if (pos != Integer.MAX_VALUE) {
            return pos;
        }
        return -1;
    }

    public int getLastSyntacticHeadPosition() {
        int pos = Integer.MIN_VALUE;
        for (ExtractionObject obj : this.args) {
            EntityMention em;
            if (!(obj instanceof EntityMention) || (em = (EntityMention)obj).getSyntacticHeadTokenPosition() <= pos) continue;
            pos = em.getSyntacticHeadTokenPosition();
        }
        if (pos != Integer.MIN_VALUE) {
            return pos;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RelationMention [type=" + this.type + (this.subType != null ? ", subType=" + this.subType : "") + ", start=" + this.getExtentTokenStart() + ", end=" + this.getExtentTokenEnd());
        if (this.typeProbabilities != null) {
            sb.append(", " + this.probsToString());
        }
        if (this.args != null) {
            for (int i = 0; i < this.args.size(); ++i) {
                sb.append("\n\t");
                if (this.argNames != null) {
                    sb.append(this.argNames.get(i) + " ");
                }
                sb.append(this.args.get(i));
            }
        }
        sb.append("\n]");
        return sb.toString();
    }

    public boolean replaceGoldArgsWithPredicted(List<EntityMention> predictedMentions) {
        ArrayList<ExtractionObject> newArgs = new ArrayList<ExtractionObject>();
        for (ExtractionObject arg : this.args) {
            if (!(arg instanceof EntityMention)) continue;
            EntityMention goldEnt = (EntityMention)arg;
            EntityMention newArg = null;
            for (EntityMention pred : predictedMentions) {
                if (!goldEnt.textEquals(pred)) continue;
                newArg = pred;
                break;
            }
            if (newArg != null) {
                newArgs.add(newArg);
                logger.info("Replacing relation argument: [" + goldEnt + "] with predicted mention [" + newArg + "]");
                continue;
            }
            newArgs.add(goldEnt);
            predictedMentions.add(goldEnt);
            logger.info("Failed to match relation argument, so keeping gold: " + goldEnt);
        }
        this.args = newArgs;
        return true;
    }

    public void removeArgument(ExtractionObject argToRemove, boolean removeParent) {
        IdentityHashSet<ExtractionObject> thisEvent = new IdentityHashSet<ExtractionObject>();
        thisEvent.add(argToRemove);
        this.removeArguments(thisEvent, removeParent);
    }

    public void removeArguments(Set<ExtractionObject> argsToRemove, boolean removeParent) {
        ArrayList<ExtractionObject> newArgs = new ArrayList<ExtractionObject>();
        ArrayList<String> newArgNames = new ArrayList<String>();
        for (int i = 0; i < this.args.size(); ++i) {
            ExtractionObject a = this.args.get(i);
            String n = this.argNames.get(i);
            if (!argsToRemove.contains(a)) {
                newArgs.add(a);
                newArgNames.add(n);
                continue;
            }
            if (!(a instanceof EventMention) || !removeParent) continue;
            ((EventMention)a).removeParent(this);
        }
        this.args = newArgs;
        this.argNames = newArgNames;
    }

    public boolean printableObject(double beam) {
        return this.printableObject(beam, UNRELATED);
    }

    public void setSignature(String s) {
        this.signature = s;
    }

    public String getSignature() {
        return this.signature;
    }

    public static Collection<RelationMention> filterUnrelatedRelations(Collection<RelationMention> relationMentions) {
        ArrayList<RelationMention> filtered = new ArrayList<RelationMention>();
        for (RelationMention relation : relationMentions) {
            if (relation.getType().equals(UNRELATED)) continue;
            filtered.add(relation);
        }
        return filtered;
    }

    public static synchronized String makeUniqueId() {
        return "RelationMention-" + ++MENTION_COUNTER;
    }

    public static RelationMention createUnrelatedRelation(RelationMentionFactory factory, ExtractionObject ... args) {
        return RelationMention.createUnrelatedRelation(factory, "", args);
    }

    private static RelationMention createUnrelatedRelation(RelationMentionFactory factory, String type, ExtractionObject ... args) {
        return factory.constructRelationMention(RelationMention.makeUniqueId(), args[0].getSentence(), ExtractionObject.getSpan(args), UNRELATED + type, null, Arrays.asList(args), null);
    }

    public static boolean isUnrelatedLabel(String label) {
        return label.startsWith(UNRELATED);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationMention)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RelationMention that = (RelationMention)o;
        if (this.argNames != null ? !this.argNames.equals(that.argNames) : that.argNames != null) {
            return false;
        }
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        return !(this.signature != null ? !this.signature.equals(that.signature) : that.signature != null);
    }

    public int hashCode() {
        int result = this.argNames != null ? this.argNames.hashCode() : 0;
        result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
        result = 31 * result + (this.signature != null ? this.signature.hashCode() : 0);
        return result;
    }
}

