/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.process;

import edu.stanford.nlp.international.arabic.process.ArabicSegmenterFeatureFactory;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.PaddedList;
import java.util.Collection;

public class StartAndEndArabicSegmenterFeatureFactory<IN extends CoreLabel>
extends ArabicSegmenterFeatureFactory<IN> {
    private static final long serialVersionUID = 6864940988019110930L;

    @Override
    public void init(SeqClassifierFlags flags) {
        super.init(flags);
    }

    @Override
    protected Collection<String> featuresCpC(PaddedList<IN> cInfo, int loc) {
        Collection<String> features = super.featuresCpC(cInfo, loc);
        CoreLabel c = (CoreLabel)cInfo.get(loc);
        if (c.word().length() > 3) {
            String start = c.word().substring(0, 2);
            String end = c.word().substring(c.word().length() - 2);
            if (c.index() == 2) {
                features.add(start + "_" + end + "-begin-wrap");
            }
            if (c.index() == c.word().length() - 1) {
                features.add(start + "_" + end + "-end-wrap");
            }
        }
        return features;
    }
}

