/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.MultiWordStringMatcher;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.StringUtils;
import java.util.List;
import junit.framework.TestCase;

public class MultiWordStringMatcherTest
extends TestCase {
    public void testExctWsMatching() throws Exception {
        MultiWordStringMatcher entityMatcher = new MultiWordStringMatcher(MultiWordStringMatcher.MatchType.EXCTWS);
        String targetString = "Al-Ahram";
        String context = "the government Al-Ahram newspaper";
        List<IntPair> offsets = entityMatcher.findTargetStringOffsets(context, targetString);
        MultiWordStringMatcherTest.assertEquals((String)"entityOffsets", (String)"[15 23]", (String)("[" + StringUtils.join(offsets, ",") + "]"));
        context = "the government Al- Ahram newspaper";
        offsets = entityMatcher.findTargetStringOffsets(context, targetString);
        MultiWordStringMatcherTest.assertEquals((String)"entityOffsets", (String)"[15 24]", (String)("[" + StringUtils.join(offsets, ",") + "]"));
        targetString = "Al -Ahram";
        offsets = entityMatcher.findTargetStringOffsets(context, targetString);
        MultiWordStringMatcherTest.assertTrue((String)"entityOffsets", (offsets == null || offsets.isEmpty() ? 1 : 0) != 0);
        context = "the government Al-Ahramnewspaper";
        offsets = entityMatcher.findTargetStringOffsets(context, targetString);
        MultiWordStringMatcherTest.assertTrue((String)"entityOffsets", (offsets == null || offsets.isEmpty() ? 1 : 0) != 0);
        context = "the government AlAhram newspaper";
        offsets = entityMatcher.findTargetStringOffsets(context, targetString);
        MultiWordStringMatcherTest.assertTrue((String)"entityOffsets", (offsets == null || offsets.isEmpty() ? 1 : 0) != 0);
        context = "the government alahram newspaper";
        offsets = entityMatcher.findTargetStringOffsets(context, targetString);
        MultiWordStringMatcherTest.assertTrue((String)"entityOffsets", (offsets == null || offsets.isEmpty() ? 1 : 0) != 0);
        context = "NZ Oil &amp;amp; Gas";
        targetString = "NZ Oil &amp;amp; Gas";
        offsets = entityMatcher.findTargetStringOffsets(context, targetString);
        MultiWordStringMatcherTest.assertEquals((String)"entityOffsets", (String)"[0 20]", (String)("[" + StringUtils.join(offsets, ",") + "]"));
    }

    public void testLnrmMatching() throws Exception {
        MultiWordStringMatcher entityMatcher = new MultiWordStringMatcher(MultiWordStringMatcher.MatchType.LNRM);
        String entityName = "Al-Ahram";
        String context = "the government Al-Ahram newspaper";
        List<IntPair> offsets = entityMatcher.findTargetStringOffsets(context, entityName);
        MultiWordStringMatcherTest.assertEquals((String)"entityOffsets", (String)"[15 23]", (String)("[" + StringUtils.join(offsets, ",") + "]"));
        context = "the government Al- Ahram newspaper";
        offsets = entityMatcher.findTargetStringOffsets(context, entityName);
        MultiWordStringMatcherTest.assertEquals((String)"entityOffsets", (String)"[15 24]", (String)("[" + StringUtils.join(offsets, ",") + "]"));
        entityName = "Al -Ahram";
        offsets = entityMatcher.findTargetStringOffsets(context, entityName);
        MultiWordStringMatcherTest.assertEquals((String)"entityOffsets", (String)"[15 24]", (String)("[" + StringUtils.join(offsets, ",") + "]"));
        context = "the government Al-Ahramnewspaper";
        offsets = entityMatcher.findTargetStringOffsets(context, entityName);
        MultiWordStringMatcherTest.assertTrue((String)"entityOffsets", (offsets == null || offsets.isEmpty() ? 1 : 0) != 0);
        context = "the government AlAhram newspaper";
        offsets = entityMatcher.findTargetStringOffsets(context, entityName);
        MultiWordStringMatcherTest.assertEquals((String)"entityOffsets", (String)"[15 22]", (String)("[" + StringUtils.join(offsets, ",") + "]"));
        context = "the government alahram newspaper";
        offsets = entityMatcher.findTargetStringOffsets(context, entityName);
        MultiWordStringMatcherTest.assertEquals((String)"entityOffsets", (String)"[15 22]", (String)("[" + StringUtils.join(offsets, ",") + "]"));
    }
}

