/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocDateAnnotator
implements Annotator {
    public static String DOC_DATE_FIXED_PROPERTY = "useFixedDate";
    public static String DOC_DATE_MAPPING_FILE_PROPERTY = "useMappingFile";
    public static String DOC_DATE_PRESENT_PROPERTY = "usePresent";
    public static String DOC_DATE_REGEX_PROPERTY = "useRegex";
    public static Pattern DATE_PROPER_FORMAT = Pattern.compile("[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}");
    public static Pattern DATE_NO_HYPHENS_PATTERN = Pattern.compile("[0-9]{8}");
    public boolean useFixedDate = false;
    public boolean useMappingFile = false;
    public boolean usePresentDate = false;
    public boolean useRegex = false;
    public String fixedDate;
    public HashMap<String, String> docIDToDocDate;
    public Pattern fileDocDatePattern;

    public DocDateAnnotator(String name, Properties props) throws IOException {
        this.useFixedDate = props.containsKey(name + "." + DOC_DATE_FIXED_PROPERTY);
        this.useMappingFile = props.containsKey(name + "." + DOC_DATE_MAPPING_FILE_PROPERTY);
        this.usePresentDate = PropertiesUtils.getBool(props, name + "." + DOC_DATE_PRESENT_PROPERTY, false);
        this.useRegex = props.containsKey(name + "." + DOC_DATE_REGEX_PROPERTY);
        if (this.useMappingFile) {
            String mappingFilePath = props.getProperty(name + "." + DOC_DATE_MAPPING_FILE_PROPERTY);
            this.docIDToDocDate = new HashMap();
            List<String> mappingEntries = IOUtils.linesFromFile(mappingFilePath);
            for (String fileNameAndDocDate : mappingEntries) {
                String[] keyAndValue = fileNameAndDocDate.split("\t");
                this.docIDToDocDate.put(keyAndValue[0], keyAndValue[1]);
            }
        } else if (this.useFixedDate) {
            this.fixedDate = props.getProperty(name + "." + DOC_DATE_FIXED_PROPERTY);
        } else if (this.useRegex) {
            this.fileDocDatePattern = Pattern.compile(props.getProperty(name + "." + DOC_DATE_REGEX_PROPERTY));
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        Matcher properDateFormat;
        String foundDocDate;
        String docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docID == null) {
            docID = "";
        }
        if (this.useMappingFile) {
            foundDocDate = this.docIDToDocDate.get(docID);
            if (foundDocDate == null) {
                foundDocDate = "";
            }
        } else if (this.useFixedDate) {
            foundDocDate = this.fixedDate;
        } else if (this.usePresentDate) {
            foundDocDate = this.currentDate();
        } else if (this.useRegex) {
            Matcher m = this.fileDocDatePattern.matcher(docID);
            m.matches();
            foundDocDate = m.group(1);
            if (DATE_NO_HYPHENS_PATTERN.matcher(foundDocDate).find() && foundDocDate.length() == 8) {
                foundDocDate = DocDateAnnotator.addHyphensToDate(foundDocDate);
            }
        } else {
            foundDocDate = "";
        }
        if ((properDateFormat = DATE_PROPER_FORMAT.matcher(foundDocDate)).matches()) {
            annotation.set(CoreAnnotations.DocDateAnnotation.class, foundDocDate);
        }
    }

    public String currentDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
    }

    private static String addHyphensToDate(String compactDateString) {
        String yyyy = compactDateString.substring(0, 4);
        String mm = compactDateString.substring(4, 6);
        String dd = compactDateString.substring(6, 8);
        return yyyy + '-' + mm + '-' + dd;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.emptySet();
    }
}

