/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class RequirementsCorrectSlowITest {
    private String dummyString = "Joe said his car would be fixed on June 7, 1987  after 2 hours of work. He also said this document is nonsense. Joe was born in Hawaii. Joe said \"I'm going to get my car fixed.\"";

    private void testAnnotatorSequence(final List<String> annotators) {
        HashSet keysRead = new HashSet();
        ArrayCoreMap.listener = keysRead::add;
        Annotation ann = new Annotation(this.dummyString);
        for (int annotatorI = 0; annotatorI < annotators.size(); ++annotatorI) {
            keysRead.clear();
            final String annotatorName = annotators.get(annotatorI);
            System.err.println("Running " + annotatorName);
            StanfordCoreNLP corenlp = new StanfordCoreNLP(new Properties(){
                {
                    this.setProperty("annotators", annotatorName);
                    this.setProperty("enforceRequirements", "false");
                }
            });
            corenlp.annotate(ann);
            Annotator annotator = StanfordCoreNLP.getExistingAnnotator(annotatorName);
            Assert.assertNotNull((Object)annotator);
            Set<Class<? extends CoreAnnotation>> declared = annotator.requires();
            HashSet<Class<CoreAnnotations.ValueAnnotation>> used = new HashSet<Class<CoreAnnotations.ValueAnnotation>>(keysRead);
            used.removeAll(annotator.requirementsSatisfied());
            if (annotatorName.equals("ner")) {
                used.remove(CoreAnnotations.GoldAnswerAnnotation.class);
                used.remove(CoreAnnotations.NamedEntityTagProbsAnnotation.class);
                used.remove(CoreAnnotations.AnswerProbAnnotation.class);
            }
            if (annotatorName.equals("quote")) {
                used.remove(CoreAnnotations.SentenceBeginAnnotation.class);
                used.remove(CoreAnnotations.SentenceEndAnnotation.class);
            }
            if (annotatorName.equals("coref")) {
                used.remove(CorefCoreAnnotations.CorefMentionsAnnotation.class);
                used.remove(CoreAnnotations.ParagraphAnnotation.class);
                used.remove(CoreAnnotations.SpeakerAnnotation.class);
                used.remove(CoreAnnotations.UtteranceAnnotation.class);
                used.remove(TreeCoreAnnotations.TreeAnnotation.class);
                used.remove(CoreAnnotations.CategoryAnnotation.class);
                used.remove(CorefCoreAnnotations.CorefMentionIndexesAnnotation.class);
                used.remove(CoreAnnotations.EntityMentionToCorefMentionMappingAnnotation.class);
                used.remove(CoreAnnotations.CorefMentionToEntityMentionMappingAnnotation.class);
                if (!used.contains(CoreAnnotations.ValueAnnotation.class)) {
                    used.add(CoreAnnotations.ValueAnnotation.class);
                }
            }
            if (annotatorI <= 0) continue;
            if (!declared.equals(used)) {
                System.err.println("ANNOTATOR " + annotatorName);
                System.err.println("Used but not declared:");
                for (Class<? extends CoreAnnotation> key : CollectionUtils.diffAsSet(used, declared)) {
                    System.err.println("  " + key);
                }
                System.err.println("Declared but not Used:");
                for (Class<? extends CoreAnnotation> key : CollectionUtils.diffAsSet(declared, used)) {
                    System.err.println("  " + key);
                }
            }
            Assert.assertEquals(declared, used);
        }
        StanfordCoreNLP corenlp = new StanfordCoreNLP(new Properties(){
            {
                this.setProperty("annotators", StringUtils.join(annotators, ","));
            }
        });
        corenlp.annotate(ann);
    }

    @Test
    public void testDefaultPipeline() {
        this.testAnnotatorSequence(Arrays.asList("tokenize", "ssplit", "pos", "lemma", "ner", "gender", "parse", "coref"));
    }

    @Test
    public void testDepparsePipeline() {
        this.testAnnotatorSequence(Arrays.asList("tokenize", "ssplit", "pos", "depparse"));
    }

    @Test
    public void testQuotePipeline() {
        this.testAnnotatorSequence(Arrays.asList("tokenize", "ssplit", "pos", "lemma", "ner", "depparse", "coref", "quote"));
    }

    @Test
    public void testTrueCasePipeline() {
        this.testAnnotatorSequence(Arrays.asList("tokenize", "ssplit", "pos", "lemma", "truecase"));
    }

    @Test
    public void testOpenIEPipeline() {
        this.testAnnotatorSequence(Arrays.asList("tokenize", "ssplit", "pos", "lemma", "depparse", "natlog", "openie"));
    }

    @Test
    public void testMentionRegression() {
        this.testAnnotatorSequence(Arrays.asList(new String[0]));
    }
}

