/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.theories.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.javaruntype.type.Types;
import org.junit.Assume;
import org.junit.contrib.theories.DataPoint;
import org.junit.contrib.theories.DataPoints;
import org.junit.contrib.theories.ParameterSignature;
import org.junit.contrib.theories.ParameterSupplier;
import org.junit.contrib.theories.PotentialAssignment;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllMembersSupplier
extends ParameterSupplier {
    private final TestClass fClass;

    public AllMembersSupplier(TestClass type) {
        this.fClass = type;
    }

    @Override
    public List<PotentialAssignment> getValueSources(ParameterSignature sig) throws Throwable {
        ArrayList<PotentialAssignment> assignments = new ArrayList<PotentialAssignment>();
        this.addSinglePointFields(sig, assignments);
        this.addMultiPointFields(sig, assignments);
        this.addSinglePointMethods(sig, assignments);
        this.addMultiPointMethods(sig, assignments);
        return assignments;
    }

    private void addMultiPointMethods(ParameterSignature sig, List<PotentialAssignment> assignments) throws Throwable {
        for (FrameworkMethod each : this.getDataPointsMethods(sig)) {
            org.javaruntype.type.Type type = Types.forJavaLangReflectType((Type)each.getMethod().getGenericReturnType());
            if ((!type.isArray() || !sig.canPotentiallyAcceptType(type.getComponentClass())) && !Types.forJavaLangReflectType(Iterable.class).isAssignableFrom(type)) continue;
            try {
                this.addDataPointsValues(type, sig, each.getName(), assignments, each.invokeExplosively(null, new Object[0]));
            }
            catch (Throwable e) {
                DataPoints annotation = (DataPoints)each.getAnnotation(DataPoints.class);
                if (annotation != null && AllMembersSupplier.isAssignableToAnyOf(annotation.ignoredExceptions(), e)) {
                    return;
                }
                throw e;
            }
        }
    }

    private void addSinglePointMethods(ParameterSignature sig, List<PotentialAssignment> assignments) {
        for (FrameworkMethod each : this.getSingleDataPointMethods(sig)) {
            if (!sig.canAcceptType(each.getMethod().getGenericReturnType())) continue;
            assignments.add(new MethodParameterValue(each));
        }
    }

    private void addMultiPointFields(ParameterSignature sig, List<PotentialAssignment> assignments) {
        for (Field each : this.getDataPointsFields(sig)) {
            this.addDataPointsValues(Types.forJavaLangReflectType((Type)each.getGenericType()), sig, each.getName(), assignments, this.getStaticFieldValue(each));
        }
    }

    private void addSinglePointFields(ParameterSignature sig, List<PotentialAssignment> assignments) {
        for (Field each : this.getSingleDataPointFields(sig)) {
            Object value = this.getStaticFieldValue(each);
            if (!sig.canAcceptType(each.getGenericType())) continue;
            assignments.add(PotentialAssignment.forValue(each.getName(), value));
        }
    }

    private void addDataPointsValues(org.javaruntype.type.Type<?> type, ParameterSignature sig, String name, List<PotentialAssignment> assignments, Object value) {
        if (type.isArray()) {
            this.addArrayValues(sig, name, assignments, value);
        } else if (Types.forJavaLangReflectType(Iterable.class).isAssignableFrom(type)) {
            this.addIterableValues(sig, name, assignments, (Iterable)value);
        }
    }

    private void addArrayValues(ParameterSignature sig, String name, List<PotentialAssignment> assignments, Object array) {
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object value = Array.get(array, i);
            if (!sig.canAcceptValue(value)) continue;
            assignments.add(PotentialAssignment.forValue(name + "[" + i + "]", value));
        }
    }

    private void addIterableValues(ParameterSignature sig, String name, List<PotentialAssignment> assignments, Iterable<?> iterable) {
        Iterator<?> iterator = iterable.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (sig.canAcceptValue(value)) {
                assignments.add(PotentialAssignment.forValue(name + "[" + i + "]", value));
            }
            ++i;
        }
    }

    private Object getStaticFieldValue(Field field) {
        try {
            return field.get(null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("unexpected: field from getClass doesn't exist on object");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unexpected: getFields returned an inaccessible field");
        }
    }

    private static boolean isAssignableToAnyOf(Class<?>[] types, Object target) {
        for (Class<?> each : types) {
            if (!each.isAssignableFrom(target.getClass())) continue;
            return true;
        }
        return false;
    }

    protected Collection<FrameworkMethod> getDataPointsMethods(ParameterSignature sig) {
        return this.fClass.getAnnotatedMethods(DataPoints.class);
    }

    protected Collection<Field> getSingleDataPointFields(ParameterSignature sig) {
        ArrayList<Field> validFields = new ArrayList<Field>();
        for (FrameworkField each : this.fClass.getAnnotatedFields(DataPoint.class)) {
            validFields.add(each.getField());
        }
        return validFields;
    }

    protected Collection<Field> getDataPointsFields(ParameterSignature sig) {
        ArrayList<Field> validFields = new ArrayList<Field>();
        for (FrameworkField each : this.fClass.getAnnotatedFields(DataPoints.class)) {
            validFields.add(each.getField());
        }
        return validFields;
    }

    protected Collection<FrameworkMethod> getSingleDataPointMethods(ParameterSignature sig) {
        return this.fClass.getAnnotatedMethods(DataPoint.class);
    }

    static class MethodParameterValue
    extends PotentialAssignment {
        private final FrameworkMethod fMethod;

        private MethodParameterValue(FrameworkMethod dataPointMethod) {
            this.fMethod = dataPointMethod;
        }

        public Object getValue() throws PotentialAssignment.CouldNotGenerateValueException {
            try {
                return this.fMethod.invokeExplosively(null, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("unexpected: argument length is checked");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("unexpected: getMethods returned an inaccessible method");
            }
            catch (Throwable throwable) {
                DataPoint annotation = (DataPoint)this.fMethod.getAnnotation(DataPoint.class);
                Assume.assumeTrue((annotation == null || !AllMembersSupplier.isAssignableToAnyOf(annotation.ignoredExceptions(), throwable) ? 1 : 0) != 0);
                throw new PotentialAssignment.CouldNotGenerateValueException(throwable);
            }
        }

        public String getDescription() throws PotentialAssignment.CouldNotGenerateValueException {
            return this.fMethod.getName();
        }
    }
}

