/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderTran;
import org.ejml.alg.dense.linsol.LinearSolverAbstract;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.SpecializedOps;

public class LinearSolverQrHouseTran
extends LinearSolverAbstract {
    private QRDecompositionHouseholderTran decomposer = new QRDecompositionHouseholderTran();
    private double[] a;
    protected int maxRows = -1;
    protected int maxCols = -1;
    private DenseMatrix64F QR;
    private DenseMatrix64F U;

    public void setMaxSize(int n, int n2) {
        this.maxRows = n;
        this.maxCols = n2;
        this.a = new double[n];
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows > this.maxRows || denseMatrix64F.numCols > this.maxCols) {
            this.setMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        }
        this._setA(denseMatrix64F);
        if (!this.decomposer.decompose(denseMatrix64F)) {
            return false;
        }
        this.QR = this.decomposer.getQR();
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(true, this.QR);
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X: X rows = " + denseMatrix64F2.numRows + " expected = " + this.numCols);
        }
        if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != denseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        this.U = this.decomposer.getR(this.U, true);
        double[] dArray = this.decomposer.getGammas();
        double[] dArray2 = this.QR.data;
        int n = denseMatrix64F.numCols;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < this.numRows; ++n2) {
                this.a[n2] = denseMatrix64F.data[n2 * n + i];
            }
            for (n2 = 0; n2 < this.numCols; ++n2) {
                int n3 = n2 * this.numRows + n2 + 1;
                double d = this.a[n2];
                int n4 = n2 + 1;
                while (n4 < this.numRows) {
                    d += dArray2[n3] * this.a[n4];
                    ++n4;
                    ++n3;
                }
                int n5 = n2;
                this.a[n5] = this.a[n5] - (d *= dArray[n2]);
                n3 = n2 * this.numRows + n2 + 1;
                n4 = n2 + 1;
                while (n4 < this.numRows) {
                    int n6 = n4++;
                    this.a[n6] = this.a[n6] - dArray2[n3] * d;
                    ++n3;
                }
            }
            TriangularSolver.solveU(this.U.data, this.a, this.numCols);
            for (n2 = 0; n2 < this.numCols; ++n2) {
                denseMatrix64F2.data[n2 * denseMatrix64F2.numCols + i] = this.a[n2];
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

