/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.Locale;
import java.util.Properties;

public class CorefProperties {
    public static final String OUTPUT_PATH_PROP = "coref.conllOutputPath";

    private CorefProperties() {
    }

    public static CorefAlgorithmType algorithm(Properties props) {
        String type = PropertiesUtils.getString(props, "coref.algorithm", CorefProperties.getLanguage(props) == Locale.ENGLISH ? "statistical" : "neural");
        return CorefAlgorithmType.valueOf(type.toUpperCase());
    }

    public static boolean conll(Properties props) {
        return PropertiesUtils.getBool(props, "coref.conll", false);
    }

    public static boolean useConstituencyParse(Properties props) {
        return PropertiesUtils.getBool(props, "coref.useConstituencyParse", CorefProperties.algorithm(props) != CorefAlgorithmType.STATISTICAL || CorefProperties.conll(props));
    }

    public static boolean verbose(Properties props) {
        return PropertiesUtils.getBool(props, "coref.verbose", false);
    }

    public static boolean removeSingletonClusters(Properties props) {
        return PropertiesUtils.getBool(props, "coref.removeSingletonClusters", true);
    }

    public static int maxMentionDistance(Properties props) {
        return PropertiesUtils.getInt(props, "coref.maxMentionDistance", CorefProperties.conll(props) ? Integer.MAX_VALUE : 50);
    }

    public static int maxMentionDistanceWithStringMatch(Properties props) {
        return PropertiesUtils.getInt(props, "coref.maxMentionDistanceWithStringMatch", 500);
    }

    public static MentionDetectionType mdType(Properties props) {
        String type = PropertiesUtils.getString(props, "coref.md.type", CorefProperties.useConstituencyParse(props) ? "RULE" : "dep");
        if (type.equalsIgnoreCase("dep")) {
            type = "DEPENDENCY";
        }
        return MentionDetectionType.valueOf(type.toUpperCase());
    }

    public static String getMentionDetectionModel(Properties props) {
        return PropertiesUtils.getString(props, "coref.md.model", CorefProperties.useConstituencyParse(props) ? "edu/stanford/nlp/models/coref/md-model.ser" : "edu/stanford/nlp/models/coref/md-model-dep.ser.gz");
    }

    public static boolean isMentionDetectionTraining(Properties props) {
        return PropertiesUtils.getBool(props, "coref.md.isTraining", false);
    }

    public static void setMentionDetectionTraining(Properties props, boolean val) {
        props.setProperty("coref.md.isTraining", String.valueOf(val));
    }

    public static boolean removeNestedMentions(Properties props) {
        return PropertiesUtils.getBool(props, "removeNestedMentions", true);
    }

    public static void setRemoveNestedMentions(Properties props, boolean val) {
        props.setProperty("removeNestedMentions", String.valueOf(val));
    }

    public static boolean liberalMD(Properties props) {
        return PropertiesUtils.getBool(props, "coref.md.liberalMD", false);
    }

    public static boolean useGoldMentions(Properties props) {
        return PropertiesUtils.getBool(props, "coref.md.useGoldMentions", false);
    }

    public static String conllOutputPath(Properties props) {
        String returnPath = props.getProperty(OUTPUT_PATH_PROP, "/u/scr/nlp/coref/logs/");
        if (!returnPath.endsWith("/")) {
            returnPath = returnPath + "/";
        }
        return returnPath;
    }

    public static void setInput(Properties props, Dataset d) {
        props.setProperty("coref.inputPath", d == Dataset.TRAIN ? CorefProperties.getTrainDataPath(props) : (d == Dataset.DEV ? CorefProperties.getDevDataPath(props) : CorefProperties.getTestDataPath(props)));
    }

    private static String getDataPath(Properties props) {
        String returnPath = props.getProperty("coref.data", "/u/scr/nlp/data/conll-2012/");
        if (!returnPath.endsWith("/")) {
            returnPath = returnPath + "/";
        }
        return returnPath;
    }

    public static String getTrainDataPath(Properties props) {
        return props.getProperty("coref.trainData", CorefProperties.getDataPath(props) + "v4/data/train/data/" + CorefProperties.getLanguageStr(props) + "/annotations/");
    }

    public static String getDevDataPath(Properties props) {
        return props.getProperty("coref.devData", CorefProperties.getDataPath(props) + "v4/data/development/data/" + CorefProperties.getLanguageStr(props) + "/annotations/");
    }

    public static String getTestDataPath(Properties props) {
        return props.getProperty("coref.testData", CorefProperties.getDataPath(props) + "v9/data/test/data/" + CorefProperties.getLanguageStr(props) + "/annotations");
    }

    public static String getInputPath(Properties props) {
        String input = props.getProperty("coref.inputPath", CorefProperties.getTestDataPath(props));
        return input;
    }

    public static String getScorerPath(Properties props) {
        return props.getProperty("coref.scorer", "/u/scr/nlp/data/conll-2012/scorer/v8.01/scorer.pl");
    }

    public static Locale getLanguage(Properties props) {
        String lang = PropertiesUtils.getString(props, "coref.language", "en");
        if (lang.equalsIgnoreCase("en") || lang.equalsIgnoreCase("english")) {
            return Locale.ENGLISH;
        }
        if (lang.equalsIgnoreCase("zh") || lang.equalsIgnoreCase("chinese")) {
            return Locale.CHINESE;
        }
        throw new IllegalArgumentException("unsupported language");
    }

    private static String getLanguageStr(Properties props) {
        return CorefProperties.getLanguage(props).getDisplayName().toLowerCase();
    }

    public static HeadFinder getHeadFinder(Properties props) {
        Locale lang = CorefProperties.getLanguage(props);
        if (lang == Locale.ENGLISH) {
            return new SemanticHeadFinder();
        }
        if (lang == Locale.CHINESE) {
            return new ChineseSemanticHeadFinder();
        }
        throw new RuntimeException("Invalid language setting: cannot load HeadFinder");
    }

    public static enum Dataset {
        TRAIN,
        DEV,
        TEST;

    }

    public static enum MentionDetectionType {
        RULE,
        HYBRID,
        DEPENDENCY;

    }

    public static enum CorefAlgorithmType {
        CLUSTERING,
        STATISTICAL,
        NEURAL,
        HYBRID;

    }
}

