/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading;

import edu.stanford.nlp.ie.machinereading.BasicEntityExtractor;
import edu.stanford.nlp.ie.machinereading.BasicRelationExtractor;
import edu.stanford.nlp.ie.machinereading.BasicRelationFeatureFactory;
import edu.stanford.nlp.ie.machinereading.Extractor;
import edu.stanford.nlp.ie.machinereading.GenericDataSetReader;
import edu.stanford.nlp.ie.machinereading.MachineReading;
import edu.stanford.nlp.ie.machinereading.RelationFeatureFactory;
import edu.stanford.nlp.ie.machinereading.structure.RelationMentionFactory;
import edu.stanford.nlp.util.ArgumentParser;
import java.util.logging.Logger;

public class MachineReadingProperties {
    @ArgumentParser.Option(name="logger", gloss="Static logger for this entire class")
    public static Logger logger = Logger.getLogger(MachineReading.class.getName());
    @ArgumentParser.Option(name="datasetReaderClass", gloss="which GenericDataSetReader to use (needs to match the corpus in question)", required=true)
    public static Class<GenericDataSetReader> datasetReaderClass;
    @ArgumentParser.Option(name="datasetAuxReaderClass", gloss="which GenericDataSetReader to use for aux data set (needs to match the corpus in question)")
    public static Class<GenericDataSetReader> datasetAuxReaderClass;
    @ArgumentParser.Option(name="useNewHeadFinder", gloss="If false, use the original head (and worse) finding mechanism in GenericDataSetReader.  This option is primarily around for legacy purposes.")
    public static boolean useNewHeadFinder;
    @ArgumentParser.Option(name="readerLogLevel", gloss="verbosity of the corpus reader")
    public static String readerLogLevel;
    @ArgumentParser.Option(name="serializeCorpora", gloss="if false, we do not attempt to serialize the train/test corpora after reading")
    public static boolean serializeCorpora;
    @ArgumentParser.Option(name="forceGenerationOfIndexSpans", gloss="if true (default), regenerate span annotations for trees")
    public static boolean forceGenerationOfIndexSpans;
    @ArgumentParser.Option(name="serializedEntityExtractorPath", gloss="where to store/load the serialized entity extraction model")
    protected static String serializedEntityExtractorPath;
    @ArgumentParser.Option(name="serializedEntityExtractionResults", gloss="where to store the serialized sentences containing the results of entity extraction")
    protected static String serializedEntityExtractionResults;
    @ArgumentParser.Option(name="entityGazetteerPath", gloss="location of entity gazetteer file (if you're using one) -- this is a temporary option")
    public static String entityGazetteerPath;
    @ArgumentParser.Option(name="entityClassifier", gloss="entity extractor class to use")
    public static Class<BasicEntityExtractor> entityClassifier;
    @ArgumentParser.Option(name="entityResultsPrinters", gloss="comma-separated list of ResultsPrinter subclasses to use for printing the results of entity extraction")
    public static String entityResultsPrinters;
    @ArgumentParser.Option(name="serializedRelationExtractorPath", gloss="where to store/load the serialized relation extraction model")
    protected static String serializedRelationExtractorPath;
    @ArgumentParser.Option(name="serializedRelationExtractionResults", gloss="where to store the serialized sentences containing the results of relation extraction")
    protected static String serializedRelationExtractionResults;
    @ArgumentParser.Option(name="relationFeatureFactoryClass", gloss="FeatureFactory class to use for generating features from relations for relation extraction")
    public static Class<? extends RelationFeatureFactory> relationFeatureFactoryClass;
    @ArgumentParser.Option(name="relationMentionFactoryClass", gloss="relation mention factory class to use.")
    public static Class<RelationMentionFactory> relationMentionFactoryClass;
    @ArgumentParser.Option(name="relationFeatures", gloss="comma-separated list of feature types to generate for relation extraction.")
    public static String relationFeatures;
    @ArgumentParser.Option(name="relationResultsPrinters", gloss="comma-separated list of ResultsPrinter subclasses to use for printing the results of relation extraction")
    public static String relationResultsPrinters;
    @ArgumentParser.Option(name="trainRelationsUsingPredictedEntities", gloss="if true, the relation extraction model trains using predicted rather than gold entity mentions")
    public static boolean trainRelationsUsingPredictedEntities;
    @ArgumentParser.Option(name="testRelationsUsingPredictedEntities", gloss="if true, the relation extraction model is evaluated using predicted rather than gold entity mentions.")
    public static boolean testRelationsUsingPredictedEntities;
    @ArgumentParser.Option(name="createUnrelatedRelations", gloss="If true, it creates automatically negative examples by generating all combinations between EntityMentions in a sentence")
    public static boolean createUnrelatedRelations;
    @ArgumentParser.Option(name="doNotLexicalizeFirstArg", gloss="If true, it does not create any lexicalized features from the first argument (needed for KBP)")
    public static boolean doNotLexicalizeFirstArg;
    @ArgumentParser.Option(name="useRelationExtractionModelMerging", gloss="If true, the relation extractor will use ExtractorMerger for annotation (not training)")
    public static boolean useRelationExtractionModelMerging;
    @ArgumentParser.Option(name="relationsToSkipDuringTraining", gloss="comma-separated list relation types to skip during training")
    public static String relationsToSkipDuringTraining;
    @ArgumentParser.Option(name="relationExtractionPostProcessorClass", gloss="additional (probably domain-dependent) annotator to postprocess relations")
    public static Class<Extractor> relationExtractionPostProcessorClass;
    @ArgumentParser.Option(name="relationClassifier", gloss="relation extractor class to use")
    public static Class<? extends BasicRelationExtractor> relationClassifier;
    @ArgumentParser.Option(name="serializedEventExtractorPath", gloss="where to store/load the serialized event extraction model")
    protected static String serializedEventExtractorPath;
    @ArgumentParser.Option(name="serializedEventExtractionResults", gloss="where to store the serialized sentences containing the results of event extraction")
    protected static String serializedEventExtractionResults;
    @ArgumentParser.Option(name="eventResultsPrinters", gloss="comma-separated list of ResultsPrinter subclasses to use for printing the results of event extraction")
    public static String eventResultsPrinters;
    @ArgumentParser.Option(name="trainEventsUsingPredictedEntities", gloss="if true, the event extraction model trains using predicted rather than gold entity mentions")
    public static boolean trainEventsUsingPredictedEntities;
    @ArgumentParser.Option(name="testEventsUsingPredictedEntities", gloss="if true, the event extraction model is evaluated using predicted rather than gold entity mentions")
    public static boolean testEventsUsingPredictedEntities;
    @ArgumentParser.Option(name="consistencyCheck", gloss="consistency checker class to use")
    public static Class<Extractor> consistencyCheck;
    @ArgumentParser.Option(name="trainPath", gloss=" path to the training file/directory")
    protected static String trainPath;
    @ArgumentParser.Option(name="auxDataPath", gloss="path to the aux training file/directory")
    protected static String auxDataPath;
    @ArgumentParser.Option(name="serializedTrainingSentencesPath", gloss=" where to store the serialized training sentences objects", required=true)
    protected static String serializedTrainingSentencesPath;
    @ArgumentParser.Option(name="serializedAuxTrainingSentencesPath", gloss="where to store the serialized aux training sentences objects")
    protected static String serializedAuxTrainingSentencesPath;
    @ArgumentParser.Option(name="loadModel", gloss="if true, load a serialized model rather than training a new one")
    protected static boolean loadModel;
    @ArgumentParser.Option(name="trainUsePipelineNER", gloss="during training, use NER generated by the CoreNLP pipeline")
    public static boolean trainUsePipelineNER;
    @ArgumentParser.Option(name="trainOnly", gloss="if true, don't run evaluation (implies forceRetraining)")
    protected static boolean trainOnly;
    @ArgumentParser.Option(name="testPath", gloss="path to the testing file/directory")
    protected static String testPath;
    @ArgumentParser.Option(name="serializedTestSentencesPath", gloss="where to store the serialized test sentence objects")
    protected static String serializedTestSentencesPath;
    @ArgumentParser.Option(name="extractEntities", gloss="whether to extract entities, or use gold-standard entities for relation/event extraction")
    protected static boolean extractEntities;
    @ArgumentParser.Option(name="extractRelations", gloss="whether we should extract relations")
    protected static boolean extractRelations;
    @ArgumentParser.Option(name="extractEvents", gloss="whether we should extract events")
    protected static boolean extractEvents;
    @ArgumentParser.Option(name="crossValidate", gloss="if true, run cross-validation")
    protected static boolean crossValidate;
    @ArgumentParser.Option(name="kfold", gloss="number of partitions in training data for cross validation")
    public static int kfold;
    @ArgumentParser.Option(name="percentageOfTrain", gloss="Pct of train partition to use for training (e.g., for RELMS experiment); default all = 1.0")
    public static double percentageOfTrain;
    @ArgumentParser.Option(name="featureSimilarityThreshold")
    public static double featureSimilarityThreshold;
    @ArgumentParser.Option(name="computeFeatSimilarity")
    public static boolean computeFeatSimilarity;
    @ArgumentParser.Option(name="featureSelectionNumFeaturesRatio")
    public static double featureSelectionNumFeaturesRatio;
    @ArgumentParser.Option(name="L1Reg")
    public static boolean L1Reg;
    @ArgumentParser.Option(name="L2Reg")
    public static boolean L2Reg;
    @ArgumentParser.Option(name="L1RegLambda")
    public static double L1RegLambda;

    private MachineReadingProperties() {
    }

    static {
        useNewHeadFinder = true;
        readerLogLevel = "SEVERE";
        serializeCorpora = true;
        forceGenerationOfIndexSpans = true;
        serializedEntityExtractorPath = "";
        entityClassifier = BasicEntityExtractor.class;
        entityResultsPrinters = "";
        serializedRelationExtractorPath = null;
        serializedRelationExtractionResults = null;
        relationFeatureFactoryClass = BasicRelationFeatureFactory.class;
        relationMentionFactoryClass = RelationMentionFactory.class;
        relationFeatures = "all";
        relationResultsPrinters = "edu.stanford.nlp.ie.machinereading.RelationExtractorResultsPrinter";
        trainRelationsUsingPredictedEntities = false;
        testRelationsUsingPredictedEntities = false;
        createUnrelatedRelations = true;
        doNotLexicalizeFirstArg = false;
        useRelationExtractionModelMerging = false;
        relationsToSkipDuringTraining = "";
        relationClassifier = BasicRelationExtractor.class;
        serializedEventExtractorPath = "";
        eventResultsPrinters = "";
        trainEventsUsingPredictedEntities = false;
        testEventsUsingPredictedEntities = false;
        loadModel = false;
        trainUsePipelineNER = false;
        trainOnly = false;
        extractEntities = true;
        extractRelations = true;
        extractEvents = true;
        crossValidate = false;
        kfold = 5;
        percentageOfTrain = 1.0;
        featureSimilarityThreshold = 0.2;
        computeFeatSimilarity = true;
        featureSelectionNumFeaturesRatio = 0.7;
        L1Reg = false;
        L2Reg = true;
        L1RegLambda = 1.0;
    }
}

