/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.naturalli.ClauseSplitter;
import edu.stanford.nlp.naturalli.ClauseSplitterSearchProblem;
import edu.stanford.nlp.naturalli.ForwardEntailer;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.NaturalLogicWeights;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.naturalli.RelationTripleSegmenter;
import edu.stanford.nlp.naturalli.SentenceFragment;
import edu.stanford.nlp.naturalli.Util;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalRelations;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class OpenIE
implements Annotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(OpenIE.class);
    private static final SemgrexPattern adjectivePattern = SemgrexPattern.compile("{}=obj >nsubj {}=subj >cop {}=be >det {word:/an?/} >amod {}=adj ?>/prep_.*/=prep {}=pobj");
    @ArgumentParser.Option(name="format", gloss="The format to output the triples in.")
    private static OutputFormat FORMAT = OutputFormat.DEFAULT;
    @ArgumentParser.Option(name="filelist", gloss="The files to annotate, as a list of files one per line.")
    private static File FILELIST = null;
    @ArgumentParser.Option(name="output", gloss="The files to annotate, as a list of files one per line.")
    private static PrintStream OUTPUT = System.out;
    @ArgumentParser.Option(name="splitter.model", gloss="The location of the clause splitting model.")
    private String splitterModel = "edu/stanford/nlp/models/naturalli/clauseSearcherModel.ser.gz";
    @ArgumentParser.Option(name="splitter.nomodel", gloss="If true, don't load a clause splitter model. This is primarily useful for training.")
    private boolean noModel = false;
    @ArgumentParser.Option(name="splitter.threshold", gloss="The minimum threshold for accepting a clause.")
    private double splitterThreshold = 0.1;
    @ArgumentParser.Option(name="splitter.disable", gloss="If true, don't run the sentence splitter")
    private boolean splitterDisable = false;
    @ArgumentParser.Option(name="max_entailments_per_clause", gloss="The maximum number of entailments allowed per sentence of input.")
    private int entailmentsPerSentence = 1000;
    @ArgumentParser.Option(name="ignore_affinity", gloss="If true, don't use the affinity models for dobj and pp attachment.")
    private boolean ignoreAffinity = false;
    @ArgumentParser.Option(name="affinity_models", gloss="The directory (or classpath directory) containing the affinity models for pp/obj attachments.")
    private String affinityModels = "edu/stanford/nlp/models/naturalli/affinities";
    @ArgumentParser.Option(name="affinity_probability_cap", gloss="The affinity to consider 1.0")
    private double affinityProbabilityCap = 0.3333333333333333;
    @ArgumentParser.Option(name="triple.strict", gloss="If true, only generate triples if the entire fragment has been consumed.")
    private boolean consumeAll = true;
    @ArgumentParser.Option(name="triple.all_nominals", gloss="If true, generate not only named entity nominal relations.")
    private boolean allNominals = false;
    @ArgumentParser.Option(name="resolve_coref", gloss="If true, resolve pronouns to their canonical mention")
    private boolean resolveCoref = false;
    @ArgumentParser.Option(name="strip_entailments", gloss="If true, don't keep the entailed sentences annotations around.")
    private boolean stripEntailments = false;
    private final NaturalLogicWeights weights;
    public final Optional<ClauseSplitter> clauseSplitter;
    public final ForwardEntailer forwardEntailer;
    public RelationTripleSegmenter segmenter;

    public OpenIE() {
        this(new Properties());
    }

    public OpenIE(Properties props) {
        ArgumentParser.fillOptions((Object)this, props);
        Properties withoutOpenIEPrefix = new Properties();
        for (String key : props.stringPropertyNames()) {
            withoutOpenIEPrefix.setProperty(key.replace("openie.", ""), props.getProperty(key));
        }
        ArgumentParser.fillOptions((Object)this, withoutOpenIEPrefix);
        try {
            if (this.splitterDisable) {
                this.clauseSplitter = Optional.empty();
            } else if (this.noModel) {
                log.info("Not loading a splitter model");
                this.clauseSplitter = Optional.of(ClauseSplitterSearchProblem::new);
            } else {
                this.clauseSplitter = Optional.of(ClauseSplitter.load(this.splitterModel));
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Could not load clause splitter model at " + this.splitterModel, e);
        }
        try {
            this.weights = this.ignoreAffinity ? new NaturalLogicWeights(this.affinityProbabilityCap) : new NaturalLogicWeights(this.affinityModels, this.affinityProbabilityCap);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Could not load affinity model at " + this.affinityModels + ": " + e.getMessage());
        }
        this.forwardEntailer = new ForwardEntailer(this.entailmentsPerSentence, this.weights);
        this.segmenter = new RelationTripleSegmenter(this.allNominals);
    }

    public List<SentenceFragment> clausesInSentence(SemanticGraph tree, boolean assumedTruth) {
        if (this.clauseSplitter.isPresent()) {
            return ((ClauseSplitterSearchProblem)this.clauseSplitter.get().apply(tree, assumedTruth)).topClauses(this.splitterThreshold, 32);
        }
        return Collections.emptyList();
    }

    public List<SentenceFragment> clausesInSentence(CoreMap sentence) {
        return this.clausesInSentence((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class), true);
    }

    public List<SentenceFragment> entailmentsFromClause(SentenceFragment clause) {
        if (clause.parseTree.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SentenceFragment> list = new ArrayList<SentenceFragment>();
        if (this.entailmentsPerSentence > 0) {
            list.addAll(this.forwardEntailer.apply(clause.parseTree, true).search().stream().map(x -> x.changeScore(x.score * clause.score)).collect(Collectors.toList()));
        }
        list.add(clause);
        ArrayList<SentenceFragment> adjFragments = new ArrayList<SentenceFragment>();
        SemgrexMatcher matcher = adjectivePattern.matcher(clause.parseTree);
        block0: while (matcher.find()) {
            IndexedWord subj = matcher.getNode("subj");
            IndexedWord be = matcher.getNode("be");
            IndexedWord adj = matcher.getNode("adj");
            IndexedWord obj = matcher.getNode("obj");
            IndexedWord pobj = matcher.getNode("pobj");
            String prep = matcher.getRelnString("prep");
            for (SemanticGraphEdge edge : clause.parseTree.outgoingEdgeIterable(obj)) {
                if (!"amod".equals(edge.getRelation().toString()) || edge.getDependent().index() > adj.index() || !Util.PRIVATIVE_ADJECTIVES.contains(edge.getDependent().word().toLowerCase())) continue;
                continue block0;
            }
            SemanticGraph tree = new SemanticGraph();
            tree.addRoot(adj);
            tree.addVertex(subj);
            tree.addVertex(be);
            tree.addEdge(adj, be, GrammaticalRelation.valueOf(Language.English, "cop"), Double.NEGATIVE_INFINITY, false);
            tree.addEdge(adj, subj, GrammaticalRelation.valueOf(Language.English, "nsubj"), Double.NEGATIVE_INFINITY, false);
            if (pobj != null) {
                assert (prep != null);
                tree.addEdge(adj, pobj, GrammaticalRelation.valueOf(Language.English, prep), Double.NEGATIVE_INFINITY, false);
            }
            if (!((Polarity)adj.get(NaturalLogicAnnotations.PolarityAnnotation.class)).isUpwards() || !((Polarity)be.get(NaturalLogicAnnotations.PolarityAnnotation.class)).isUpwards()) continue;
            adjFragments.add(new SentenceFragment(tree, clause.assumedTruth, false));
        }
        list.addAll(adjFragments);
        return list;
    }

    public Set<SentenceFragment> entailmentsFromClauses(Collection<SentenceFragment> clauses) {
        HashSet<SentenceFragment> entailments = new HashSet<SentenceFragment>();
        for (SentenceFragment clause : clauses) {
            entailments.addAll(this.entailmentsFromClause(clause));
        }
        return entailments;
    }

    public Optional<RelationTriple> relationInFragment(SentenceFragment fragment) {
        return this.segmenter.segment(fragment.parseTree, Optional.of(fragment.score), this.consumeAll);
    }

    public List<RelationTriple> relationsInFragments(Collection<SentenceFragment> fragments) {
        return fragments.stream().map(this::relationInFragment).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<RelationTriple> relationInFragment(SentenceFragment fragment, CoreMap sentence) {
        return this.segmenter.segment(fragment.parseTree, Optional.of(fragment.score), this.consumeAll);
    }

    private List<RelationTriple> relationsInFragments(Collection<SentenceFragment> fragments, CoreMap sentence) {
        return fragments.stream().map(x -> this.relationInFragment((SentenceFragment)x, sentence)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public List<RelationTriple> relationsInClause(SentenceFragment clause) {
        return this.relationsInFragments(this.entailmentsFromClause(clause));
    }

    public List<RelationTriple> relationsInSentence(CoreMap sentence) {
        return this.relationsInFragments(this.entailmentsFromClauses(this.clausesInSentence(sentence)));
    }

    private static SemanticGraph canonicalizeCoref(SemanticGraph parse, Map<CoreLabel, List<CoreLabel>> canonicalMentionMap) {
        parse = new SemanticGraph(parse);
        for (IndexedWord node : new HashSet<IndexedWord>(parse.vertexSet())) {
            List<CoreLabel> canonicalMention;
            if (node.tag() == null || !node.tag().startsWith("PRP") || (canonicalMention = canonicalMentionMap.get(node.backingLabel())) == null) continue;
            List<SemanticGraphEdge> incomingEdges = parse.incomingEdgeList(node);
            List<SemanticGraphEdge> outgoingEdges = parse.outgoingEdgeList(node);
            parse.removeVertex(node);
            IndexedWord headWord = new IndexedWord(canonicalMention.get(canonicalMention.size() - 1));
            headWord.setPseudoPosition(node.pseudoPosition());
            parse.addVertex(headWord);
            for (SemanticGraphEdge edge : incomingEdges) {
                parse.addEdge(edge.getGovernor(), headWord, edge.getRelation(), edge.getWeight(), edge.isExtra());
            }
            for (SemanticGraphEdge edge : outgoingEdges) {
                parse.addEdge(headWord, edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
            }
            double pseudoPosition = headWord.pseudoPosition() - 0.001;
            for (int i = canonicalMention.size() - 2; i >= 0; --i) {
                IndexedWord dependent = new IndexedWord(canonicalMention.get(i));
                dependent.setPseudoPosition(pseudoPosition);
                pseudoPosition -= 0.001;
                parse.addVertex(dependent);
                parse.addEdge(headWord, dependent, UniversalEnglishGrammaticalRelations.COMPOUND_MODIFIER, 1.0, false);
            }
        }
        return parse;
    }

    public void annotateSentence(CoreMap sentence, Map<CoreLabel, List<CoreLabel>> canonicalMentionMap) {
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (tokens.size() < 2) {
            sentence.set(NaturalLogicAnnotations.RelationTriplesAnnotation.class, Collections.emptyList());
            if (!this.stripEntailments) {
                sentence.set(NaturalLogicAnnotations.EntailedSentencesAnnotation.class, Collections.emptySet());
            }
        } else {
            SemanticGraph parse = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class);
            if (parse == null) {
                parse = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            }
            if (parse == null) {
                throw new IllegalStateException("Cannot run OpenIE without a parse tree!");
            }
            parse = new SemanticGraph(parse);
            Util.cleanTree(parse);
            SemanticGraph canonicalizedParse = parse;
            if (this.resolveCoref && !canonicalMentionMap.isEmpty()) {
                canonicalizedParse = OpenIE.canonicalizeCoref(parse, canonicalMentionMap);
            }
            List<SentenceFragment> clauses = this.clausesInSentence(canonicalizedParse, true);
            Set<SentenceFragment> fragments = this.entailmentsFromClauses(clauses);
            List<RelationTriple> extractions = this.segmenter.extract(parse, tokens);
            extractions.addAll(this.relationsInFragments(fragments, sentence));
            sentence.set(NaturalLogicAnnotations.EntailedClausesAnnotation.class, new HashSet<SentenceFragment>(clauses));
            sentence.set(NaturalLogicAnnotations.EntailedSentencesAnnotation.class, fragments);
            sentence.set(NaturalLogicAnnotations.RelationTriplesAnnotation.class, new ArrayList<RelationTriple>(new HashSet<RelationTriple>(extractions)));
            if (this.stripEntailments) {
                sentence.remove(NaturalLogicAnnotations.EntailedSentencesAnnotation.class);
            }
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        Map corefChains;
        IdentityHashMap<CoreLabel, List> canonicalMentionMap = new IdentityHashMap<CoreLabel, List>();
        if (this.resolveCoref && (corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class)) != null) {
            for (CorefChain chain : corefChains.values()) {
                if (chain.getMentionsInTextualOrder().size() < 2) continue;
                List canonicalMention = null;
                double canonicalMentionScore = Double.NEGATIVE_INFINITY;
                HashSet tokensToMark = new HashSet();
                List<CorefChain.CorefMention> mentions = chain.getMentionsInTextualOrder();
                for (int i = 0; i < mentions.size(); ++i) {
                    Pair<List<CoreLabel>, Double> info = OpenIE.grokCorefMention(annotation, mentions.get(i));
                    double score = (Double)info.second + (double)i / (double)mentions.size() + (mentions.get(i) == chain.getRepresentativeMention() ? 1.0 : 0.0);
                    if (canonicalMention == null || score > canonicalMentionScore) {
                        canonicalMention = (List)info.first;
                        canonicalMentionScore = score;
                    }
                    if (((List)info.first).size() != 1) continue;
                    tokensToMark.addAll((Collection)info.first);
                }
                assert (canonicalMention != null);
                for (CoreLabel token : tokensToMark) {
                    List existingMention = (List)canonicalMentionMap.get(token);
                    if (existingMention != null && !existingMention.isEmpty() && !"O".equals(((CoreLabel)existingMention.get(0)).ner())) continue;
                    canonicalMentionMap.put(token, canonicalMention);
                }
            }
        }
        ((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).forEach(x -> this.annotateSentence((CoreMap)x, (Map<CoreLabel, List<CoreLabel>>)canonicalMentionMap));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(NaturalLogicAnnotations.RelationTriplesAnnotation.class, NaturalLogicAnnotations.EntailedSentencesAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        HashSet<Class> requirements = new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, NaturalLogicAnnotations.PolarityAnnotation.class, SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class));
        if (this.resolveCoref) {
            requirements.add(CorefCoreAnnotations.CorefChainAnnotation.class);
        }
        return Collections.unmodifiableSet(requirements);
    }

    private static Pair<List<CoreLabel>, Double> grokCorefMention(Annotation doc, CorefChain.CorefMention mention) {
        List tokens = (List)((CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(mention.sentNum - 1)).get(CoreAnnotations.TokensAnnotation.class);
        List mentionAsTokens = tokens.subList(mention.startIndex - 1, mention.endIndex - 1);
        ClassicCounter nerVotes = new ClassicCounter();
        mentionAsTokens.stream().filter(token -> token.ner() != null && !"O".equals(token.ner())).forEach(token -> nerVotes.incrementCount(token.ner()));
        String ner = (String)Counters.argmax(nerVotes, (o1, o2) -> o1 == null ? 0 : o1.compareTo((String)o2));
        double nerCount = nerVotes.getCount(ner);
        double nerScore = nerCount * nerCount / (double)mentionAsTokens.size();
        return Pair.makePair(mentionAsTokens, nerScore);
    }

    public static String tripleToString(RelationTriple extraction, String docid, CoreMap sentence) {
        switch (FORMAT) {
            case REVERB: {
                return extraction.toReverbString(docid, sentence);
            }
            case OLLIE: {
                return extraction.confidenceGloss() + ": (" + extraction.subjectGloss() + "; " + extraction.relationGloss() + "; " + extraction.objectGloss() + ')';
            }
            case DEFAULT: {
                return extraction.toString();
            }
            case QA_SRL: {
                return extraction.toQaSrlString(sentence);
            }
        }
        throw new IllegalStateException("Format is not implemented: " + (Object)((Object)FORMAT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processDocument(AnnotationPipeline pipeline, String docid, String document) {
        if (document.trim().isEmpty()) {
            return;
        }
        Annotation ann = new Annotation(document);
        pipeline.annotate(ann);
        boolean empty = true;
        PrintStream printStream = OUTPUT;
        synchronized (printStream) {
            for (CoreMap sentence : (List)ann.get(CoreAnnotations.SentencesAnnotation.class)) {
                for (RelationTriple extraction : (Collection)sentence.get(NaturalLogicAnnotations.RelationTriplesAnnotation.class)) {
                    OUTPUT.println(OpenIE.tripleToString(extraction, docid, sentence));
                    empty = false;
                }
            }
        }
        if (empty) {
            log.info("No extractions in: " + ("stdin".equals(docid) ? document : docid));
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Properties props = StringUtils.argsToProperties(args, (Map<String, Integer>)new HashMap<String, Integer>(){
            {
                this.put("openie.resolve_coref", 0);
                this.put("resolve_coref", 0);
                this.put("openie.splitter.nomodel", 0);
                this.put("splitter.nomodel", 0);
                this.put("openie.splitter.disable", 0);
                this.put("splitter.disable", 0);
                this.put("openie.ignore_affinity", 0);
                this.put("splitter.ignore_affinity", 0);
                this.put("openie.triple.strict", 0);
                this.put("splitter.triple.strict", 0);
                this.put("openie.triple.all_nominals", 0);
                this.put("splitter.triple.all_nominals", 0);
            }
        });
        ArgumentParser.fillOptions(new Class[]{OpenIE.class, ArgumentParser.class}, props);
        AtomicInteger exceptionCount = new AtomicInteger(0);
        ExecutorService exec = Executors.newFixedThreadPool(ArgumentParser.threads);
        String[] filesToProcess = FILELIST != null ? (String[])IOUtils.linesFromFile(FILELIST.getPath()).stream().map(String::trim).map(path -> path.replaceAll("^~", "$HOME")).map(path -> new File((String)path).exists() ? path : StringUtils.expandEnvironmentVariables(path)).toArray(String[]::new) : (!"".equals(props.getProperty("", "")) ? props.getProperty("", "").split("\\s+") : new String[]{});
        if ("".equals(props.getProperty("annotators", ""))) {
            if (!"false".equalsIgnoreCase(props.getProperty("resolve_coref", props.getProperty("openie.resolve_coref", "false")))) {
                props.setProperty("coref.md.type", "dep");
                props.setProperty("coref.mode", "statistical");
                props.setProperty("annotators", "tokenize,ssplit,pos,lemma,depparse,ner,mention,coref,natlog,openie");
            } else {
                props.setProperty("annotators", "tokenize,ssplit,pos,lemma,depparse,natlog,openie");
            }
        }
        if ("".equals(props.getProperty("depparse.extradependencies", ""))) {
            props.setProperty("depparse.extradependencies", "ref_only_uncollapsed");
        }
        if ("".equals(props.getProperty("parse.extradependencies", ""))) {
            props.setProperty("parse.extradependencies", "ref_only_uncollapsed");
        }
        if ("".equals(props.getProperty("tokenize.class", ""))) {
            props.setProperty("tokenize.class", "PTBTokenizer");
        }
        if ("".equals(props.getProperty("tokenize.language", ""))) {
            props.setProperty("tokenize.language", "en");
        }
        if (filesToProcess.length == 0 && "".equals(props.getProperty("ssplit.isOneSentence", ""))) {
            props.setProperty("ssplit.isOneSentence", "true");
        }
        if (!props.getProperty("annotators").toLowerCase().contains("openie")) {
            log.error("If you specify custom annotators, you must at least include 'openie'");
            System.exit(1);
        }
        new HashSet<Object>(props.keySet()).stream().filter(key -> !key.toString().startsWith("openie.")).forEach(key -> props.setProperty("openie." + key.toString(), props.getProperty(key.toString())));
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        if (filesToProcess.length == 0) {
            String line;
            log.info("Processing from stdin. Enter one sentence per line.");
            Scanner scanner = new Scanner(System.in);
            try {
                line = scanner.nextLine();
            }
            catch (NoSuchElementException e) {
                log.info("No lines found on standard in");
                return;
            }
            while (line != null) {
                OpenIE.processDocument(pipeline, "stdin", line);
                try {
                    line = scanner.nextLine();
                }
                catch (NoSuchElementException e) {
                    return;
                }
            }
        } else {
            for (String file : filesToProcess) {
                if (new File(file).exists() && new File(file).canRead()) continue;
                log.error("Cannot read file (or file does not exist: '" + file + '\'');
            }
            for (String file : filesToProcess) {
                log.info("Processing file: " + file);
                if (ArgumentParser.threads > 1) {
                    String fileToSubmit = file;
                    exec.submit(() -> {
                        try {
                            OpenIE.processDocument(pipeline, file, IOUtils.slurpFile(new File(fileToSubmit)));
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            exceptionCount.incrementAndGet();
                        }
                    });
                    continue;
                }
                OpenIE.processDocument(pipeline, file, IOUtils.slurpFile(new File(file)));
            }
        }
        exec.shutdown();
        log.info("All files have been queued; awaiting termination...");
        exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        log.info("DONE processing files. " + exceptionCount.get() + " exceptions encountered.");
        System.exit(exceptionCount.get());
    }

    private static enum OutputFormat {
        REVERB,
        OLLIE,
        DEFAULT,
        QA_SRL;

    }
}

