/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.neural;

import edu.stanford.nlp.neural.Embedding;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.junit.Assert;
import org.junit.Test;

public class EmbeddingITest {
    public static final String wordVectorFile = "edu/stanford/nlp/neural/wordVector.txt";
    public static final String wordFile = "edu/stanford/nlp/neural/word.txt";
    public static final String vectorFile = "edu/stanford/nlp/neural/vector.txt";

    @Test
    public void testLoadFromOneFile() {
        Embedding embedding = new Embedding(wordVectorFile);
        double[][] values = new double[1][5];
        values[0] = new double[]{0.1, 0.2, 0.3, 0.4, 0.5};
        Assert.assertTrue((boolean)((SimpleMatrix)embedding.getUnknownWordVector().transpose()).isIdentical((SimpleBase)new SimpleMatrix(values), 1.0E-5));
        values[0] = new double[]{0.6, 0.7, 0.8, 0.9, 1.0};
        Assert.assertTrue((boolean)((SimpleMatrix)embedding.getStartWordVector().transpose()).isIdentical((SimpleBase)new SimpleMatrix(values), 1.0E-5));
        values[0] = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        Assert.assertTrue((boolean)((SimpleMatrix)embedding.getEndWordVector().transpose()).isIdentical((SimpleBase)new SimpleMatrix(values), 1.0E-5));
        values[0] = new double[]{6.0, 7.0, 8.0, 9.0, 10.0};
        Assert.assertTrue((boolean)((SimpleMatrix)embedding.get("the").transpose()).isIdentical((SimpleBase)new SimpleMatrix(values), 1.0E-5));
    }

    @Test
    public void testLoadFromTwoFile() {
        Embedding embedding = new Embedding(wordFile, vectorFile);
        double[][] values = new double[1][5];
        values[0] = new double[]{0.1, 0.2, 0.3, 0.4, 0.5};
        Assert.assertTrue((boolean)((SimpleMatrix)embedding.getUnknownWordVector().transpose()).isIdentical((SimpleBase)new SimpleMatrix(values), 1.0E-5));
        values[0] = new double[]{0.6, 0.7, 0.8, 0.9, 1.0};
        Assert.assertTrue((boolean)((SimpleMatrix)embedding.getStartWordVector().transpose()).isIdentical((SimpleBase)new SimpleMatrix(values), 1.0E-5));
        values[0] = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        Assert.assertTrue((boolean)((SimpleMatrix)embedding.getEndWordVector().transpose()).isIdentical((SimpleBase)new SimpleMatrix(values), 1.0E-5));
        values[0] = new double[]{6.0, 7.0, 8.0, 9.0, 10.0};
        Assert.assertTrue((boolean)((SimpleMatrix)embedding.get("the").transpose()).isIdentical((SimpleBase)new SimpleMatrix(values), 1.0E-5));
    }
}

