/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.parser.nndep.DependencyParser;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalRelations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import junit.framework.TestCase;

public class DependencyParserITest
extends TestCase {
    private static final double EnglishSdLas = 89.55236534222574;
    private static final double EnglishUdLas = 88.78652574464478;
    private static final double EnglishConll2008Las = 90.97206578058122;
    private static final double ChineseConllxGoldTagsLas = 82.42855503270974;

    public void testDependencyParserEnglishSD() {
        DependencyParser parser = new DependencyParser();
        parser.loadModelFile("/u/nlp/data/depparser/nn/distrib-2014-10-26/PTB_Stanford_params.txt.gz");
        double las = parser.testCoNLL("/u/nlp/data/depparser/nn/data/dependency_treebanks/PTB/Stanford_3_3_0/dev.conll", null);
        DependencyParserITest.assertEquals((String)String.format("English SD LAS should be %.2f but was %.2f", 89.55236534222574, las), (double)89.55236534222574, (double)las, (double)1.0E-4);
    }

    public void testDependencyParserEnglishUD() {
        DependencyParser parser = new DependencyParser();
        parser.loadModelFile("/u/nlp/data/depparser/nn/distrib-2015-04-16/english_UD.gz");
        double las = parser.testCoNLL("/u/nlp/data/depparser/nn/data/dependency_treebanks/UD-converted/dev.conll", null);
        DependencyParserITest.assertEquals((String)String.format("English UD LAS should be %.2f but was %.2f", 88.78652574464478, las), (double)88.78652574464478, (double)las, (double)1.0E-4);
    }

    public void testDependencyParserEnglishCoNLL2008() {
        DependencyParser parser = new DependencyParser();
        parser.loadModelFile("/u/nlp/data/depparser/nn/distrib-2014-10-26/PTB_CoNLL_params.txt.gz");
        double las = parser.testCoNLL("/u/nlp/data/depparser/nn/data/dependency_treebanks/PTB/CoNLL/dev.conll", null);
        DependencyParserITest.assertEquals((String)String.format("English CoNLL2008 LAS should be %.2f but was %.2f", 90.97206578058122, las), (double)90.97206578058122, (double)las, (double)1.0E-4);
    }

    public void testDependencyParserChineseCoNLLX() {
        Properties props = StringUtils.stringToProperties("language=Chinese");
        DependencyParser parser = new DependencyParser(props);
        parser.loadModelFile("/u/nlp/data/depparser/nn/distrib-2014-10-26/CTB_CoNLL_params.txt.gz");
        double las = parser.testCoNLL("/u/nlp/data/depparser/nn/data/dependency_treebanks/CTB/dev.gold.conll", null);
        DependencyParserITest.assertEquals((String)String.format("Chinese CoNLLX gold tags LAS should be %.2f but was %.2f", 82.42855503270974, las), (double)82.42855503270974, (double)las, (double)1.0E-4);
    }

    public void testCCProcess() {
        Properties props = PropertiesUtils.fromString("annotators=tokenize,ssplit,pos,depparse");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        String text = "Chris and John went to the store.";
        Annotation document = new Annotation(text);
        pipeline.annotate(document);
        SemanticGraph ccProcessed = (SemanticGraph)((CoreMap)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).get(0)).get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
        Collection<TypedDependency> dependencies = ccProcessed.typedDependencies();
        GrammaticalRelation expected = UniversalEnglishGrammaticalRelations.getConj("and");
        DependencyParserITest.assertTrue((boolean)dependencies.stream().map(TypedDependency::reln).collect(Collectors.toList()).contains(expected));
    }

    public void testSerializationAnnotation() throws IOException, ClassNotFoundException {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,depparse");
        String text = "Barack Obama, a Yale professor, is president.";
        Annotation document = new Annotation(text);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(document);
        File tempfile = IOUtils.writeObjectToTempFile(document.get(CoreAnnotations.SentencesAnnotation.class), "temp");
        List readSentences = (List)IOUtils.readObjectFromFile(tempfile);
        DependencyParserITest.assertEquals(document.get(CoreAnnotations.SentencesAnnotation.class), (Object)readSentences);
    }
}

