/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.parser.shiftreduce.ShiftTransition;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;

public class BinaryTransitionTest
extends TestCase {
    public static State buildState(int shifts) {
        String[] words = new String[]{"This", "is", "a", "short", "test", "."};
        String[] tags = new String[]{"DT", "VBZ", "DT", "JJ", "NN", "."};
        BinaryTransitionTest.assertEquals((int)words.length, (int)tags.length);
        ArrayList<TaggedWord> sentence = SentenceUtils.toTaggedList(Arrays.asList(words), Arrays.asList(tags));
        State state = ShiftReduceParser.initialStateFromTaggedSentence(sentence);
        ShiftTransition shift = new ShiftTransition();
        for (int i = 0; i < shifts; ++i) {
            state = shift.apply(state);
        }
        BinaryTransitionTest.assertEquals((int)shifts, (int)state.tokenPosition);
        return state;
    }

    public void testLeftTransition() {
        State state = BinaryTransitionTest.buildState(2);
        BinaryTransition transition = new BinaryTransition("NP", BinaryTransition.Side.LEFT);
        state = transition.apply(state);
        BinaryTransitionTest.assertEquals((int)2, (int)state.tokenPosition);
        BinaryTransitionTest.assertEquals((int)1, (int)state.stack.size());
        BinaryTransitionTest.assertEquals((int)2, (int)state.stack.peek().children().length);
        BinaryTransitionTest.assertEquals((String)"NP", (String)state.stack.peek().value());
        this.checkHeads(state.stack.peek(), state.stack.peek().children()[0]);
    }

    public void testRightTransition() {
        State state = BinaryTransitionTest.buildState(2);
        BinaryTransition transition = new BinaryTransition("NP", BinaryTransition.Side.RIGHT);
        state = transition.apply(state);
        BinaryTransitionTest.assertEquals((int)2, (int)state.tokenPosition);
        BinaryTransitionTest.assertEquals((int)1, (int)state.stack.size());
        BinaryTransitionTest.assertEquals((int)2, (int)state.stack.peek().children().length);
        BinaryTransitionTest.assertEquals((String)"NP", (String)state.stack.peek().value());
        this.checkHeads(state.stack.peek(), state.stack.peek().children()[1]);
    }

    public void checkHeads(Tree t1, Tree t2) {
        BinaryTransitionTest.assertTrue((boolean)(t1.label() instanceof CoreLabel));
        BinaryTransitionTest.assertTrue((boolean)(t2.label() instanceof CoreLabel));
        CoreLabel l1 = (CoreLabel)t1.label();
        CoreLabel l2 = (CoreLabel)t2.label();
        BinaryTransitionTest.assertEquals(l1.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class), l2.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class));
        BinaryTransitionTest.assertEquals(l1.get(TreeCoreAnnotations.HeadTagLabelAnnotation.class), l2.get(TreeCoreAnnotations.HeadTagLabelAnnotation.class));
    }
}

