/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.ui;

import edu.stanford.nlp.io.ui.OpenPageDialog;
import edu.stanford.nlp.ling.BasicDocument;
import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.HasOffset;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.ui.TreeJPanel;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.process.StripTagsProcessor;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.swing.FontDetector;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import edu.stanford.nlp.ui.JarFileChooser;
import edu.stanford.nlp.util.logging.Redwood;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ParserPanel
extends JPanel {
    private static final Redwood.RedwoodChannels log = Redwood.channels(ParserPanel.class);
    private static final long serialVersionUID = -2118491857333662471L;
    public static final int UNTOKENIZED_ENGLISH = 0;
    public static final int TOKENIZED_CHINESE = 1;
    public static final int UNTOKENIZED_CHINESE = 2;
    private static TreebankLanguagePack tlp;
    private String encoding = "UTF-8";
    private static final int ONE_SECOND = 1000;
    private static final int PARSER_LOAD_TIME = 60;
    private static final int PARSE_TIME = 30;
    private static final int SEEK_FORWARD = 1;
    private static final int SEEK_BACK = -1;
    private final JFileChooser jfc;
    private final JFileChooserLocation jfcLocation;
    private final JarFileChooser chooseJarParser;
    private OpenPageDialog pageDialog;
    private SimpleAttributeSet normalStyle;
    private SimpleAttributeSet highlightStyle;
    private int startIndex;
    private int endIndex;
    private TreeJPanel treePanel;
    private LexicalizedParser parser;
    private LoadParserThread lpThread;
    private ParseThread parseThread;
    private Timer timer;
    private int count;
    private Component glassPane;
    private boolean scrollWhenDone;
    private JLabel dataFileLabel;
    private JPanel treeContainer;
    private JPanel topPanel;
    private JScrollPane textScrollPane;
    private JButton backButton;
    private JLabel statusLabel;
    private JButton loadFileButton;
    private JPanel loadButtonPanel;
    private JPanel buttonsAndFilePanel;
    private JButton parseButton;
    private JButton parseNextButton;
    private JButton forwardButton;
    private JLabel parserFileLabel;
    private JButton clearButton;
    private JSplitPane splitPane;
    private JPanel statusPanel;
    private JPanel dataFilePanel;
    private JPanel buttonPanel;
    private JTextPane textPane;
    private JProgressBar progressBar;
    private JPanel parserFilePanel;
    private JButton loadParserButton;
    private JButton saveOutputButton;

    public ParserPanel() {
        this.initComponents();
        this.jfc = new JFileChooser(System.getProperty("user.dir"));
        this.pageDialog = new OpenPageDialog(new Frame(), true);
        this.pageDialog.setFileChooser(this.jfc);
        this.jfcLocation = new JFileChooserLocation(this.jfc);
        tlp = new PennTreebankLanguagePack();
        this.encoding = tlp.getEncoding();
        this.setFont();
        this.timer = new Timer(1000, new TimerListener());
        this.highlightStyle = new SimpleAttributeSet();
        this.normalStyle = new SimpleAttributeSet();
        StyleConstants.setBackground(this.highlightStyle, Color.yellow);
        StyleConstants.setBackground(this.normalStyle, this.textPane.getBackground());
        this.chooseJarParser = new JarFileChooser(".*\\.ser\\.gz", this);
    }

    public void scrollBack() {
        this.highlightSentence(this.startIndex - 1);
        this.textPane.setCaretPosition(this.startIndex);
    }

    public void scrollForward() {
        this.highlightSentence(this.endIndex + 1);
        this.textPane.setCaretPosition(this.startIndex);
    }

    private void highlightText(int start, int end, SimpleAttributeSet style) {
        if (start < end) {
            this.textPane.getStyledDocument().setCharacterAttributes(start, end - start + 1, style, false);
        }
    }

    private void highlightSentence(int start) {
        this.highlightSentence(start, -1);
    }

    private void highlightSentence(int start, int end) {
        this.highlightText(0, this.textPane.getText().length(), this.normalStyle);
        this.startIndex = start < 1 ? 0 : this.nearestDelimiter(this.textPane.getText(), start, -1) + 1;
        this.endIndex = this.nearestDelimiter(this.textPane.getText(), end < this.startIndex ? this.startIndex : end, 1);
        if (this.endIndex == -1) {
            this.endIndex = this.textPane.getText().length() - 1;
        }
        this.highlightText(this.startIndex, this.endIndex, this.highlightStyle);
        this.backButton.setEnabled(this.startIndex != 0);
        this.forwardButton.setEnabled(this.endIndex != this.textPane.getText().length() - 1);
        this.parseNextButton.setEnabled(this.forwardButton.isEnabled() && this.parser != null);
    }

    private int nearestDelimiter(String text, int start, int seekDir) {
        if (seekDir != -1 && seekDir != 1) {
            throw new IllegalArgumentException("Unknown seek direction " + seekDir);
        }
        StringReader reader = new StringReader(text);
        DocumentPreprocessor processor = new DocumentPreprocessor(reader);
        TokenizerFactory<? extends HasWord> tf = tlp.getTokenizerFactory();
        processor.setTokenizerFactory(tf);
        ArrayList<Integer> boundaries = new ArrayList<Integer>();
        for (List<HasWord> sentence : processor) {
            if (sentence.size() == 0) continue;
            if (!(sentence.get(0) instanceof HasOffset)) {
                throw new ClassCastException("Expected HasOffsets from the DocumentPreprocessor");
            }
            if (boundaries.size() == 0) {
                boundaries.add(0);
                continue;
            }
            HasOffset first = (HasOffset)((Object)sentence.get(0));
            boundaries.add(first.beginPosition());
        }
        boundaries.add(text.length());
        for (int i = 0; i < boundaries.size() - 1; ++i) {
            if ((Integer)boundaries.get(i) > start || start >= (Integer)boundaries.get(i + 1)) continue;
            if (seekDir == -1) {
                return (Integer)boundaries.get(i) - 1;
            }
            if (seekDir != 1) continue;
            return (Integer)boundaries.get(i + 1) - 1;
        }
        if (boundaries.size() >= 2 && start >= text.length()) {
            if (seekDir == -1) {
                return (Integer)boundaries.get(boundaries.size() - 2) - 1;
            }
            if (seekDir == 1) {
                return (Integer)boundaries.get(boundaries.size() - 1) - 1;
            }
        }
        return -1;
    }

    private void highlightSelectedSentence() {
        this.highlightSentence(this.textPane.getSelectionStart(), this.textPane.getSelectionEnd());
    }

    private void highlightEditedSentence() {
        this.highlightSentence(this.textPane.getCaretPosition());
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    private void setFont() {
        if (tlp instanceof ChineseTreebankLanguagePack) {
            this.setChineseFont();
        } else {
            this.textPane.setFont(new Font("Sans Serif", 0, 14));
            this.treePanel.setFont(new Font("Sans Serif", 0, 14));
        }
    }

    private void setChineseFont() {
        List<Font> fonts = FontDetector.supportedFonts(0);
        if (fonts.size() > 0) {
            Font font = new Font(fonts.get(0).getName(), 0, 14);
            this.textPane.setFont(font);
            this.treePanel.setFont(font);
            log.info("Selected font " + font);
        } else if (FontDetector.hasFont("Watanabe Mincho")) {
            this.textPane.setFont(new Font("Watanabe Mincho", 0, 14));
            this.treePanel.setFont(new Font("Watanabe Mincho", 0, 14));
        } else {
            this.textPane.setFont(new Font("Sans Serif", 0, 14));
            this.treePanel.setFont(new Font("Sans Serif", 0, 14));
        }
    }

    public void parse() {
        if (this.textPane.getText().length() == 0) {
            return;
        }
        String text = this.textPane.getText().substring(this.startIndex, this.endIndex + 1).trim();
        if (this.parser != null && text.length() > 0) {
            Tokenizer<? extends HasWord> toke = tlp.getTokenizerFactory().getTokenizer(new StringReader(text));
            List<? extends HasWord> wordList = toke.tokenize();
            this.parseThread = new ParseThread(wordList);
            this.parseThread.start();
            this.startProgressMonitor("Parsing", 30);
        }
    }

    public void loadFile() {
        this.pageDialog.setLocation(this.getLocationOnScreen().x + (this.getWidth() - this.pageDialog.getWidth()) / 2, this.getLocationOnScreen().y + (this.getHeight() - this.pageDialog.getHeight()) / 2);
        this.pageDialog.setVisible(true);
        if (this.pageDialog.getStatus() == 1) {
            this.loadFile(this.pageDialog.getPage());
        }
    }

    public void loadFile(String filename) {
        Document doc;
        if (filename == null) {
            return;
        }
        File file = new File(filename);
        String urlOrFile = filename;
        if (!file.exists() && filename.indexOf("://") == -1) {
            urlOrFile = "http://" + filename;
        } else if (filename.indexOf("://") == -1) {
            urlOrFile = "file://" + filename;
        }
        try {
            if (urlOrFile.startsWith("http://") || urlOrFile.endsWith(".htm") || urlOrFile.endsWith(".html")) {
                BasicDocument docPre = new BasicDocument().init(new URL(urlOrFile));
                StripTagsProcessor noTags = new StripTagsProcessor();
                doc = noTags.processDocument(docPre);
            } else {
                doc = new BasicDocument(this.getTokenizerFactory()).init(new InputStreamReader((InputStream)new FileInputStream(filename), this.encoding));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not load file " + filename + "\n" + e, null, 0);
            e.printStackTrace();
            this.setStatus("Error loading document");
            return;
        }
        StringBuilder docStr = new StringBuilder();
        for (Word aDoc : doc) {
            if (docStr.length() > 0) {
                docStr.append(' ');
            }
            docStr.append(aDoc.toString());
        }
        this.textPane.setText(docStr.toString());
        this.dataFileLabel.setText(urlOrFile);
        this.highlightSentence(0);
        this.forwardButton.setEnabled(this.endIndex != this.textPane.getText().length() - 1);
        this.textPane.setCaretPosition(0);
        this.setStatus("Done");
    }

    private static TokenizerFactory<Word> getTokenizerFactory() {
        return tlp.getTokenizerFactory();
    }

    public void saveOutput() {
        if (this.textPane.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "No text to parse ", null, 0);
            return;
        }
        this.jfc.setDialogTitle("Save file");
        int status = this.jfc.showSaveDialog(this);
        if (status == 0) {
            this.saveOutput(this.jfc.getSelectedFile().getPath());
        }
    }

    public void saveOutput(String filename) {
        if (filename == null || filename.equals("")) {
            return;
        }
        String text = this.textPane.getText();
        StringReader reader = new StringReader(text);
        DocumentPreprocessor processor = new DocumentPreprocessor(reader);
        TokenizerFactory<? extends HasWord> tf = tlp.getTokenizerFactory();
        processor.setTokenizerFactory(tf);
        ArrayList<List<HasWord>> sentences = new ArrayList<List<HasWord>>();
        for (List<HasWord> sentence : processor) {
            sentences.add(sentence);
        }
        JProgressBar progress = new JProgressBar(0, sentences.size());
        JButton cancel = new JButton();
        JDialog dialog = new JDialog(new Frame(), "Parser Progress", true);
        dialog.setSize(300, 150);
        dialog.add("North", new JLabel("Parsing " + sentences.size() + " sentences"));
        dialog.add("Center", progress);
        dialog.add("South", cancel);
        SaveOutputThread thread = new SaveOutputThread(filename, progress, dialog, cancel, sentences);
        cancel.setText("Cancel");
        cancel.setToolTipText("Cancel");
        cancel.addActionListener(evt -> {
            thread.cancelled = true;
        });
        thread.start();
        dialog.setVisible(true);
    }

    public void loadParser() {
        this.jfc.setDialogTitle("Load parser");
        int status = this.jfc.showOpenDialog(this);
        if (status == 0) {
            String filename = this.jfc.getSelectedFile().getPath();
            if (filename.endsWith(".jar")) {
                String model = this.chooseJarParser.show(filename, this.jfcLocation.location);
                if (model != null) {
                    this.loadJarParser(filename, model);
                }
            } else {
                this.loadParser(filename);
            }
        }
    }

    public void loadJarParser(String jarFile, String model) {
        this.lpThread = new LoadParserThread(jarFile, model);
        this.lpThread.start();
        this.startProgressMonitor("Loading Parser", 60);
    }

    public void loadParser(String filename) {
        if (filename == null) {
            return;
        }
        File file = new File(filename);
        if (file.exists()) {
            this.lpThread = new LoadParserThread(filename);
            this.lpThread.start();
            this.startProgressMonitor("Loading Parser", 60);
        } else {
            JOptionPane.showMessageDialog(this, "Could not find file " + filename, null, 0);
            this.setStatus("Error loading parser");
        }
    }

    private void startProgressMonitor(String text, int maxCount) {
        if (this.glassPane == null && this.getRootPane() != null) {
            this.glassPane = this.getRootPane().getGlassPane();
            this.glassPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    Toolkit.getDefaultToolkit().beep();
                }
            });
        }
        if (this.glassPane != null) {
            this.glassPane.setVisible(true);
        }
        this.statusLabel.setText(text);
        this.progressBar.setMaximum(maxCount);
        this.progressBar.setValue(0);
        this.count = 0;
        this.timer.start();
        this.progressBar.setVisible(true);
    }

    private void stopProgressMonitor() {
        this.timer.stop();
        this.progressBar.setVisible(false);
        if (this.glassPane != null) {
            this.glassPane.setVisible(false);
        }
        this.lpThread = null;
        this.parseThread = null;
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.topPanel = new JPanel();
        this.buttonsAndFilePanel = new JPanel();
        this.loadButtonPanel = new JPanel();
        this.loadFileButton = new JButton();
        this.loadParserButton = new JButton();
        this.saveOutputButton = new JButton();
        this.buttonPanel = new JPanel();
        this.backButton = new JButton();
        if (this.getClass().getResource("/edu/stanford/nlp/parser/ui/leftarrow.gif") != null) {
            this.backButton.setIcon(new ImageIcon(this.getClass().getResource("/edu/stanford/nlp/parser/ui/leftarrow.gif")));
        } else {
            this.backButton.setText("< Prev");
        }
        this.forwardButton = new JButton();
        if (this.getClass().getResource("/edu/stanford/nlp/parser/ui/rightarrow.gif") != null) {
            this.forwardButton.setIcon(new ImageIcon(this.getClass().getResource("/edu/stanford/nlp/parser/ui/rightarrow.gif")));
        } else {
            this.forwardButton.setText("Next >");
        }
        this.parseButton = new JButton();
        this.parseNextButton = new JButton();
        this.clearButton = new JButton();
        this.dataFilePanel = new JPanel();
        this.dataFileLabel = new JLabel();
        this.textScrollPane = new JScrollPane();
        this.textPane = new JTextPane();
        this.treeContainer = new JPanel();
        this.parserFilePanel = new JPanel();
        this.parserFileLabel = new JLabel();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(false);
        this.setLayout(new BorderLayout());
        this.splitPane.setOrientation(0);
        this.topPanel.setLayout(new BorderLayout());
        this.buttonsAndFilePanel.setLayout(new BoxLayout(this.buttonsAndFilePanel, 1));
        this.loadButtonPanel.setLayout(new FlowLayout(0));
        this.loadFileButton.setText("Load File");
        this.loadFileButton.setToolTipText("Load a data file.");
        this.loadFileButton.addActionListener(evt -> this.loadFileButtonActionPerformed(evt));
        this.loadButtonPanel.add(this.loadFileButton);
        this.loadParserButton.setText("Load Parser");
        this.loadParserButton.setToolTipText("Load a serialized parser.");
        this.loadParserButton.addActionListener(evt -> this.loadParserButtonActionPerformed(evt));
        this.loadButtonPanel.add(this.loadParserButton);
        this.saveOutputButton.setText("Save Output");
        this.saveOutputButton.setToolTipText("Save the processed output.");
        this.saveOutputButton.setEnabled(false);
        this.saveOutputButton.addActionListener(evt -> this.saveOutputButtonActionPerformed(evt));
        this.loadButtonPanel.add(this.saveOutputButton);
        this.buttonsAndFilePanel.add(this.loadButtonPanel);
        this.buttonPanel.setLayout(new FlowLayout(0));
        this.backButton.setToolTipText("Scroll backward one sentence.");
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(evt -> this.backButtonActionPerformed(evt));
        this.buttonPanel.add(this.backButton);
        this.forwardButton.setToolTipText("Scroll forward one sentence.");
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(evt -> this.forwardButtonActionPerformed(evt));
        this.buttonPanel.add(this.forwardButton);
        this.parseButton.setText("Parse");
        this.parseButton.setToolTipText("Parse selected sentence.");
        this.parseButton.setEnabled(false);
        this.parseButton.addActionListener(evt -> this.parseButtonActionPerformed(evt));
        this.buttonPanel.add(this.parseButton);
        this.parseNextButton.setText("Parse >");
        this.parseNextButton.setToolTipText("Parse selected sentence and then scrolls forward one sentence.");
        this.parseNextButton.setEnabled(false);
        this.parseNextButton.addActionListener(evt -> this.parseNextButtonActionPerformed(evt));
        this.buttonPanel.add(this.parseNextButton);
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clears parse tree.");
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(evt -> this.clearButtonActionPerformed(evt));
        this.buttonPanel.add(this.clearButton);
        this.buttonsAndFilePanel.add(this.buttonPanel);
        this.dataFilePanel.setLayout(new FlowLayout(0));
        this.dataFilePanel.add(this.dataFileLabel);
        this.buttonsAndFilePanel.add(this.dataFilePanel);
        this.topPanel.add((Component)this.buttonsAndFilePanel, "North");
        this.textPane.setPreferredSize(new Dimension(250, 250));
        this.textPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ParserPanel.this.textPaneFocusLost(evt);
            }
        });
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ParserPanel.this.textPaneMouseClicked(evt);
            }
        });
        this.textPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ParserPanel.this.textPaneMouseDragged(evt);
            }
        });
        this.textScrollPane.setViewportView(this.textPane);
        this.topPanel.add((Component)this.textScrollPane, "Center");
        this.splitPane.setLeftComponent(this.topPanel);
        this.treeContainer.setLayout(new BorderLayout());
        this.treeContainer.setBackground(new Color(255, 255, 255));
        this.treeContainer.setBorder(new BevelBorder(0));
        this.treeContainer.setForeground(new Color(0, 0, 0));
        this.treeContainer.setPreferredSize(new Dimension(200, 200));
        this.treePanel = new TreeJPanel();
        this.treeContainer.add("Center", this.treePanel);
        this.treePanel.setBackground(Color.white);
        this.parserFilePanel.setLayout(new FlowLayout(0));
        this.parserFilePanel.setBackground(new Color(255, 255, 255));
        this.parserFileLabel.setText("Parser: None");
        this.parserFilePanel.add(this.parserFileLabel);
        this.treeContainer.add((Component)this.parserFilePanel, "North");
        this.splitPane.setRightComponent(this.treeContainer);
        this.add((Component)this.splitPane, "Center");
        this.statusPanel.setLayout(new FlowLayout(0));
        this.statusLabel.setText("Ready");
        this.statusPanel.add(this.statusLabel);
        this.progressBar.setName("");
        this.statusPanel.add(this.progressBar);
        this.add((Component)this.statusPanel, "South");
    }

    private void textPaneFocusLost(FocusEvent evt) {
        this.highlightEditedSentence();
    }

    private void parseNextButtonActionPerformed(ActionEvent evt) {
        this.parse();
        this.scrollWhenDone = true;
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.treePanel.setTree(null);
        this.clearButton.setEnabled(false);
    }

    private void textPaneMouseDragged(MouseEvent evt) {
        this.highlightSelectedSentence();
    }

    private void textPaneMouseClicked(MouseEvent evt) {
        this.highlightSelectedSentence();
    }

    private void parseButtonActionPerformed(ActionEvent evt) {
        this.parse();
        this.scrollWhenDone = false;
    }

    private void loadParserButtonActionPerformed(ActionEvent evt) {
        this.loadParser();
    }

    private void saveOutputButtonActionPerformed(ActionEvent evt) {
        this.saveOutput();
    }

    private void loadFileButtonActionPerformed(ActionEvent evt) {
        this.loadFile();
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        this.scrollBack();
    }

    private void forwardButtonActionPerformed(ActionEvent evt) {
        this.scrollForward();
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParserPanel.this.progressBar.setValue(Math.min(ParserPanel.this.count++, ParserPanel.this.progressBar.getMaximum() - 1));
        }
    }

    private static class JFileChooserLocation
    implements AncestorListener {
        Point location;
        JFileChooser jfc;

        JFileChooserLocation(JFileChooser jfc) {
            this.jfc = jfc;
            jfc.addAncestorListener(this);
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.location = this.jfc.getTopLevelAncestor().getLocationOnScreen();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            this.location = this.jfc.getTopLevelAncestor().getLocationOnScreen();
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    }

    private class ParseThread
    extends Thread {
        List<? extends HasWord> sentence;

        public ParseThread(List<? extends HasWord> sentence) {
            this.sentence = sentence;
        }

        @Override
        public void run() {
            boolean successful;
            ParserQuery parserQuery = ParserPanel.this.parser.parserQuery();
            try {
                successful = parserQuery.parse(this.sentence);
            }
            catch (Exception e) {
                ParserPanel.this.stopProgressMonitor();
                JOptionPane.showMessageDialog(ParserPanel.this, "Could not parse selected sentence\n(sentence probably too long)", null, 0);
                ParserPanel.this.setStatus("Error parsing");
                return;
            }
            ParserPanel.this.stopProgressMonitor();
            ParserPanel.this.setStatus("Done");
            if (successful) {
                Tree tree = parserQuery.getBestParse();
                ParserPanel.this.treePanel.setTree(tree);
                ParserPanel.this.clearButton.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(ParserPanel.this, "Could not parse selected sentence", null, 0);
                ParserPanel.this.setStatus("Error parsing");
                ParserPanel.this.treePanel.setTree(null);
                ParserPanel.this.clearButton.setEnabled(false);
            }
            if (ParserPanel.this.scrollWhenDone) {
                ParserPanel.this.scrollForward();
            }
        }
    }

    private class LoadParserThread
    extends Thread {
        final String zipFilename;
        final String filename;

        LoadParserThread(String filename) {
            this.filename = filename;
            this.zipFilename = null;
        }

        LoadParserThread(String zipFilename, String filename) {
            this.zipFilename = zipFilename;
            this.filename = filename;
        }

        @Override
        public void run() {
            try {
                if (this.zipFilename != null) {
                    ParserPanel.this.parser = LexicalizedParser.loadModelFromZip(this.zipFilename, this.filename);
                } else {
                    ParserPanel.this.parser = LexicalizedParser.loadModel(this.filename, new String[0]);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(ParserPanel.this, "Error loading parser: " + this.filename, null, 0);
                ParserPanel.this.setStatus("Error loading parser");
                ParserPanel.this.parser = null;
            }
            catch (OutOfMemoryError e) {
                JOptionPane.showMessageDialog(ParserPanel.this, "Could not load parser. Out of memory.", null, 0);
                ParserPanel.this.setStatus("Error loading parser");
                ParserPanel.this.parser = null;
            }
            ParserPanel.this.stopProgressMonitor();
            if (ParserPanel.this.parser != null) {
                ParserPanel.this.setStatus("Loaded parser.");
                ParserPanel.this.parserFileLabel.setText("Parser: " + this.filename);
                ParserPanel.this.parseButton.setEnabled(true);
                ParserPanel.this.parseNextButton.setEnabled(true);
                ParserPanel.this.saveOutputButton.setEnabled(true);
                tlp = ParserPanel.this.parser.getOp().langpack();
                ParserPanel.this.encoding = tlp.getEncoding();
            }
        }
    }

    class SaveOutputThread
    extends Thread {
        String filename;
        JProgressBar progress;
        JDialog dialog;
        JButton button;
        List<List<HasWord>> sentences;
        boolean cancelled;

        public SaveOutputThread(String filename, JProgressBar progress, JDialog dialog, JButton button, List<List<HasWord>> sentences) {
            this.filename = filename;
            this.progress = progress;
            this.dialog = dialog;
            this.button = button;
            this.sentences = sentences;
        }

        @Override
        public void run() {
            int failures = 0;
            try {
                FileOutputStream fos = new FileOutputStream(this.filename);
                OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, "utf-8");
                BufferedWriter bw = new BufferedWriter(ow);
                for (List<HasWord> sentence : this.sentences) {
                    Tree tree = ParserPanel.this.parser.parseTree(sentence);
                    if (tree == null) {
                        ++failures;
                        log.info("Failed on sentence " + sentence);
                    } else {
                        bw.write(tree.toString());
                        bw.newLine();
                    }
                    this.progress.setValue(this.progress.getValue() + 1);
                    if (!this.cancelled) continue;
                    break;
                }
                bw.flush();
                bw.close();
                ow.close();
                fos.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(ParserPanel.this, "Could not save file " + this.filename + "\n" + e, null, 0);
                e.printStackTrace();
                ParserPanel.this.setStatus("Error saving parsed document");
            }
            if (failures == 0) {
                this.button.setText("Success!");
            } else {
                this.button.setText("Done.  " + failures + " parses failed");
            }
            if (this.cancelled && failures == 0) {
                this.dialog.setVisible(false);
            } else {
                this.button.addActionListener(evt -> this.dialog.setVisible(false));
            }
        }
    }
}

