/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.patterns.TextAnnotationPatterns;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;

public class TextAnnotationPatternsInterface {
    private ServerSocket server;

    public TextAnnotationPatternsInterface(int portnum) throws IOException {
        this.server = new ServerSocket(portnum);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("The modeling server is running.");
        int clientNumber = 0;
        ServerSocket listener = new ServerSocket(9898);
        try {
            while (true) {
                new PerformActionUpdateModel(listener.accept(), clientNumber++).start();
            }
        }
        catch (Throwable throwable) {
            listener.close();
            throw throwable;
        }
    }

    private static class PerformActionUpdateModel
    extends Thread {
        private Socket socket;
        private int clientNumber;
        TextAnnotationPatterns annotate;

        public PerformActionUpdateModel(Socket socket, int clientNumber) throws IOException {
            this.socket = socket;
            this.clientNumber = clientNumber;
            this.annotate = new TextAnnotationPatterns();
            PerformActionUpdateModel.log("New connection with client# " + clientNumber + " at " + socket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PrintWriter out2 = null;
            String msg = "";
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                out2 = new PrintWriter(this.socket.getOutputStream(), true);
            }
            catch (IOException e) {
                try {
                    this.socket.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
            out2.println("The possible actions are " + Arrays.toString((Object[])Actions.values()) + ".Enter a line with only a period to quit");
            Actions nextlineAction = Actions.NONE;
            while (true) {
                try {
                    String line = in.readLine();
                    if (line == null || line.equals(".")) break;
                    String[] toks = line.split("###");
                    try {
                        nextlineAction = Actions.valueOf(toks[0].trim());
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println("read " + toks[0] + " and cannot understand");
                        msg = "Did not understand " + toks[0] + ". POSSIBLE ACTIONS ARE: " + Arrays.toString((Object[])Actions.values());
                    }
                    String input = toks.length == 2 ? toks[1] : null;
                    switch (nextlineAction) {
                        case NEWPHRASES: {
                            msg = this.annotate.doNewPhrases(input);
                            break;
                        }
                        case REMOVEPHRASES: {
                            msg = this.annotate.doRemovePhrases(input);
                            break;
                        }
                        case NEWANNOTATIONS: {
                            msg = this.annotate.doNewAnnotations(input);
                            break;
                        }
                        case PROCESSFILE: {
                            this.annotate.setUpProperties(input, true, true, null);
                            msg = this.annotate.processText(true);
                            break;
                        }
                        case REMOVEANNOTATIONS: {
                            msg = this.annotate.doRemoveAnnotations(input);
                            break;
                        }
                        case SUGGEST: {
                            msg = this.annotate.suggestPhrases();
                            break;
                        }
                        case MATCHEDTOKENSBYALL: {
                            msg = this.annotate.getMatchedTokensByAllPhrases();
                            break;
                        }
                        case MATCHEDTOKENSBYPHRASE: {
                            msg = this.annotate.getMatchedTokensByPhrase(input);
                            break;
                        }
                        case ALLANNOTATIONS: {
                            msg = this.annotate.getAllAnnotations();
                            break;
                        }
                        case ANNOTATIONSBYSENT: {
                            msg = this.annotate.getAllAnnotations(input);
                            break;
                        }
                        case SUMMARY: {
                            msg = this.annotate.currentSummary();
                            break;
                        }
                        case NONE: {
                            break;
                        }
                        case CLOSE: {
                            msg = "bye!";
                        }
                    }
                    System.out.println("sending msg " + msg);
                    continue;
                }
                catch (Exception e) {
                    msg = "ERROR " + e.toString().replaceAll("\n", "\t") + ". REDO.";
                    nextlineAction = Actions.NONE;
                    PerformActionUpdateModel.log("Error handling client# " + this.clientNumber);
                    e.printStackTrace();
                    continue;
                }
                finally {
                    out2.println(msg);
                    continue;
                }
                break;
            }
        }

        private static void log(String message) {
            System.out.println(message);
        }
    }

    public static enum Actions {
        NEWPHRASES("adds new phrases, that is, phrase X is of label l"),
        REMOVEPHRASES("removes phrases"),
        NEWANNOTATIONS("adds new annotations, that is, when is the feedback is token x, y, z of sentence w are label l"),
        PROCESSFILE("the first command to run to process the sentences and write back the tokenized/labeled file"),
        REMOVEANNOTATIONS("opposite of NEWANNOTATIONS"),
        SUGGEST("ask for suggestions. Runs GetPatternsFromDataMultiClass"),
        MATCHEDTOKENSBYALL("Sentence and token ids (starting at 0) matched by all the phrases"),
        MATCHEDTOKENSBYPHRASE("Sentence and token ids (starting at 0) matched by the given phrase"),
        ALLANNOTATIONS("If a token is labeled, it's label. returns for each sentence id, labeled_tokenid -> label. Only for tokens that are labeled."),
        ANNOTATIONSBYSENT("For the given sentence, the labeled token ids and their corresponding labels"),
        SUMMARY("Phrases that have been labeled by humans"),
        NONE("Nothing happens"),
        CLOSE("Close the socket");

        String whatitdoes;

        private Actions(String whatitdoes) {
            this.whatitdoes = whatitdoes;
        }
    }
}

