/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QuantifiableEntityNormalizingAnnotatorITest {
    private static AnnotationPipeline pipeline;
    static final String text = "On January 3 1980, Ellinais used the 2nd century A.D. temple of Zeus in Athens to stage the first known ceremony of the kind since the late 4th century.";
    private static final String[] answer_text;
    private static final String[] answer_time;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        Class<QuantifiableEntityNormalizingAnnotatorITest> clazz = QuantifiableEntityNormalizingAnnotatorITest.class;
        synchronized (QuantifiableEntityNormalizingAnnotatorITest.class) {
            Properties props = new Properties();
            props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner");
            pipeline = new StanfordCoreNLP(props);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Test
    public void testQuantifiableEntityNormalizingAnnotator() {
        Annotation document = new Annotation(text);
        pipeline.annotate(document);
        int i = 0;
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            for (CoreLabel token : tokens) {
                System.out.println((String)token.get(CoreAnnotations.TextAnnotation.class) + ": " + (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class) + ", " + (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class));
            }
            for (CoreLabel token : tokens) {
                String normalization = (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                if (normalization == null) continue;
                Assert.assertEquals((Object)answer_text[i], token.get(CoreAnnotations.OriginalTextAnnotation.class));
                Assert.assertEquals((Object)answer_time[i], (Object)normalization);
                ++i;
            }
        }
        Assert.assertEquals((long)answer_text.length, (long)i);
        Assert.assertEquals((long)answer_time.length, (long)i);
    }

    static {
        answer_text = new String[]{"January", "3", "1980", "the", "2nd", "century", "A.D.", "first", "the", "late", "4th", "century"};
        answer_time = new String[]{"1980-01-03", "1980-01-03", "1980-01-03", "01XX", "01XX", "01XX", "01XX", "1.0", "03XX", "03XX", "03XX", "03XX"};
    }
}

