/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.AbstractInputStreamAnnotationCreator;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.ReflectionLoading;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SerializedAnnotationCreator
extends AbstractInputStreamAnnotationCreator {
    AnnotationSerializer serializer;

    public SerializedAnnotationCreator(AnnotationSerializer serializer) {
        this.serializer = serializer;
    }

    public SerializedAnnotationCreator(String name, Properties props) {
        String serializerClass = props.getProperty(name + ".serializer");
        this.serializer = (AnnotationSerializer)ReflectionLoading.loadByReflection(serializerClass, new Object[0]);
    }

    @Override
    public Annotation create(InputStream stream, String encoding) throws IOException {
        try {
            Pair<Annotation, InputStream> pair = this.serializer.read(stream);
            ((InputStream)pair.second).close();
            Annotation annotation = (Annotation)pair.first;
            return annotation;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

