/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.junit.Assert;

public class TrueCaseAnnotatorITest
extends TestCase {
    private static final boolean VERBOSE = false;

    private static void runSentence(StanfordCoreNLP pipeline, String sentence, String[] ans) {
        Annotation document = new Annotation(sentence);
        pipeline.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((String)("Wrong number of tokens: " + tokens + " vs. " + ans.length), (long)ans.length, (long)tokens.size());
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        Assert.assertNotNull((Object)sentences);
        Assert.assertEquals((String)"Wrong number of sentences", (long)1L, (long)sentences.size());
        for (CoreMap sent : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            List words = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
            for (int i = 0; i < words.size(); ++i) {
                String w = ((CoreLabel)words.get(i)).word();
                String tcw = (String)((CoreLabel)words.get(i)).get(CoreAnnotations.TrueCaseTextAnnotation.class);
                TrueCaseAnnotatorITest.assertEquals((String)"Error in truecasing", (String)ans[i], (String)tcw);
            }
        }
    }

    public void testTrueCaseAnnotator() {
        String text1 = "HEATHER BROWN WAS LEAD WOMAN AT DUKE UNIVERSITY.";
        String text2 = "heather brown was lead woman at duke university.";
        String text3 = "Heather Brown was lead woman at Duke University.";
        String[] ans1 = new String[]{"Heather", "Brown", "was", "lead", "woman", "at", "Duke", "University", "."};
        String text4 = "\"GOOD MORNING AMERICA FROM MCVEY!\"";
        String text5 = "\"good morning america from mcvey!\"";
        String text6 = "\"Good Morning America From McVey!\"";
        String[] ans4 = new String[]{"``", "Good", "Morning", "America", "from", "McVey", "!", "''"};
        Properties props = PropertiesUtils.asProperties("annotators", "tokenize, ssplit, truecase");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        TrueCaseAnnotatorITest.runSentence(pipeline, text1, ans1);
        TrueCaseAnnotatorITest.runSentence(pipeline, text2, ans1);
        TrueCaseAnnotatorITest.runSentence(pipeline, text3, ans1);
        TrueCaseAnnotatorITest.runSentence(pipeline, text4, ans4);
        TrueCaseAnnotatorITest.runSentence(pipeline, text5, ans4);
        TrueCaseAnnotatorITest.runSentence(pipeline, text6, ans4);
    }
}

