/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BammanCorefReader {
    public static Map<Integer, List<CoreLabel>> readTokenFile(String filename, Annotation novel) {
        List<String> lines = IOUtils.linesFromFile(filename);
        HashMap<Integer, List<CoreLabel>> charsToTokens = new HashMap<Integer, List<CoreLabel>>();
        boolean first = true;
        int tokenOffset = 0;
        for (String line : lines) {
            if (first) {
                first = false;
                continue;
            }
            String[] pieces = line.split("\t");
            int tokenId = Integer.parseInt(pieces[2]) + tokenOffset;
            String token = pieces[7];
            String normalizedTok = pieces[8];
            int characterId = Integer.parseInt(pieces[14]);
            CoreLabel novelTok = (CoreLabel)((List)novel.get(CoreAnnotations.TokensAnnotation.class)).get(tokenId);
            if (pieces[7].equals(". . . .") && !((String)novelTok.get(CoreAnnotations.OriginalTextAnnotation.class)).equals(". . . .")) {
                ++tokenOffset;
            }
            if (characterId == -1) continue;
            if (!((String)novelTok.get(CoreAnnotations.TextAnnotation.class)).equals(normalizedTok)) {
                System.err.println(token + " != " + (String)novelTok.get(CoreAnnotations.TextAnnotation.class));
                continue;
            }
            if (!charsToTokens.containsKey(characterId)) {
                charsToTokens.put(characterId, new ArrayList());
            }
            ((List)charsToTokens.get(characterId)).add(novelTok);
        }
        return charsToTokens;
    }
}

