/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.QMSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.Sieves.QMSieves.QMSieve;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConversationalSieve
extends QMSieve {
    public ConversationalSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet, "conv");
    }

    @Override
    public void doQuoteToMention(Annotation doc) {
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        List tokens = (List)doc.get(CoreAnnotations.TokensAnnotation.class);
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        for (int index = 2; index < quotes.size(); ++index) {
            CoreLabel prevToken;
            CoreMap prevSentence;
            CoreMap currQuote = (CoreMap)quotes.get(index);
            CoreMap prevQuote = (CoreMap)quotes.get(index - 1);
            CoreMap twoPrevQuote = (CoreMap)quotes.get(index - 2);
            int twoPrevPara = this.getQuoteParagraph(twoPrevQuote);
            for (int i = index - 3; i >= 0 && this.getQuoteParagraph((CoreMap)quotes.get(i)) == twoPrevPara; --i) {
                twoPrevQuote = (CoreMap)quotes.get(i);
            }
            int tokenBeginIdx = (Integer)currQuote.get(CoreAnnotations.TokenBeginAnnotation.class);
            int tokenEndIdx = (Integer)currQuote.get(CoreAnnotations.TokenEndAnnotation.class);
            CoreMap currQuoteBeginSentence = (CoreMap)sentences.get((Integer)currQuote.get(CoreAnnotations.SentenceBeginAnnotation.class));
            boolean isAloneInParagraph = true;
            if (tokenBeginIdx > 0 && ((Integer)(prevSentence = (CoreMap)sentences.get((Integer)(prevToken = (CoreLabel)tokens.get(tokenBeginIdx - 1)).get(CoreAnnotations.SentenceIndexAnnotation.class))).get(CoreAnnotations.ParagraphIndexAnnotation.class)).equals(currQuoteBeginSentence.get(CoreAnnotations.ParagraphIndexAnnotation.class))) {
                isAloneInParagraph = false;
            }
            if (tokenEndIdx < tokens.size() - 1) {
                CoreMap nextSentence;
                CoreLabel currToken = (CoreLabel)tokens.get(tokenEndIdx + 1);
                while (currToken.isNewline().booleanValue() && tokenEndIdx + 1 < tokens.size() - 1) {
                    currToken = (CoreLabel)tokens.get(++tokenEndIdx + 1);
                }
                if (!currToken.isNewline().booleanValue() && ((Integer)(nextSentence = (CoreMap)sentences.get((Integer)currToken.get(CoreAnnotations.SentenceIndexAnnotation.class))).get(CoreAnnotations.ParagraphIndexAnnotation.class)).equals(currQuoteBeginSentence.get(CoreAnnotations.ParagraphIndexAnnotation.class))) {
                    isAloneInParagraph = false;
                }
            }
            if (twoPrevQuote.get(QuoteAttributionAnnotator.MentionAnnotation.class) == null || !isAloneInParagraph || currQuote.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null || ((String)twoPrevQuote.get(QuoteAttributionAnnotator.MentionTypeAnnotation.class)).equals("pronoun") || this.getQuoteParagraph(currQuote) != this.getQuoteParagraph(prevQuote) + 1 || this.getQuoteParagraph(prevQuote) != this.getQuoteParagraph(twoPrevQuote) + 1) continue;
            ConversationalSieve.fillInMention(currQuote, this.getMentionData(twoPrevQuote), this.sieveName);
        }
    }
}

