/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.ProbabilityDistribution;
import java.util.Random;

public class DirichletProcess<E>
implements ProbabilityDistribution<E> {
    private static final long serialVersionUID = -8653536087199951278L;
    private final ProbabilityDistribution<E> baseMeasure;
    private final double alpha;
    private final ClassicCounter<E> sampled;

    public DirichletProcess(ProbabilityDistribution<E> baseMeasure, double alpha) {
        this.baseMeasure = baseMeasure;
        this.alpha = alpha;
        this.sampled = new ClassicCounter();
        this.sampled.incrementCount(null, alpha);
    }

    @Override
    public E drawSample(Random random) {
        E drawn = Counters.sample(this.sampled);
        if (drawn == null) {
            drawn = this.baseMeasure.drawSample(random);
        }
        this.sampled.incrementCount(drawn);
        return drawn;
    }

    public double numOccurances(E object) {
        if (object == null) {
            throw new RuntimeException("You cannot ask for the number of occurances of null.");
        }
        return this.sampled.getCount(object);
    }

    @Override
    public double probabilityOf(E object) {
        if (object == null) {
            throw new RuntimeException("You cannot ask for the probability of null.");
        }
        if (this.sampled.keySet().contains(object)) {
            return this.sampled.getCount(object) / this.sampled.totalCount();
        }
        return 0.0;
    }

    @Override
    public double logProbabilityOf(E object) {
        return Math.log(this.probabilityOf(object));
    }

    public double probabilityOfNewObject() {
        return this.alpha / this.sampled.totalCount();
    }
}

