/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonParseException;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonRuntimeException;
import edu.stanford.nlp.util.Pair;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

public class TsurgeonTest
extends TestCase {
    public static Tree treeFromString(String s) {
        try {
            PennTreeReader tr = new PennTreeReader(new StringReader(s), new LabeledScoredTreeFactory());
            return tr.readTree();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void testBackReference() {
        TregexPattern tregex = TregexPattern.compile("__ <1 B=n <2 ~n");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("relabel n X");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B w) (B w))", "(A (X w) (B w))");
    }

    public void testForeign() {
        TregexPattern tregex = TregexPattern.compile("atent\u00e1t=test");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("relabel test perform_atent\u00e1t");
        TsurgeonTest.runTest(tregex, tsurgeon, "(foo atent\u00e1t)", "(foo perform_atent\u00e1t)");
    }

    public void testAdjoin() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("adjoin (FOO (BAR@)) foo");
        TregexPattern tregex = TregexPattern.compile("B=foo");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1 2))", "(A (FOO (BAR 1 2)))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (C 1 2))", "(A (C 1 2))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B (B 1 2)))", "(A (FOO (BAR (FOO (BAR 1 2)))))");
        Tree tree = TsurgeonTest.treeFromString("(A (B 1 2))");
        TregexMatcher matcher = tregex.matcher(tree);
        TsurgeonTest.assertTrue((boolean)matcher.find());
        TsurgeonTest.assertEquals((String)"(B 1 2)", (String)matcher.getNode("foo").toString());
        Tree updated = tsurgeon.matcher().evaluate(tree, matcher);
        TsurgeonTest.assertEquals((String)"(A (FOO (BAR 1 2)))", (String)updated.toString());
        TsurgeonTest.assertFalse((boolean)matcher.find());
    }

    public void testAdjoinH() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("adjoinH (FOO (BAR@)) foo");
        TregexPattern tregex = TregexPattern.compile("B=foo !< BAR");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1 2))", "(A (B (BAR 1 2)))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (C 1 2))", "(A (C 1 2))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B (B 1 2)))", "(A (B (BAR (B (BAR 1 2)))))");
        Tree tree = TsurgeonTest.treeFromString("(A (B 1 2))");
        TregexMatcher matcher = tregex.matcher(tree);
        TsurgeonTest.assertTrue((boolean)matcher.find());
        TsurgeonTest.assertEquals((String)"(B 1 2)", (String)matcher.getNode("foo").toString());
        Tree updated = tsurgeon.matcher().evaluate(tree, matcher);
        TsurgeonTest.assertEquals((String)"(A (B (BAR 1 2)))", (String)updated.toString());
        TsurgeonTest.assertEquals((String)"(B (BAR 1 2))", (String)matcher.getNode("foo").toString());
        TsurgeonTest.assertFalse((boolean)matcher.find());
    }

    public void testAdjoinF() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("adjoinF (FOO (BAR@)) foo");
        TregexPattern tregex = TregexPattern.compile("B=foo !> FOO");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1 2))", "(A (FOO (B 1 2)))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (C 1 2))", "(A (C 1 2))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B (B 1 2)))", "(A (FOO (B (FOO (B 1 2)))))");
        Tree tree = TsurgeonTest.treeFromString("(A (B 1 2))");
        TregexMatcher matcher = tregex.matcher(tree);
        TsurgeonTest.assertTrue((boolean)matcher.find());
        TsurgeonTest.assertEquals((String)"(B 1 2)", (String)matcher.getNode("foo").toString());
        Tree updated = tsurgeon.matcher().evaluate(tree, matcher);
        TsurgeonTest.assertEquals((String)"(A (FOO (B 1 2)))", (String)updated.toString());
        TsurgeonTest.assertEquals((String)"(B 1 2)", (String)matcher.getNode("foo").toString());
        TsurgeonTest.assertFalse((boolean)matcher.find());
    }

    public void testAdjoinWithNamedNode() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("[adjoinF (D (E=target foot@)) bar] [insert (G 1) $+ target]");
        TregexPattern tregex = TregexPattern.compile("B=bar !>> D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B C))", "(A (D (G 1) (E (B C))))");
        tsurgeon = Tsurgeon.parseOperation("[adjoinF (D (E=target foot@)) bar] [insert (G 1) >0 target]");
        tregex = TregexPattern.compile("B=bar !>> D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B C))", "(A (D (E (G 1) (B C))))");
        tsurgeon = Tsurgeon.parseOperation("[adjoinF (D (E foot@) F=target) bar] [insert (G 1) >0 target]");
        tregex = TregexPattern.compile("B=bar !>> D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B C))", "(A (D (E (B C)) (F (G 1))))");
    }

    public void testAuxiliaryTreeErrors() {
        try {
            TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("adjoin (FOO (BAR)) foo");
            throw new RuntimeException("Should have failed for not having a foot");
        }
        catch (TsurgeonParseException tsurgeonParseException) {
            try {
                TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("adjoin (FOO (BAR@) (BAZ@)) foo");
                throw new RuntimeException("Should have failed for having two feet");
            }
            catch (TsurgeonParseException tsurgeonParseException2) {
                try {
                    TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("adjoin (FOO@ (BAR)) foo");
                    throw new RuntimeException("Non-leaves cannot be foot nodes");
                }
                catch (TsurgeonParseException tsurgeonParseException3) {
                    return;
                }
            }
        }
    }

    public void testCreateSubtrees() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("createSubtree FOO left right");
        TregexPattern tregex = TregexPattern.compile("A < B=left < C=right");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (C 2))", "(A (FOO (B 1) (C 2)))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (C 1) (B 2))", "(A (FOO (C 1) (B 2)))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (D 3) (C 2))", "(A (FOO (B 1) (D 3) (C 2)))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (D 3) (B 1) (C 2))", "(A (D 3) (FOO (B 1) (C 2)))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (C 2) (D 3))", "(A (FOO (B 1) (C 2)) (D 3))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (D 3) (B 1) (C 2) (E 4))", "(A (D 3) (FOO (B 1) (C 2)) (E 4))");
        tregex = TregexPattern.compile("A < B=left < B=right");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (C 2))", "(A (FOO (B 1)) (C 2))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (B 2))", "(A (FOO (B 1)) (FOO (B 2)))");
        tsurgeon = Tsurgeon.parseOperation("createSubtree FOO child");
        tregex = TregexPattern.compile("A < B=child");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (C 2))", "(A (FOO (B 1)) (C 2))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (B 2))", "(A (FOO (B 1)) (FOO (B 2)))");
        try {
            tsurgeon = Tsurgeon.parseOperation("createSubtree FOO");
            throw new AssertionError((Object)"Expected to fail parsing");
        }
        catch (TsurgeonParseException tsurgeonParseException) {
            try {
                tsurgeon = Tsurgeon.parseOperation("createSubtree FOO a b c");
                throw new AssertionError((Object)"Expected to fail parsing");
            }
            catch (TsurgeonParseException tsurgeonParseException2) {
                tsurgeon = Tsurgeon.parseOperation("createSubtree FOO left right");
                tregex = TregexPattern.compile("A << B=left << C=right");
                try {
                    TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (D (C 2)))", "(A (B 1) (D (C 2)))");
                    throw new AssertionError((Object)"Expected a runtime failure");
                }
                catch (TsurgeonRuntimeException tsurgeonRuntimeException) {
                    return;
                }
            }
        }
    }

    public void testCreateSubtreesExtended() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("createSubtree (F (G 1) H@ I) left right");
        TregexPattern tregex = TregexPattern.compile("A < B=left < C=right");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (C 2))", "(A (F (G 1) (H (B 1) (C 2)) I))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (C 1) (B 2))", "(A (F (G 1) (H (C 1) (B 2)) I))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (D 3) (C 2))", "(A (F (G 1) (H (B 1) (D 3) (C 2)) I))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (D 3) (B 1) (C 2))", "(A (D 3) (F (G 1) (H (B 1) (C 2)) I))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (C 2) (D 3))", "(A (F (G 1) (H (B 1) (C 2)) I) (D 3))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (D 3) (B 1) (C 2) (E 4))", "(A (D 3) (F (G 1) (H (B 1) (C 2)) I) (E 4))");
        tregex = TregexPattern.compile("A < B=left < B=right");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (C 2))", "(A (F (G 1) (H (B 1)) I) (C 2))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (B 2))", "(A (F (G 1) (H (B 1)) I) (F (G 1) (H (B 2)) I))");
        tsurgeon = Tsurgeon.parseOperation("createSubtree (F (G 1) H@ I) child");
        tregex = TregexPattern.compile("A < B=child");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (C 2))", "(A (F (G 1) (H (B 1)) I) (C 2))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (B 2))", "(A (F (G 1) (H (B 1)) I) (F (G 1) (H (B 2)) I))");
        try {
            tsurgeon = Tsurgeon.parseOperation("createSubtree (F (G 1) H@ I)");
            throw new AssertionError((Object)"Expected to fail parsing");
        }
        catch (TsurgeonParseException tsurgeonParseException) {
            try {
                tsurgeon = Tsurgeon.parseOperation("createSubtree (F (G 1) H@ I) a b c");
                throw new AssertionError((Object)"Expected to fail parsing");
            }
            catch (TsurgeonParseException tsurgeonParseException2) {
                try {
                    tsurgeon = Tsurgeon.parseOperation("createSubtree (F (G 1) H I) a b c");
                    throw new AssertionError((Object)"Expected to fail parsing");
                }
                catch (TsurgeonParseException tsurgeonParseException3) {
                    tsurgeon = Tsurgeon.parseOperation("createSubtree (F (G 1) H@ I) left right");
                    tregex = TregexPattern.compile("A << B=left << C=right");
                    try {
                        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (D (C 2)))", "(A (B 1) (D (C 2)))");
                        throw new AssertionError((Object)"Expected a runtime failure");
                    }
                    catch (TsurgeonRuntimeException tsurgeonRuntimeException) {
                        return;
                    }
                }
            }
        }
    }

    public void testDelete() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("delete bob");
        TregexPattern tregex = TregexPattern.compile("B=bob");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B (C 1)))", "A");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (foo 1) (B (C 1)))", "(A (foo 1))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (B (C 1)))", "A");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (foo 1) (bar (C 1)))", "(A (foo 1) (bar (C 1)))");
        tregex = TregexPattern.compile("C=bob");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B (C 1)))", "(A B)");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (foo 1) (B (C 1)))", "(A (foo 1) B)");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (B (C 1)))", "(A (B 1) B)");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (foo 1) (bar (C 1)))", "(A (foo 1) bar)");
    }

    public void testPrune() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("prune bob");
        TregexPattern tregex = TregexPattern.compile("B=bob");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B (C 1)))", null);
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (foo 1) (B (C 1)))", "(A (foo 1))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (B (C 1)))", null);
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (foo 1) (bar (C 1)))", "(A (foo 1) (bar (C 1)))");
        tregex = TregexPattern.compile("C=bob");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B (C 1)))", null);
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (foo 1) (B (C 1)))", "(A (foo 1))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 1) (B (C 1)))", "(A (B 1))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (foo 1) (bar (C 1)))", "(A (foo 1))");
    }

    public void testInsert() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("insert (D (E 6)) $+ bar");
        TregexPattern tregex = TregexPattern.compile("B=bar !$ D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (C 1))", "(A (D (E 6)) (B 0) (C 1))");
        tsurgeon = Tsurgeon.parseOperation("insert (D (E 6)) $- bar");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (C 1))", "(A (B 0) (D (E 6)) (C 1))");
        tsurgeon = Tsurgeon.parseOperation("insert (D (E 6)) >0 bar");
        tregex = TregexPattern.compile("B=bar !<D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (C 1))", "(A (B (D (E 6)) 0) (C 1))");
        tsurgeon = Tsurgeon.parseOperation("insert foo >0 bar");
        tregex = TregexPattern.compile("B=bar !<C $C=foo");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (C 1))", "(A (B (C 1) 0) (C 1))");
        tsurgeon = Tsurgeon.parseOperation("insert (D (E=blah 6)) >0 bar");
        tregex = TregexPattern.compile("B=bar !<D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (C 1))", "(A (B (D (E 6)) 0) (C 1))");
        tsurgeon = Tsurgeon.parseOperation("insert (D (E\\=blah 6)) >0 bar");
        tregex = TregexPattern.compile("B=bar !<D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (C 1))", "(A (B (D (E=blah 6)) 0) (C 1))");
        tsurgeon = Tsurgeon.parseOperation("insert (D (E\\\\=blah 6)) >0 bar");
        tregex = TregexPattern.compile("B=bar !<D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (C 1))", "(A (B (D (E\\ 6)) 0) (C 1))");
    }

    public void testInsertWithNamedNode() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("[insert (D=target E) $+ bar] [insert (F 1) >0 target]");
        TregexPattern tregex = TregexPattern.compile("B=bar !$- D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B C))", "(A (D (F 1) E) (B C))");
        tsurgeon = Tsurgeon.parseOperation("[insert (D=target E) $+ bar] [insert (F 1) $+ target]");
        tregex = TregexPattern.compile("B=bar !$- D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B C))", "(A (F 1) (D E) (B C))");
        tsurgeon = Tsurgeon.parseOperation("[insert (D E=target) $+ bar] [insert (F 1) $+ target]");
        tregex = TregexPattern.compile("B=bar !$- D");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B C))", "(A (D (F 1) E) (B C))");
    }

    public void testRelabel() {
        TregexPattern tregex = TregexPattern.compile("/^((?!_head).)*$/=preTerminal < (__=terminal !< __)");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("relabel preTerminal /^(.*)$/$1_head=={terminal}/");
        TsurgeonTest.runTest(tregex, tsurgeon, "($ $)", "($_head=$ $)");
        tsurgeon = Tsurgeon.parseOperation("relabel foo blah");
        tregex = TregexPattern.compile("B=foo");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (C 1))", "(A (blah 0) (C 1))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (B 1))", "(A (blah 0) (blah 1))");
        tsurgeon = Tsurgeon.parseOperation("relabel foo /\\//");
        tregex = TregexPattern.compile("B=foo");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (C 1))", "(A (/ 0) (C 1))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (B 1))", "(A (/ 0) (/ 1))");
        tsurgeon = Tsurgeon.parseOperation("relabel foo /.*(voc.*)/$1/");
        tregex = TregexPattern.compile("/^a.*t/=foo");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (avocet 0) (C 1))", "(A (vocet 0) (C 1))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (avocet 0) (advocate 1))", "(A (vocet 0) (vocate 1))");
        tregex = TregexPattern.compile("curlew=baz < /^a(.*)t/#1%bar=foo");
        tsurgeon = Tsurgeon.parseOperation("relabel baz /cu(rle)w/={foo}/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(curlew (avocet 0))", "(avocet (avocet 0))");
        tsurgeon = Tsurgeon.parseOperation("relabel baz /cu(rle)w/%{bar}/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(curlew (avocet 0))", "(voce (avocet 0))");
        tsurgeon = Tsurgeon.parseOperation("relabel baz /cu(rle)w/$1/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(curlew (avocet 0))", "(rle (avocet 0))");
        tsurgeon = Tsurgeon.parseOperation("relabel baz /cu(rle)w/$1={foo}/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(curlew (avocet 0))", "(rleavocet (avocet 0))");
        tsurgeon = Tsurgeon.parseOperation("relabel baz /cu(rle)w/%{bar}$1={foo}/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(curlew (avocet 0))", "(vocerleavocet (avocet 0))");
        tregex = TregexPattern.compile("A=baz < /curlew.*/=foo < /avocet.*/=bar");
        tsurgeon = Tsurgeon.parseOperation("relabel baz /^.*$/={foo}={bar}/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (curlewfoo 0) (avocetzzz 1))", "(curlewfooavocetzzz (curlewfoo 0) (avocetzzz 1))");
        tregex = TregexPattern.compile("A=baz < /curle.*/=foo < /avo(.*)/#1%bar");
        tsurgeon = Tsurgeon.parseOperation("relabel baz /^(.*)$/={foo}$1%{bar}/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (curlew 0) (avocet 1))", "(curlewAcet (curlew 0) (avocet 1))");
        tsurgeon = Tsurgeon.parseOperation("relabel baz /^(.*)$/=foo$1%bar/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (curlew 0) (avocet 1))", "(=fooA%bar (curlew 0) (avocet 1))");
        tregex = TregexPattern.compile("/foo/=foo");
        tsurgeon = Tsurgeon.parseOperation("relabel foo /foo/bar/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(foofoo (curlew 0) (avocet 1))", "(barbar (curlew 0) (avocet 1))");
        tregex = TregexPattern.compile("/foo/=foo < /cur.*/=bar");
        tsurgeon = Tsurgeon.parseOperation("relabel foo /foo/={bar}/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(foofoo (curlew 0) (avocet 1))", "(curlewcurlew (curlew 0) (avocet 1))");
        tregex = TregexPattern.compile("/^foo(.*)$/=foo");
        tsurgeon = Tsurgeon.parseOperation("relabel foo /foo(.*)$/bar$1/");
        TsurgeonTest.runTest(tregex, tsurgeon, "(foofoo (curlew 0) (avocet 1))", "(barfoo (curlew 0) (avocet 1))");
    }

    public void testReplaceNode() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("replace foo blah");
        TregexPattern tregex = TregexPattern.compile("B=foo : C=blah");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (C 1))", "(A (C 1) (C 1))");
        tsurgeon = Tsurgeon.parseOperation("replace dest src");
        tregex = TregexPattern.compile("(/-([0-9]+)$/#1%i=src > /^FILLER$/) : (/^-NONE-/=dest <: /-([0-9]+)$/#1%i)");
        TsurgeonTest.runTest(tregex, tsurgeon, "( (S (FILLER (NP-SBJ-1 (NNP Koito))) (VP (VBZ has) (VP (VBN refused) (S (NP-SBJ (-NONE- *-1)) (VP (TO to) (VP (VB grant) (NP (NNP Mr.) (NNP Pickens)) (NP (NP (NNS seats)) (PP-LOC (IN on) (NP (PRP$ its) (NN board))))))) (, ,) (S-ADV (NP-SBJ (-NONE- *-1)) (VP (VBG asserting) (SBAR (-NONE- 0) (S (NP-SBJ (PRP he)) (VP (VBZ is) (NP-PRD (NP (DT a) (NN greenmailer)) (VP (VBG trying) (S (NP-SBJ (-NONE- *)) (VP (TO to) (VP (VB pressure) (NP (NP (NNP Koito) (POS 's)) (JJ other) (NNS shareholders)) (PP-CLR (IN into) (S-NOM (NP-SBJ (-NONE- *)) (VP (VBG buying) (NP (PRP him)) (PRT (RP out)) (PP-MNR (IN at) (NP (DT a) (NN profit)))))))))))))))))) (. .)))", "( (S (FILLER (NP-SBJ-1 (NNP Koito))) (VP (VBZ has) (VP (VBN refused) (S (NP-SBJ (NP-SBJ-1 (NNP Koito))) (VP (TO to) (VP (VB grant) (NP (NNP Mr.) (NNP Pickens)) (NP (NP (NNS seats)) (PP-LOC (IN on) (NP (PRP$ its) (NN board))))))) (, ,) (S-ADV (NP-SBJ (NP-SBJ-1 (NNP Koito))) (VP (VBG asserting) (SBAR (-NONE- 0) (S (NP-SBJ (PRP he)) (VP (VBZ is) (NP-PRD (NP (DT a) (NN greenmailer)) (VP (VBG trying) (S (NP-SBJ (-NONE- *)) (VP (TO to) (VP (VB pressure) (NP (NP (NNP Koito) (POS 's)) (JJ other) (NNS shareholders)) (PP-CLR (IN into) (S-NOM (NP-SBJ (-NONE- *)) (VP (VBG buying) (NP (PRP him)) (PRT (RP out)) (PP-MNR (IN at) (NP (DT a) (NN profit)))))))))))))))))) (. .)))");
    }

    public void testReplaceTree() {
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("replace foo (BAR 1)");
        TregexPattern tregex = TregexPattern.compile("B=foo");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (B 1) (C 2))", "(A (BAR 1) (BAR 1) (C 2))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(B (C 1))", "(BAR 1)");
        tsurgeon = Tsurgeon.parseOperation("replace foo (BAR 1) (BAZ 2)");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (B 1) (C 2))", "(A (BAR 1) (BAZ 2) (BAR 1) (BAZ 2) (C 2))");
        try {
            TsurgeonTest.runTest(tregex, tsurgeon, "(B 0)", "(B 0)");
            throw new RuntimeException("Expected a failure");
        }
        catch (TsurgeonRuntimeException tsurgeonRuntimeException) {
            tsurgeon = Tsurgeon.parseOperation("replace foo (BAR blah)");
            tregex = TregexPattern.compile("B=foo");
            TsurgeonTest.runTest(tregex, tsurgeon, "(A (B 0) (B 1) (C 2))", "(A (BAR blah) (BAR blah) (C 2))");
            return;
        }
    }

    public void testChineseReplaceTree() {
        String input = "(IP (IP (PP (P \u50cf) (NP (NP (NR \u8d56\u65af) (PU \uff0c) (NR \u8d56\u65af)) (NP (PN \u672c\u8eab)))) (PU \u5979\uff5b) (NP (NN \uff42\uff52\uff45\uff41\uff54\uff48)) (PU \uff5d) (IJ \u5443) (VP (VV \u62c5\u4efb) (NP (NN \u56fd\u52a1\u537f)) (VP (ADVP (AD \u6bd4\u8f83)) (VP (VA \u665a))))))";
        String expected = "(IP (IP (PP (P \u50cf) (NP (NP (NR \u8d56\u65af) (PU \uff0c) (NR \u8d56\u65af)) (NP (PN \u672c\u8eab)))) (PN \u5979) (PU \uff5b) (NP (NN \uff42\uff52\uff45\uff41\uff54\uff48)) (PU \uff5d) (IJ \u5443) (VP (VV \u62c5\u4efb) (NP (NN \u56fd\u52a1\u537f)) (VP (ADVP (AD \u6bd4\u8f83)) (VP (VA \u665a))))))";
        TregexPattern tregex = TregexPattern.compile("PU=punc < \u5979\uff5b");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("replace punc (PN \u5979) (PU \uff5b)");
        TsurgeonTest.runTest(tregex, tsurgeon, input, expected);
    }

    public void testInsertDelete() {
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> surgery = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
        TregexPattern tregex = TregexPattern.compile("(/-([0-9]+)$/#1%i=src > /^FILLER$/) : (/^-NONE-/=dest <: /-([0-9]+)$/#1%i !$ ~src)");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("insert src $+ dest");
        surgery.add(new Pair<TregexPattern, TsurgeonPattern>(tregex, tsurgeon));
        tregex = TregexPattern.compile("(/-([0-9]+)$/#1%i=src > /^FILLER$/) : (/^-NONE-/=dest <: /-([0-9]+)$/#1%i)");
        tsurgeon = Tsurgeon.parseOperation("delete dest");
        surgery.add(new Pair<TregexPattern, TsurgeonPattern>(tregex, tsurgeon));
        TsurgeonTest.runTest(surgery, "( (S (FILLER (NP-SBJ-1 (NNP Koito))) (VP (VBZ has) (VP (VBN refused) (S (NP-SBJ (-NONE- *-1)) (VP (TO to) (VP (VB grant) (NP (NNP Mr.) (NNP Pickens)) (NP (NP (NNS seats)) (PP-LOC (IN on) (NP (PRP$ its) (NN board))))))) (, ,) (S-ADV (NP-SBJ (-NONE- *-1)) (VP (VBG asserting) (SBAR (-NONE- 0) (S (NP-SBJ (PRP he)) (VP (VBZ is) (NP-PRD (NP (DT a) (NN greenmailer)) (VP (VBG trying) (S (NP-SBJ (-NONE- *)) (VP (TO to) (VP (VB pressure) (NP (NP (NNP Koito) (POS 's)) (JJ other) (NNS shareholders)) (PP-CLR (IN into) (S-NOM (NP-SBJ (-NONE- *)) (VP (VBG buying) (NP (PRP him)) (PRT (RP out)) (PP-MNR (IN at) (NP (DT a) (NN profit)))))))))))))))))) (. .)))", "( (S (FILLER (NP-SBJ-1 (NNP Koito))) (VP (VBZ has) (VP (VBN refused) (S (NP-SBJ (NP-SBJ-1 (NNP Koito))) (VP (TO to) (VP (VB grant) (NP (NNP Mr.) (NNP Pickens)) (NP (NP (NNS seats)) (PP-LOC (IN on) (NP (PRP$ its) (NN board))))))) (, ,) (S-ADV (NP-SBJ (NP-SBJ-1 (NNP Koito))) (VP (VBG asserting) (SBAR (-NONE- 0) (S (NP-SBJ (PRP he)) (VP (VBZ is) (NP-PRD (NP (DT a) (NN greenmailer)) (VP (VBG trying) (S (NP-SBJ (-NONE- *)) (VP (TO to) (VP (VB pressure) (NP (NP (NNP Koito) (POS 's)) (JJ other) (NNS shareholders)) (PP-CLR (IN into) (S-NOM (NP-SBJ (-NONE- *)) (VP (VBG buying) (NP (PRP him)) (PRT (RP out)) (PP-MNR (IN at) (NP (DT a) (NN profit)))))))))))))))))) (. .)))");
    }

    public void testReplaceWithRepeats() {
        TregexPattern tregex = TregexPattern.compile("@NP < (/^,/=comma $+ CC)");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("replace comma (COMMA)");
        TsurgeonTest.runTest(tregex, tsurgeon, "(NP NP , NP , NP , CC NP)", "(NP NP , NP , NP COMMA CC NP)");
    }

    public void testCoindex() {
        TregexPattern tregex = TregexPattern.compile("A=foo << B=bar << C=baz");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("coindex foo bar baz");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B (C foo)))", "(A-1 (B-1 (C-1 foo)))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B foo) (C foo) (C bar))", "(A-1 (B-1 foo) (C-1 foo) (C bar))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B foo) (C-1 bar) (C baz))", "(A-2 (B-2 foo) (C-1 bar) (C-2 baz))");
    }

    public void testKeyword() {
        TregexPattern tregex = TregexPattern.compile("A=foo << B=bar << C=baz");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("relabel foo relabel");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B foo) (C foo) (C bar))", "(relabel (B foo) (C foo) (C bar))");
    }

    public void testMultiplePatterns() {
        TregexPattern tregex = TregexPattern.compile("A=foo < B=bar < C=baz");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("[relabel baz BAZ] [move baz >-1 bar]");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B foo) (C foo) (C bar))", "(A (B foo (BAZ foo) (BAZ bar)))");
        tsurgeon = Tsurgeon.parseOperation("[relabel baz /^.*$/={bar}={baz}FOO/] [move baz >-1 bar]");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B foo) (C foo) (C bar))", "(A (B foo (BCFOO foo) (BCFOO bar)))");
        tregex = TregexPattern.compile("A=foo < B=bar < C=baz < D=biff");
        tsurgeon = Tsurgeon.parseOperation("[relabel baz /^.*$/={bar}={baz}/] [relabel biff /^.*$/={bar}={biff}/]");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B foo) (C bar) (D baz))", "(A (B foo) (BC bar) (BD baz))");
    }

    public void testIfExists() {
        TregexPattern tregex = TregexPattern.compile("A=foo [ << B=bar | << C=baz ]");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("if exists bar relabel bar BAR");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B foo))", "(A (BAR foo))");
        tsurgeon = Tsurgeon.parseOperation("[if exists bar relabel bar BAR] [if exists baz relabel baz BAZ]");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B foo))", "(A (BAR foo))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (C foo))", "(A (BAZ foo))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B foo) (C foo))", "(A (BAR foo) (BAZ foo))");
        String tree = new String("(ROOT (INTJ (CC But) (S (NP (DT the) (NNP RTC)) (ADVP (RB also)) (VP (VBZ requires) (`` ``) (S (FRAG (VBG working) ('' '') (NP (NP (NN capital)) (S (VP (TO to) (VP (VB maintain) (SBAR (S (NP (NP (DT the) (JJ bad) (NNS assets)) (PP (IN of) (NP (NP (NNS thrifts)) (SBAR (WHNP (WDT that)) (S (VP (VBP are) (VBN sold) (, ,) (PP (IN until) (NP (DT the) (NNS assets))))))))) (VP (MD can) (VP (VB be) (VP (VBN sold) (ADVP (RB separately))))))))))))))) (S (VP (. .)))))");
        String expected = new String("(ROOT (INTJ (CC But) (S (NP (DT the) (NNP RTC)) (ADVP (RB also)) (VP (VBZ requires) (`` ``) (S (FRAG (VBG working) ('' '') (NP (NP (NN capital)) (S (VP (TO to) (VP (VB maintain) (SBAR (S (NP (NP (DT the) (JJ bad) (NNS assets)) (PP (IN of) (NP (NP (NNS thrifts)) (SBAR (WHNP (WDT that)) (S (VP (VBP are) (VBN sold) (, ,) (PP (IN until) (NP (DT the) (NNS assets))))))))) (VP (MD can) (VP (VB be) (VP (VBN sold) (ADVP (RB separately))))))))))))))) (. .)))");
        tregex = TregexPattern.compile("__ !> __ <- (__=top <- (__ <<- (/[.]|PU/=punc < /[.!?\u3002\uff01\uff1f]/ ?> (__=single <: =punc))))");
        tsurgeon = Tsurgeon.parseOperation("[move punc >-1 top] [if exists single prune single]");
        TsurgeonTest.runTest(tregex, tsurgeon, tree, expected);
    }

    public void testExcise() {
        TregexPattern tregex = TregexPattern.compile("__=repeat <: (~repeat < __)");
        TsurgeonPattern tsurgeon = Tsurgeon.parseOperation("excise repeat repeat");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B (B foo)))", "(A (B foo))");
        TsurgeonTest.runTest(tregex, tsurgeon, "(B (B foo))", "(B foo)");
        tregex = TregexPattern.compile("A=root");
        tsurgeon = Tsurgeon.parseOperation("excise root root");
        TsurgeonTest.runTest(tregex, tsurgeon, "(A (B bar) (C foo))", null);
    }

    public static void runTest(TregexPattern tregex, TsurgeonPattern tsurgeon, String input, String expected) {
        Tree result = Tsurgeon.processPattern(tregex, tsurgeon, TsurgeonTest.treeFromString(input));
        if (expected == null) {
            TsurgeonTest.assertEquals(null, (Object)result);
        } else {
            TsurgeonTest.assertEquals((String)expected, (String)result.toString());
        }
        Pair<TregexPattern, TsurgeonPattern> surgery = new Pair<TregexPattern, TsurgeonPattern>(tregex, tsurgeon);
        TsurgeonTest.runTest(Collections.singletonList(surgery), input, expected);
    }

    public static void runTest(List<Pair<TregexPattern, TsurgeonPattern>> surgery, String input, String expected) {
        Tree result = Tsurgeon.processPatternsOnTree(surgery, TsurgeonTest.treeFromString(input));
        if (expected == null) {
            TsurgeonTest.assertEquals(null, (Object)result);
        } else {
            TsurgeonTest.assertEquals((String)expected, (String)result.toString());
        }
    }

    public static void outputResults(TregexPattern tregex, TsurgeonPattern tsurgeon, String input, String expected) {
        TsurgeonTest.outputResults(tregex, tsurgeon, input);
    }

    public static void outputResults(TregexPattern tregex, TsurgeonPattern tsurgeon, String input) {
        System.out.println("Tsurgeon: " + tsurgeon);
        System.out.println("Tregex: " + tregex);
        TregexMatcher m = tregex.matcher(TsurgeonTest.treeFromString(input));
        if (m.find()) {
            System.err.println(" Matched");
        } else {
            System.err.println(" Did not match");
        }
        Tree result = Tsurgeon.processPattern(tregex, tsurgeon, TsurgeonTest.treeFromString(input));
        System.out.println(result);
    }
}

