/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalRelations;
import edu.stanford.nlp.trees.UniversalPOSMapper;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.ud.CoNLLUDocumentReader;
import edu.stanford.nlp.trees.ud.CoNLLUDocumentWriter;
import edu.stanford.nlp.trees.ud.CoNLLUUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UniversalDependenciesFeatureAnnotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(UniversalDependenciesFeatureAnnotator.class);
    private static final String FEATURE_MAP_FILE = "edu/stanford/nlp/models/ud/feature_map.txt";
    private HashMap<String, HashMap<String, String>> posFeatureMap;
    private HashMap<String, HashMap<String, String>> wordPosFeatureMap;
    private final Morphology morphology = new Morphology();
    private static final String ORDINAL_EXPRESSION = "^(first|second|third|fourth|fifth|sixth|seventh|eigth|ninth|tenth|([0-9,.]+(th|st|nd|rd)))$";
    private static final String MULTIPLICATIVE_EXPRESSION = "^(once|twice)$";
    private static String SELF_REGEX = "/^(?i:myself|yourself|himself|herself|itself|ourselves|yourselves|themselves)$/".replace("/", "");
    private static final TregexPattern IMPERATIVE_PATTERN = TregexPattern.compile("__ > VB >+(/^[^S]/) S-IMP");
    private static final String BE_REGEX = "/^(?i:am|is|are|r|be|being|'s|'re|'m|was|were|been|s|ai|m|art|ar|wase)$/".replace("/", "");

    public UniversalDependenciesFeatureAnnotator() throws IOException {
        this.loadFeatureMap();
    }

    private void loadFeatureMap() throws IOException {
        try (BufferedReader r = IOUtils.readerFromString(FEATURE_MAP_FILE);){
            String line;
            BufferedReader br = new BufferedReader(r);
            this.posFeatureMap = new HashMap();
            this.wordPosFeatureMap = new HashMap();
            while ((line = br.readLine()) != null) {
                String[] parts = line.split("\\s+");
                if (parts.length < 3) continue;
                if (parts[0].equals("*")) {
                    this.posFeatureMap.put(parts[1], CoNLLUUtils.parseFeatures(parts[2]));
                    continue;
                }
                this.wordPosFeatureMap.put(parts[0] + '_' + parts[1], CoNLLUUtils.parseFeatures(parts[2]));
            }
        }
    }

    private HashMap<String, String> getPOSFeatures(String word, String pos) {
        HashMap<String, String> features = new HashMap<String, String>();
        String wordPos = word.toLowerCase() + '_' + pos;
        if (this.wordPosFeatureMap.containsKey(wordPos)) {
            features.putAll((Map)this.wordPosFeatureMap.get(wordPos));
        } else if (this.posFeatureMap.containsKey(pos)) {
            features.putAll((Map)this.posFeatureMap.get(pos));
        }
        if (UniversalDependenciesFeatureAnnotator.isOrdinal(word, pos)) {
            features.put("NumType", "Ord");
        }
        if (UniversalDependenciesFeatureAnnotator.isMultiplicative(word, pos)) {
            features.put("NumType", "Mult");
        }
        return features;
    }

    private static boolean isOrdinal(String word, String pos) {
        if (!pos.equals("JJ")) {
            return false;
        }
        return word.toLowerCase().matches(ORDINAL_EXPRESSION);
    }

    private static boolean isMultiplicative(String word, String pos) {
        if (!pos.equals("RB")) {
            return false;
        }
        return word.toLowerCase().matches(MULTIPLICATIVE_EXPRESSION);
    }

    private static HashMap<String, String> getGraphFeatures(SemanticGraph sg, IndexedWord word) {
        SemanticGraphEdge edge;
        IndexedWord parent;
        String person;
        HashMap<String, String> features = new HashMap<String, String>();
        if (word.tag().equals("PRP") && (word.value().equalsIgnoreCase("you") || word.value().equalsIgnoreCase("it"))) {
            features.put("Case", UniversalDependenciesFeatureAnnotator.pronounCase(sg, word));
        }
        if (word.tag().equals("VBD") && word.value().equalsIgnoreCase("was") && (person = UniversalDependenciesFeatureAnnotator.wasPerson(sg, word)) != null) {
            features.put("Person", person);
        }
        features.putAll(UniversalDependenciesFeatureAnnotator.getRelAndIntPronFeatures(sg, word));
        if (word.tag().equals("VBG")) {
            if (UniversalDependenciesFeatureAnnotator.hasBeAux(sg, word)) {
                features.put("VerbForm", "Part");
                features.put("Tense", "Pres");
            } else {
                features.put("VerbForm", "Ger");
            }
        }
        if (word.value().matches(SELF_REGEX) && word.tag().equals("PRP") && (parent = sg.getParent(word)) != null && (edge = sg.getEdge(parent, word)).getRelation() != UniversalEnglishGrammaticalRelations.NP_ADVERBIAL_MODIFIER) {
            features.put("Case", "Acc");
            features.put("Reflex", "Yes");
        }
        if (word.tag().equals("VBN") && sg.hasChildWithReln(word, UniversalEnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER)) {
            features.put("Voice", "Pass");
        }
        return features;
    }

    private static String pronounCase(SemanticGraph sg, IndexedWord word) {
        SemanticGraphEdge edge;
        IndexedWord parent = sg.getParent(word = sg.getNodeByIndex(word.index()));
        if (parent != null && (edge = sg.getEdge(parent, word)) != null) {
            if (UniversalEnglishGrammaticalRelations.OBJECT.isAncestor(edge.getRelation())) {
                return "Acc";
            }
            if ((UniversalEnglishGrammaticalRelations.NOMINAL_MODIFIER.isAncestor(edge.getRelation()) || edge.getRelation() == GrammaticalRelation.ROOT) && sg.hasChildWithReln(word, UniversalEnglishGrammaticalRelations.CASE_MARKER)) {
                return "Acc";
            }
        }
        return "Nom";
    }

    private static String wasPerson(SemanticGraph sg, IndexedWord word) {
        IndexedWord subj = sg.getChildWithReln(word, UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT);
        if (subj == null) {
            subj = sg.getChildWithReln(word, UniversalEnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT);
        }
        if (subj != null && subj.word().equalsIgnoreCase("i")) {
            return "1";
        }
        IndexedWord parent = sg.getParent(word);
        if (parent == null) {
            return subj != null ? "3" : null;
        }
        SemanticGraphEdge edge = sg.getEdge(parent, word);
        if (edge == null) {
            return subj != null ? "3" : null;
        }
        if (UniversalEnglishGrammaticalRelations.AUX_MODIFIER.equals(edge.getRelation()) || UniversalEnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER.equals(edge.getRelation())) {
            return UniversalDependenciesFeatureAnnotator.wasPerson(sg, parent);
        }
        if (UniversalEnglishGrammaticalRelations.CONJUNCT.isAncestor(edge.getRelation())) {
            return UniversalDependenciesFeatureAnnotator.wasPerson(sg, parent);
        }
        return "3";
    }

    private static HashMap<String, String> getRelAndIntPronFeatures(SemanticGraph sg, IndexedWord word) {
        HashMap<String, String> features = new HashMap<String, String>();
        if (word.tag().startsWith("W")) {
            IndexedWord parentParent;
            boolean isRel = false;
            IndexedWord parent = sg.getParent(word);
            if (parent != null && (parentParent = sg.getParent(parent)) != null) {
                SemanticGraphEdge edge = sg.getEdge(parentParent, parent);
                isRel = edge.getRelation().equals(UniversalEnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER);
            }
            if (isRel) {
                features.put("PronType", "Rel");
            } else if (word.value().equalsIgnoreCase("that")) {
                features.put("PronType", "Dem");
            } else {
                features.put("PronType", "Int");
            }
        }
        return features;
    }

    private static Iterator<Tree> treebankIterator(String path) {
        MemoryTreebank tb = new MemoryTreebank(new NPTmpRetainingTreeNormalizer(0, false, 1, false));
        tb.loadPath(path);
        return ((AbstractCollection)tb).iterator();
    }

    private static Set<Integer> getImperatives(Tree t) {
        HashSet<Integer> imps = new HashSet<Integer>();
        TregexMatcher matcher = IMPERATIVE_PATTERN.matcher(t);
        while (matcher.find()) {
            ArrayList<Label> verbs = matcher.getMatch().yield();
            CoreLabel cl = (CoreLabel)verbs.get(0);
            imps.add(cl.index());
        }
        return imps;
    }

    private static boolean hasAux(SemanticGraph sg, IndexedWord word) {
        SemanticGraphEdge edge;
        if (sg.hasChildWithReln(word, UniversalEnglishGrammaticalRelations.AUX_MODIFIER)) {
            return true;
        }
        IndexedWord gov = sg.getParent(word);
        if (gov != null && (UniversalEnglishGrammaticalRelations.CONJUNCT.isAncestor((edge = sg.getEdge(gov, word)).getRelation()) || UniversalEnglishGrammaticalRelations.COPULA.equals(edge.getRelation()))) {
            return UniversalDependenciesFeatureAnnotator.hasAux(sg, gov);
        }
        return false;
    }

    private static boolean hasTo(SemanticGraph sg, IndexedWord word) {
        if (sg.hasChildWithReln(word, UniversalEnglishGrammaticalRelations.MARKER)) {
            for (IndexedWord marker : sg.getChildrenWithReln(word, UniversalEnglishGrammaticalRelations.MARKER)) {
                if (!marker.value().equalsIgnoreCase("to")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasBeAux(SemanticGraph sg, IndexedWord word) {
        SemanticGraphEdge edge;
        for (IndexedWord aux : sg.getChildrenWithReln(word, UniversalEnglishGrammaticalRelations.AUX_MODIFIER)) {
            if (!aux.value().matches(BE_REGEX)) continue;
            return true;
        }
        IndexedWord gov = sg.getParent(word);
        if (gov != null && UniversalEnglishGrammaticalRelations.CONJUNCT.isAncestor((edge = sg.getEdge(gov, word)).getRelation())) {
            return UniversalDependenciesFeatureAnnotator.hasBeAux(sg, gov);
        }
        return false;
    }

    public void addFeatures(SemanticGraph sg, Tree t, boolean addLemma, boolean addUPOS) {
        HashSet imperatives = t != null ? UniversalDependenciesFeatureAnnotator.getImperatives(t) : new HashSet();
        for (IndexedWord word : sg.vertexListSorted()) {
            String posTag = (String)word.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            String token = (String)word.get(CoreAnnotations.TextAnnotation.class);
            Integer index = (Integer)word.get(CoreAnnotations.IndexAnnotation.class);
            HashMap<String, String> wordFeatures = (HashMap<String, String>)word.get(CoreAnnotations.CoNLLUFeats.class);
            if (wordFeatures == null) {
                wordFeatures = new HashMap<String, String>();
                word.set(CoreAnnotations.CoNLLUFeats.class, wordFeatures);
            }
            wordFeatures.putAll(this.getPOSFeatures(token, posTag));
            wordFeatures.putAll(UniversalDependenciesFeatureAnnotator.getGraphFeatures(sg, word));
            if (imperatives.contains(index)) {
                wordFeatures.put("VerbForm", "Fin");
                wordFeatures.put("Mood", "Imp");
            } else if (posTag.equals("VB")) {
                wordFeatures.put("VerbForm", "Inf");
            }
            String lemma = (String)word.get(CoreAnnotations.LemmaAnnotation.class);
            if (!addLemma || lemma != null && !lemma.equals("_")) continue;
            word.set(CoreAnnotations.LemmaAnnotation.class, this.morphology.lemma(token, posTag));
        }
        if (addUPOS && t != null) {
            t = UniversalPOSMapper.mapTree(t);
            List<Label> uPOSTags = t.preTerminalYield();
            List<IndexedWord> yield = sg.vertexListSorted();
            for (IndexedWord word : yield) {
                Label uPOSTag = uPOSTags.get(word.index() - 1);
                word.set(CoreAnnotations.CoarseTagAnnotation.class, uPOSTag.value());
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            log.info("Usage: ");
            log.info("java ");
            log.info(UniversalDependenciesFeatureAnnotator.class.getCanonicalName());
            log.info(" CoNLL-U_file tree_file [-addUPOS -escapeParenthesis]");
            return;
        }
        String coNLLUFile = args[0];
        String treeFile = args[1];
        boolean addUPOS = false;
        boolean escapeParens = false;
        for (int i = 2; i < args.length; ++i) {
            if (args[i].equals("-addUPOS")) {
                addUPOS = true;
                continue;
            }
            if (!args[i].equals("-escapeParenthesis")) continue;
            escapeParens = true;
        }
        UniversalDependenciesFeatureAnnotator featureAnnotator = new UniversalDependenciesFeatureAnnotator();
        BufferedReader r = IOUtils.readerFromString(coNLLUFile);
        CoNLLUDocumentReader depReader = new CoNLLUDocumentReader();
        CoNLLUDocumentWriter depWriter = new CoNLLUDocumentWriter();
        Iterator<SemanticGraph> it = depReader.getIterator(r);
        Iterator<Tree> treeIt = UniversalDependenciesFeatureAnnotator.treebankIterator(treeFile);
        while (it.hasNext()) {
            SemanticGraph sg = it.next();
            Tree t = treeIt.next();
            if (t == null || t.yield().size() != sg.size()) {
                StringBuilder sentenceSb = new StringBuilder();
                for (IndexedWord word : sg.vertexListSorted()) {
                    sentenceSb.append((String)word.get(CoreAnnotations.TextAnnotation.class));
                    sentenceSb.append(' ');
                }
                throw new RuntimeException("CoNLL-U file and tree file are not aligned. \nSentence: " + sentenceSb + '\n' + "Tree: " + (t == null ? "null" : t.pennString()));
            }
            featureAnnotator.addFeatures(sg, t, true, addUPOS);
            System.out.print(depWriter.printSemanticGraph(sg, !escapeParens));
        }
    }
}

