/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Lazy;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class LazyTest {
    @Test
    public void testFrom() {
        Lazy<String> x = Lazy.from("foo");
        Assert.assertEquals((Object)"foo", (Object)x.getIfDefined());
        Assert.assertEquals((Object)"foo", (Object)x.get());
    }

    @Test
    public void testOf() {
        Lazy<String> x = Lazy.of(() -> "foo");
        Assert.assertEquals(null, (Object)x.getIfDefined());
        Assert.assertEquals((Object)"foo", (Object)x.get());
    }

    @Test
    public void testCached() {
        Lazy<String> x = Lazy.cache(() -> "foo");
        Assert.assertEquals(null, (Object)x.getIfDefined());
        Assert.assertEquals((Object)"foo", (Object)x.get());
    }

    @Test
    public void testOfCalledOnlyOnce() {
        AtomicInteger callCount = new AtomicInteger(0);
        Lazy<String> x = Lazy.of(() -> {
            callCount.incrementAndGet();
            return "foo";
        });
        Assert.assertEquals(null, (Object)x.getIfDefined());
        Assert.assertEquals((Object)"foo", (Object)x.get());
        x.simulateGC();
        Assert.assertEquals((Object)"foo", (Object)x.get());
        Assert.assertEquals((long)1L, (long)callCount.get());
    }

    @Test
    public void testCachedCalledOnlyOnce() {
        AtomicInteger callCount = new AtomicInteger(0);
        Lazy<String> x = Lazy.cache(() -> {
            callCount.incrementAndGet();
            return "foo";
        });
        Assert.assertEquals(null, (Object)x.getIfDefined());
        Assert.assertEquals((Object)"foo", (Object)x.get());
        Assert.assertEquals((Object)"foo", (Object)x.get());
        Assert.assertEquals((long)1L, (long)callCount.get());
    }

    @Test
    public void testCachedGC() {
        AtomicInteger callCount = new AtomicInteger(0);
        Lazy<String> x = Lazy.cache(() -> {
            callCount.incrementAndGet();
            return "foo";
        });
        Assert.assertEquals(null, (Object)x.getIfDefined());
        Assert.assertEquals((Object)"foo", (Object)x.get());
        x.simulateGC();
        Assert.assertEquals((Object)"foo", (Object)x.get());
        Assert.assertEquals((long)2L, (long)callCount.get());
    }
}

