/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.util.concurrent.SynchronizedInterner;
import junit.framework.TestCase;

public class SynchronizedInternerTest
extends TestCase {
    private final Object[] objects = new Object[]{"salamander", "kitten", new String[]{"fred", "george", "sam"}, 5, Float.valueOf(5.0f)};
    private final Thread[] threads = new Thread[100];

    public void testGlobal() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (Object object : SynchronizedInternerTest.this.objects) {
                        Object interned = SynchronizedInterner.globalIntern(object);
                        Thread.yield();
                        if (interned != object) {
                            throw new AssertionError((Object)("Interning failed for " + object));
                        }
                    }
                }
            });
        }
        for (Thread thread : this.threads) {
            thread.start();
        }
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

