/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateGenerator
extends Generator<Date> {
    private Date min = new Date(Integer.MIN_VALUE);
    private Date max = new Date(Long.MAX_VALUE);

    public DateGenerator() {
        super(Date.class);
    }

    public void configure(InRange range) {
        SimpleDateFormat formatter = new SimpleDateFormat(range.format());
        formatter.setLenient(false);
        try {
            if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
                this.min = formatter.parse(range.min());
            }
            if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
                this.max = formatter.parse(range.max());
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        if (this.min.getTime() > this.max.getTime()) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", range.min(), range.max()));
        }
    }

    public Date generate(SourceOfRandomness random, GenerationStatus status) {
        return new Date(random.nextLong(this.min.getTime(), this.max.getTime()));
    }
}

