/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol;

import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.linsol.chol.BlockCholeskyOuterSolver;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.LinearSolver;

public class WrapLinearSolverBlock64
implements LinearSolver<DenseMatrix64F> {
    protected LinearSolver<BlockMatrix64F> alg = new BlockCholeskyOuterSolver();
    protected BlockMatrix64F blockA = new BlockMatrix64F(1, 1);
    protected BlockMatrix64F blockB = new BlockMatrix64F(1, 1);
    protected BlockMatrix64F blockX = new BlockMatrix64F(1, 1);

    public WrapLinearSolverBlock64(LinearSolver<BlockMatrix64F> linearSolver) {
        this.alg = linearSolver;
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        this.blockA.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols, false);
        BlockMatrixOps.convert(denseMatrix64F, this.blockA);
        return this.alg.setA(this.blockA);
    }

    @Override
    public double quality() {
        return this.alg.quality();
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        this.blockB.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols, false);
        this.blockX.reshape(denseMatrix64F2.numRows, denseMatrix64F2.numCols, false);
        BlockMatrixOps.convert(denseMatrix64F, this.blockB);
        this.alg.solve(this.blockB, this.blockX);
        BlockMatrixOps.convert(this.blockX, denseMatrix64F2);
    }

    @Override
    public void invert(DenseMatrix64F denseMatrix64F) {
        this.blockB.reshape(denseMatrix64F.numRows, denseMatrix64F.numCols, false);
        this.alg.invert(this.blockB);
        BlockMatrixOps.convert(this.blockB, denseMatrix64F);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }
}

