/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.demo;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionExtractor;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class TokensRegexDemo {
    private TokensRegexDemo() {
    }

    public static void main(String[] args) throws IOException {
        String rules = args.length > 0 ? args[0] : "edu/stanford/nlp/ling/tokensregex/demo/rules/expr.rules.txt";
        PrintWriter out2 = args.length > 2 ? new PrintWriter(args[2]) : new PrintWriter(System.out);
        CoreMapExpressionExtractor extractor = CoreMapExpressionExtractor.createExtractorFromFiles(TokenSequencePattern.getNewEnv(), rules);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(PropertiesUtils.asProperties("annotators", "tokenize,ssplit,pos,lemma,ner"));
        Annotation annotation = args.length > 1 ? new Annotation(IOUtils.slurpFileNoExceptions(args[1])) : new Annotation("( ( five plus three plus four ) * 2 ) divided by three");
        pipeline.annotate(annotation);
        out2.println();
        out2.println("The top level annotation");
        out2.println(annotation.toShorterString(new String[0]));
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        int i = 0;
        for (CoreMap sentence : sentences) {
            out2.println("Sentence #" + ++i);
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                out2.println("  Token: word=" + (String)token.get(CoreAnnotations.TextAnnotation.class) + ",  pos=" + (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class) + ", ne=" + (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class));
            }
            List matchedExpressions = extractor.extractExpressions(sentence);
            for (MatchedExpression matched : matchedExpressions) {
                out2.println("Matched expression: " + matched.getText() + " with value " + matched.getValue());
                CoreMap cm = matched.getAnnotation();
                for (CoreLabel token : (List)cm.get(CoreAnnotations.TokensAnnotation.class)) {
                    String word = (String)token.get(CoreAnnotations.TextAnnotation.class);
                    String lemma = (String)token.get(CoreAnnotations.LemmaAnnotation.class);
                    String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    String ne = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                    out2.println("  Matched token: word=" + word + ", lemma=" + lemma + ", pos=" + pos + ", ne=" + ne);
                }
            }
        }
        out2.flush();
    }
}

