/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.model;

import com.pholser.junit.quickcheck.ForAll;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import edu.stanford.nlp.loglinear.model.NDArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.contrib.theories.Theories;
import org.junit.contrib.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class NDArrayTest {
    @Theory
    public void testAssignmentsIterator(@ForAll(sampleSize=50) @From(value={NDArrayGenerator.class}) NDArrayWithGold<Double> testPair) throws Exception {
        HashSet assignmentSet = new HashSet();
        for (int[] assignment : testPair.gold.keySet()) {
            assignmentSet.add(Arrays.stream(assignment).boxed().collect(Collectors.toList()));
        }
        for (int[] assignment : testPair.array) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (int i : assignment) {
                l.add(i);
            }
            Assert.assertTrue((boolean)assignmentSet.contains(l));
            assignmentSet.remove(l);
        }
        Assert.assertTrue((boolean)assignmentSet.isEmpty());
    }

    @Theory
    public void testReadWrite(@ForAll(sampleSize=50) @From(value={NDArrayGenerator.class}) NDArrayWithGold<Double> testPair) throws Exception {
        for (int[] assignment : testPair.gold.keySet()) {
            Assert.assertEquals((double)((Double)testPair.gold.get(assignment)), (double)((Double)testPair.array.getAssignmentValue(assignment)), (double)1.0E-5);
        }
    }

    @Theory
    public void testClone(@ForAll(sampleSize=50) @From(value={NDArrayGenerator.class}) NDArrayWithGold<Double> testPair) throws Exception {
        NDArray clone = testPair.array.cloneArray();
        for (int[] assignment : testPair.gold.keySet()) {
            Assert.assertEquals((double)((Double)testPair.gold.get(assignment)), (double)((Double)clone.getAssignmentValue(assignment)), (double)1.0E-5);
        }
    }

    public static class NDArrayGenerator
    extends Generator<NDArrayWithGold<Double>> {
        public NDArrayGenerator(Class<NDArrayWithGold<Double>> type) {
            super(type);
        }

        public NDArrayWithGold<Double> generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            NDArrayWithGold<Double> testPair = new NDArrayWithGold<Double>();
            int numDimensions = sourceOfRandomness.nextInt(1, 5);
            int[] dimensions = new int[numDimensions];
            for (int i = 0; i < dimensions.length; ++i) {
                dimensions[i] = sourceOfRandomness.nextInt(1, 4);
            }
            testPair.array = new NDArray(dimensions);
            NDArrayGenerator.recursivelyFillArray(new ArrayList<Integer>(), testPair, sourceOfRandomness);
            return testPair;
        }

        private static void recursivelyFillArray(List<Integer> assignmentSoFar, NDArrayWithGold<Double> testPair, SourceOfRandomness sourceOfRandomness) {
            if (assignmentSoFar.size() == testPair.array.getDimensions().length) {
                int[] arr = new int[assignmentSoFar.size()];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = assignmentSoFar.get(i);
                }
                double value = sourceOfRandomness.nextDouble();
                testPair.array.setAssignmentValue(arr, value);
                testPair.gold.put(arr, value);
            } else {
                for (int i = 0; i < testPair.array.getDimensions()[assignmentSoFar.size()]; ++i) {
                    ArrayList<Integer> newList = new ArrayList<Integer>();
                    newList.addAll(assignmentSoFar);
                    newList.add(i);
                    NDArrayGenerator.recursivelyFillArray(newList, testPair, sourceOfRandomness);
                }
            }
        }
    }

    public static class NDArrayWithGold<T> {
        public NDArray<T> array;
        public Map<int[], T> gold = new HashMap<int[], T>();
    }
}

