/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.DiffFunctionTest;
import edu.stanford.nlp.optimization.QNMinimizer;
import java.util.Arrays;
import junit.framework.TestCase;

public class MinimizerTest
extends TestCase {
    public void testRosenbrock() {
        RosenbrockFunction rf = new RosenbrockFunction();
        DiffFunctionTest.gradientCheck(rf);
    }

    public void testQNMinimizerRosenbrock() {
        double[] initial = new double[]{0.0, 0.0};
        RosenbrockFunction rf = new RosenbrockFunction();
        QNMinimizer qn = new QNMinimizer();
        double[] answer = qn.minimize(rf, 1.0E-10, initial);
        System.err.println("Answer is: " + Arrays.toString(answer));
        MinimizerTest.assertEquals((double)1.0, (double)answer[0], (double)1.0E-8);
        MinimizerTest.assertEquals((double)1.0, (double)answer[1], (double)1.0E-8);
    }

    private static class RosenbrockFunction
    implements DiffFunction {
        private RosenbrockFunction() {
        }

        @Override
        public double[] derivativeAt(double[] x) {
            double[] derivatives = new double[]{-400.0 * x[0] * (x[1] - x[0] * x[0]) - 2.0 * (1.0 - x[0]), 200.0 * (x[1] - x[0] * x[0])};
            return derivatives;
        }

        @Override
        public double valueAt(double[] x) {
            double t1 = 1.0 - x[0];
            double t2 = x[1] - x[0] * x[0];
            return t1 * t1 + 100.0 * t2 * t2;
        }

        @Override
        public int domainDimension() {
            return 2;
        }
    }
}

