/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.dvparser;

import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.TwoDimensionalSet;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class FilterConfusingRules
implements Predicate<Tree>,
Serializable {
    private static Redwood.RedwoodChannels log = Redwood.channels(FilterConfusingRules.class);
    final Set<String> unaryRules = new HashSet<String>();
    final TwoDimensionalSet<String, String> binaryRules = new TwoDimensionalSet();
    static final boolean DEBUG = false;

    public FilterConfusingRules(LexicalizedParser parser) {
        BinaryGrammar binaryGrammar = parser.bg;
        UnaryGrammar unaryGrammar = parser.ug;
        Options op = parser.getOp();
        Index<String> stateIndex = parser.stateIndex;
        for (UnaryRule unaryRule : unaryGrammar) {
            String childState = stateIndex.get(unaryRule.child);
            String childBasic = op.langpack().basicCategory(childState);
            this.unaryRules.add(childBasic);
        }
        for (BinaryRule binaryRule : binaryGrammar) {
            String leftState = stateIndex.get(binaryRule.leftChild);
            String leftBasic = op.langpack().basicCategory(leftState);
            String rightState = stateIndex.get(binaryRule.rightChild);
            String rightBasic = op.langpack().basicCategory(rightState);
            this.binaryRules.add(leftBasic, rightBasic);
        }
    }

    @Override
    public boolean test(Tree tree) {
        if (tree.isLeaf() || tree.isPreTerminal()) {
            return true;
        }
        if (tree.children().length == 0 || tree.children().length > 2) {
            throw new AssertionError((Object)"Tree not binarized");
        }
        if (tree.children().length == 1 ? !this.unaryRules.contains(tree.children()[0].label().value()) : !this.binaryRules.contains(tree.children()[0].label().value(), tree.children()[1].label().value())) {
            return false;
        }
        for (Tree child : tree.children()) {
            if (this.test(child)) continue;
            return false;
        }
        return true;
    }
}

