/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.PatternsAnnotations;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ApplyPatterns<E extends Pattern>
implements Callable<Triple<TwoDimensionalCounter<CandidatePhrase, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>, Set<CandidatePhrase>>> {
    private static final Redwood.RedwoodChannels logger = Redwood.channels(ApplyPatterns.class);
    private final String label;
    private final Map<TokenSequencePattern, E> patterns;
    private final List<String> sentids;
    private final boolean removeStopWordsFromSelectedPhrases;
    private final boolean removePhrasesWithStopWords;
    private final ConstantsAndVariables constVars;
    private final Map<String, DataInstance> sents;

    public ApplyPatterns(Map<String, DataInstance> sents, List<String> sentids, Map<TokenSequencePattern, E> patterns, String label, boolean removeStopWordsFromSelectedPhrases, boolean removePhrasesWithStopWords, ConstantsAndVariables cv) {
        this.sents = sents;
        this.patterns = patterns;
        this.sentids = sentids;
        this.label = label;
        this.removeStopWordsFromSelectedPhrases = removeStopWordsFromSelectedPhrases;
        this.removePhrasesWithStopWords = removePhrasesWithStopWords;
        this.constVars = cv;
    }

    @Override
    public Triple<TwoDimensionalCounter<CandidatePhrase, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>, Set<CandidatePhrase>> call() throws Exception {
        try {
            HashSet<CandidatePhrase> alreadyLabeledPhrases = new HashSet<CandidatePhrase>();
            TwoDimensionalCounter<CandidatePhrase, E> allFreq = new TwoDimensionalCounter<CandidatePhrase, E>();
            CollectionValuedMap<E, Triple<String, Integer, Integer>> matchedTokensByPat = new CollectionValuedMap<E, Triple<String, Integer, Integer>>();
            for (String sentid : this.sentids) {
                List<CoreLabel> sent = this.sents.get(sentid).getTokens();
                for (Map.Entry<TokenSequencePattern, E> pEn : this.patterns.entrySet()) {
                    if (pEn.getKey() == null) {
                        throw new RuntimeException("why is the pattern " + pEn + " null?");
                    }
                    SequenceMatcher m = pEn.getKey().getMatcher(sent);
                    m.setBranchLimit(5);
                    while (m.find()) {
                        int i;
                        int s = m.start("$term");
                        int e = m.end("$term");
                        assert (e - s <= PatternFactory.numWordsCompoundMapped.get(this.label)) : "How come the pattern " + pEn.getKey() + " is extracting phrases longer than numWordsCompound of " + PatternFactory.numWordsCompoundMapped.get(this.label) + " for label " + this.label;
                        String phrase = "";
                        String phraseLemma = "";
                        boolean useWordNotLabeled = false;
                        boolean doNotUse = false;
                        if (this.constVars.clubNeighboringLabeledWords) {
                            int i2;
                            for (i2 = s - 1; i2 >= 0; --i2) {
                                if (((String)sent.get(i2).get(this.constVars.getAnswerClass().get(this.label))).equals(this.label)) continue;
                                s = i2 + 1;
                                break;
                            }
                            for (i2 = e; i2 < sent.size(); ++i2) {
                                if (((String)sent.get(i2).get(this.constVars.getAnswerClass().get(this.label))).equals(this.label)) continue;
                                e = i2;
                                break;
                            }
                        }
                        boolean[] addedindices = new boolean[e - s];
                        for (i = s; i < e; ++i) {
                            CoreLabel l = sent.get(i);
                            l.set(PatternsAnnotations.MatchedPattern.class, true);
                            if (!l.containsKey(PatternsAnnotations.MatchedPatterns.class) || l.get(PatternsAnnotations.MatchedPatterns.class) == null) {
                                l.set(PatternsAnnotations.MatchedPatterns.class, new HashSet());
                            }
                            SurfacePattern pSur = (SurfacePattern)pEn.getValue();
                            assert (pSur != null) : "Why is " + pEn.getValue() + " not present in the index?!";
                            assert (l.get(PatternsAnnotations.MatchedPatterns.class) != null) : "How come MatchedPatterns class is null for the token. The classes in the key set are " + l.keySet();
                            ((Set)l.get(PatternsAnnotations.MatchedPatterns.class)).add(pSur);
                            for (Map.Entry<Class, Object> ig : this.constVars.getIgnoreWordswithClassesDuringSelection().get(this.label).entrySet()) {
                                if (!l.containsKey(ig.getKey()) || !l.get(ig.getKey()).equals(ig.getValue())) continue;
                                doNotUse = true;
                            }
                            boolean containsStop = ApplyPatterns.containsStopWord(l, this.constVars.getCommonEngWords(), PatternFactory.ignoreWordRegex);
                            if (this.removePhrasesWithStopWords && containsStop) {
                                doNotUse = true;
                                continue;
                            }
                            if (containsStop && this.removeStopWordsFromSelectedPhrases) continue;
                            if (this.label == null || l.get(this.constVars.getAnswerClass().get(this.label)) == null || !((String)l.get(this.constVars.getAnswerClass().get(this.label))).equals(this.label)) {
                                useWordNotLabeled = true;
                            }
                            phrase = phrase + " " + l.word();
                            phraseLemma = phraseLemma + " " + l.lemma();
                            addedindices[i - s] = true;
                        }
                        for (i = 0; i < addedindices.length; ++i) {
                            if (i <= 0 || i >= addedindices.length - 1 || !addedindices[i - 1] || addedindices[i] || !addedindices[i + 1]) continue;
                            doNotUse = true;
                            break;
                        }
                        if (doNotUse) continue;
                        matchedTokensByPat.add(pEn.getValue(), new Triple<String, Integer, Integer>(sentid, s, e - 1));
                        if ((phrase = phrase.trim()).isEmpty()) continue;
                        phraseLemma = phraseLemma.trim();
                        CandidatePhrase candPhrase = CandidatePhrase.createOrGet(phrase, phraseLemma);
                        allFreq.incrementCount(candPhrase, pEn.getValue(), 1.0);
                        if (useWordNotLabeled) continue;
                        alreadyLabeledPhrases.add(candPhrase);
                    }
                }
            }
            return new Triple<TwoDimensionalCounter<CandidatePhrase, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>, Set<CandidatePhrase>>(allFreq, matchedTokensByPat, alreadyLabeledPhrases);
        }
        catch (Exception e) {
            logger.error(e);
            throw e;
        }
    }

    private static boolean lemmaExists(CoreLabel l) {
        return l.lemma() != null && !l.lemma().isEmpty();
    }

    private static boolean containsStopWord(CoreLabel l, Set<String> commonEngWords, java.util.regex.Pattern ignoreWordRegex) {
        return commonEngWords != null && (ApplyPatterns.lemmaExists(l) && commonEngWords.contains(l.lemma()) || commonEngWords.contains(l.word())) || ignoreWordRegex != null && (ApplyPatterns.lemmaExists(l) && ignoreWordRegex.matcher(l.lemma()).matches() || ignoreWordRegex.matcher(l.word()).matches());
    }
}

