/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.CorefCoreAnnotations;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.CorefMentionAnnotator;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DeterministicCorefAnnotator
implements Annotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(DeterministicCorefAnnotator.class);
    private static final boolean VERBOSE = false;
    private final MentionExtractor mentionExtractor;
    private final SieveCoreferenceSystem corefSystem;
    private boolean performMentionDetection;
    private CorefMentionAnnotator mentionAnnotator;
    private final boolean OLD_FORMAT;
    private final boolean allowReparsing;

    public DeterministicCorefAnnotator(Properties props) {
        try {
            this.corefSystem = new SieveCoreferenceSystem(props);
            this.mentionExtractor = new MentionExtractor(this.corefSystem.dictionaries(), this.corefSystem.semantics());
            this.OLD_FORMAT = Boolean.parseBoolean(props.getProperty("oldCorefFormat", "false"));
            this.allowReparsing = PropertiesUtils.getBool(props, "dcoref.allowReparsing", true);
            boolean bl = this.performMentionDetection = !PropertiesUtils.getBool(props, "dcoref.useCustomMentionDetection", false);
            if (this.performMentionDetection) {
                this.mentionAnnotator = new CorefMentionAnnotator(props);
            }
        }
        catch (Exception e) {
            log.error("cannot create DeterministicCorefAnnotator!");
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    public void setNamedEntityTagGranularity(Annotation annotation, String granularity) {
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        Class sourceNERTagClass = granularity.equals("fine") ? CoreAnnotations.FineGrainedNamedEntityTagAnnotation.class : (granularity.equals("coarse") ? CoreAnnotations.CoarseNamedEntityTagAnnotation.class : CoreAnnotations.NamedEntityTagAnnotation.class);
        for (CoreLabel token : tokens) {
            if (((String)token.get(sourceNERTagClass)).equals("") || token.get(sourceNERTagClass) == null) continue;
            token.set(CoreAnnotations.NamedEntityTagAnnotation.class, token.get(sourceNERTagClass));
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        this.setNamedEntityTagGranularity(annotation, "coarse");
        if (this.performMentionDetection) {
            this.mentionAnnotator.annotate(annotation);
        }
        try {
            ArrayList<Tree> trees = new ArrayList<Tree>();
            ArrayList<List<CoreLabel>> sentences = new ArrayList<List<CoreLabel>>();
            boolean hasSpeakerAnnotations = false;
            if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                    sentences.add(tokens);
                    Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                    trees.add(tree);
                    SemanticGraph dependencies = SemanticGraphFactory.makeFromTree(tree, SemanticGraphFactory.Mode.COLLAPSED, GrammaticalStructure.Extras.NONE, null, true);
                    sentence.set(SemanticGraphCoreAnnotations.AlternativeDependenciesAnnotation.class, dependencies);
                    if (!hasSpeakerAnnotations) {
                        for (CoreLabel t : tokens) {
                            if (t.get(CoreAnnotations.SpeakerAnnotation.class) == null) continue;
                            hasSpeakerAnnotations = true;
                            break;
                        }
                    }
                    MentionExtractor.mergeLabels(tree, tokens);
                    MentionExtractor.initializeUtterance(tokens);
                }
            } else {
                log.error("this coreference resolution system requires SentencesAnnotation!");
                return;
            }
            if (hasSpeakerAnnotations) {
                annotation.set(CoreAnnotations.UseMarkedDiscourseAnnotation.class, true);
            }
            RuleBasedCorefMentionFinder finder = new RuleBasedCorefMentionFinder(this.allowReparsing);
            List<List<Mention>> allUnprocessedMentions = finder.extractPredictedMentions(annotation, 0, this.corefSystem.dictionaries());
            Document document = this.mentionExtractor.arrange(annotation, sentences, trees, allUnprocessedMentions);
            List<List<Mention>> orderedMentions = document.getOrderedMentions();
            Map<Integer, edu.stanford.nlp.coref.data.CorefChain> result = this.corefSystem.corefReturnHybridOutput(document);
            annotation.set(CorefCoreAnnotations.CorefChainAnnotation.class, result);
            if (this.OLD_FORMAT) {
                Map<Integer, CorefChain> oldResult = this.corefSystem.coref(document);
                DeterministicCorefAnnotator.addObsoleteCoreferenceAnnotations(annotation, orderedMentions, oldResult);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.setNamedEntityTagGranularity(annotation, "fine");
        }
    }

    private static void addObsoleteCoreferenceAnnotations(Annotation annotation, List<List<Mention>> orderedMentions, Map<Integer, CorefChain> result) {
        List<Pair<IntTuple, IntTuple>> links = SieveCoreferenceSystem.getLinks(result);
        ArrayList<Pair<IntTuple, IntTuple>> graph = new ArrayList<Pair<IntTuple, IntTuple>>();
        for (Pair<IntTuple, IntTuple> link : links) {
            int srcSent = ((IntTuple)link.first).get(0);
            int srcTok = orderedMentions.get((int)(srcSent - 1)).get((int)(((IntTuple)link.first).get((int)1) - 1)).headIndex + 1;
            int dstSent = ((IntTuple)link.second).get(0);
            int dstTok = orderedMentions.get((int)(dstSent - 1)).get((int)(((IntTuple)link.second).get((int)1) - 1)).headIndex + 1;
            IntTuple dst = new IntTuple(2);
            dst.set(0, dstSent);
            dst.set(1, dstTok);
            IntTuple src = new IntTuple(2);
            src.set(0, srcSent);
            src.set(1, srcTok);
            graph.add(new Pair<IntTuple, IntTuple>(src, dst));
        }
        annotation.set(CorefCoreAnnotations.CorefGraphAnnotation.class, graph);
        for (CorefChain corefChain : result.values()) {
            if (corefChain.getMentionsInTextualOrder().size() < 2) continue;
            Set<CoreLabel> coreferentTokens = Generics.newHashSet();
            for (CorefChain.CorefMention mention : corefChain.getMentionsInTextualOrder()) {
                CoreMap sentence = (CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(mention.sentNum - 1);
                CoreLabel token = (CoreLabel)((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).get(mention.headIndex - 1);
                coreferentTokens.add(token);
            }
            for (CoreLabel token : coreferentTokens) {
                token.set(CorefCoreAnnotations.CorefClusterAnnotation.class, coreferentTokens);
            }
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.SentencesAnnotation.class, TreeCoreAnnotations.TreeAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(CorefCoreAnnotations.CorefChainAnnotation.class);
    }
}

