/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.TwoDimensionalCounter;
import junit.framework.TestCase;

public class TwoDimensionalCounterTest
extends TestCase {
    private TwoDimensionalCounter<String, String> c;

    protected void setUp() {
        this.c = new TwoDimensionalCounter();
        this.c.setCount("a", "a", 1.0);
        this.c.setCount("a", "b", 2.0);
        this.c.setCount("a", "c", 3.0);
        this.c.setCount("b", "a", 4.0);
        this.c.setCount("b", "b", 5.0);
        this.c.setCount("c", "a", 6.0);
    }

    public void testTotalCount() {
        TwoDimensionalCounterTest.assertEquals((Object)this.c.totalCount(), (Object)21.0);
    }

    public void testSetCount() {
        TwoDimensionalCounterTest.assertEquals((Object)this.c.totalCount(), (Object)21.0);
        this.c.setCount("p", "q", 1.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.totalCount(), (Object)22.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.totalCount("p"), (Object)1.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.getCount("p", "q"), (Object)1.0);
        this.c.remove("p", "q");
    }

    public void testIncrement() {
        TwoDimensionalCounterTest.assertEquals((Object)this.c.totalCount(), (Object)21.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.getCount("b", "b"), (Object)5.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.totalCount("b"), (Object)9.0);
        this.c.incrementCount("b", "b", 2.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.getCount("b", "b"), (Object)7.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.totalCount("b"), (Object)11.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.totalCount(), (Object)23.0);
        this.c.incrementCount("b", "b", -2.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.getCount("b", "b"), (Object)5.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.totalCount("b"), (Object)9.0);
        TwoDimensionalCounterTest.assertEquals((Object)this.c.totalCount(), (Object)21.0);
    }
}

