/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class MaxentTaggerITest
extends TestCase {
    private static MaxentTagger tagger = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<MaxentTaggerITest> clazz = MaxentTaggerITest.class;
        synchronized (MaxentTaggerITest.class) {
            if (tagger == null) {
                tagger = new MaxentTagger("edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testChooseTokenizer() throws Exception {
        TokenizerFactory<? extends HasWord> tokenizer = MaxentTagger.chooseTokenizerFactory(false, "", "", false);
        MaxentTaggerITest.assertTrue((boolean)(tokenizer instanceof WhitespaceTokenizer.WhitespaceTokenizerFactory));
        tokenizer = MaxentTagger.chooseTokenizerFactory(true, "", "", false);
        MaxentTaggerITest.assertTrue((boolean)(tokenizer instanceof PTBTokenizer.PTBTokenizerFactory));
        tokenizer = MaxentTagger.chooseTokenizerFactory(true, "edu.stanford.nlp.process.PTBTokenizer$PTBTokenizerFactory", "", false);
        MaxentTaggerITest.assertTrue((boolean)(tokenizer instanceof PTBTokenizer.PTBTokenizerFactory));
    }

    public void testTokenizeTest() {
        String text = "I think I'll go to Boston.  I think I'm starting over.  I think I'll start a new life where no one knows my name.";
        String[] expectedResults = new String[]{"[I, think, I, 'll, go, to, Boston, .]", "[I, think, I, 'm, starting, over, .]", "[I, think, I, 'll, start, a, new, life, where, no, one, knows, my, name, .]"};
        List<List<HasWord>> results = MaxentTagger.tokenizeText(new BufferedReader(new StringReader(text)));
        for (int i = 0; i < results.size(); ++i) {
            StringWriter result = new StringWriter();
            result.write(results.get(i).toString());
            MaxentTaggerITest.assertEquals((String)expectedResults[i], (String)result.toString());
        }
    }

    private static void compareResults(String[] expectedOutput, ArrayList<String> outputStrings) {
        MaxentTaggerITest.assertEquals((int)expectedOutput.length, (int)outputStrings.size());
        for (int i = 0; i < outputStrings.size(); ++i) {
            MaxentTaggerITest.assertEquals((String)expectedOutput[i].trim(), (String)outputStrings.get(i).trim());
        }
    }

    private static void runRunTaggerTest(boolean emulateStdin, String xmlTag, String input, String ... expectedOutput) {
        StringWriter output = new StringWriter();
        try {
            if (emulateStdin) {
                tagger.runTaggerStdin(new BufferedReader(new StringReader(input)), new BufferedWriter(output), PlainTextDocumentReaderAndWriter.OutputStyle.SLASH_TAGS);
            } else {
                tagger.runTagger(new BufferedReader(new StringReader(input)), new BufferedWriter(output), xmlTag, PlainTextDocumentReaderAndWriter.OutputStyle.SLASH_TAGS);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        BufferedReader reader = new BufferedReader(new StringReader(output.toString()));
        ArrayList<String> outputStrings = new ArrayList<String>();
        try {
            String outputLine;
            while ((outputLine = reader.readLine()) != null) {
                outputStrings.add(outputLine);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MaxentTaggerITest.compareResults(expectedOutput, outputStrings);
    }

    public void testRunTaggerStdin() {
        MaxentTaggerITest.runRunTaggerTest(true, "", "This is a test.\nThe cat fought the dog.  The dog won because it was much bigger.", "This_DT is_VBZ a_DT test_NN ._.", "The_DT cat_NN fought_VBD the_DT dog_NN ._.", "The_DT dog_NN won_VBD because_IN it_PRP was_VBD much_RB bigger_JJR ._.");
    }

    public void testRunTaggerNotStdin() {
        MaxentTaggerITest.runRunTaggerTest(false, "", "This is another test.  This time, the input is not from the console.", "This_DT is_VBZ another_DT test_NN ._.", "This_DT time_NN ,_, the_DT input_NN is_VBZ not_RB from_IN the_DT console_NN ._.");
    }

    public void testRunTaggerXML() {
        MaxentTaggerITest.runRunTaggerTest(false, "text", "<tagger>\n  <text>\n    This tests the xml input.\n  </text>  \n  This should not be tagged.  \n  <text>\n    This should be tagged.\n  </text>\n  <text>\n    The dog's barking kept the\n neighbors up all night.\n  </text>\n</tagging>", "This_DT tests_VBZ the_DT xml_NN input_NN ._.", "This_DT should_MD be_VB tagged_VBN ._.", "The_DT dog_NN 's_POS barking_VBG kept_VBD the_DT neighbors_NNS up_IN all_DT night_NN ._.");
    }

    public void testRunTaggerXML2Tags() {
        MaxentTaggerITest.runRunTaggerTest(false, "foo|bar", "<tagger>\n  <foo>\n    This tests the xml input.\n  </foo>  \n  This should not be tagged.  \n  <bar>\n    This should be tagged.\n  </bar>\n  <foo>\n    The dog's barking kept the\n neighbors up all night.\n  </foo>\n</tagging>", "This_DT tests_VBZ the_DT xml_NN input_NN ._.", "This_DT should_MD be_VB tagged_VBN ._.", "The_DT dog_NN 's_POS barking_VBG kept_VBD the_DT neighbors_NNS up_IN all_DT night_NN ._.");
    }

    public void testRunTaggerManyTags() {
        MaxentTaggerITest.runRunTaggerTest(false, "text.*", "<tagger>\n  <text1>\n    This tests the xml input.\n  </text1>  \n  This should not be tagged.  \n  <text2>\n    This should be tagged.\n  </text2>\n  <text3>\n    The dog's barking kept the\n neighbors up all night.\n  </text3>\n</tagging>", "This_DT tests_VBZ the_DT xml_NN input_NN ._.", "This_DT should_MD be_VB tagged_VBN ._.", "The_DT dog_NN 's_POS barking_VBG kept_VBD the_DT neighbors_NNS up_IN all_DT night_NN ._.");
    }

    private static void runTagFromXMLTest(String input, String expectedOutput, String ... tags) {
        StringWriter outputWriter = new StringWriter();
        tagger.tagFromXML(new BufferedReader(new StringReader(input)), (Writer)new BufferedWriter(outputWriter), tags);
        String actualOutput = outputWriter.toString().replaceAll("\\s+", " ");
        expectedOutput = expectedOutput.replaceAll("\\s+", " ");
        MaxentTaggerITest.assertEquals((String)expectedOutput.trim(), (String)actualOutput.trim());
    }

    public void testTagFromXMLSimple() {
        String input = "<tagger><foo>This should be tagged</foo></tagger>";
        String output = "<tagger> <foo> This_DT should_MD be_VB tagged_VBN </foo> </tagger>";
        MaxentTaggerITest.runTagFromXMLTest(input, output, "foo");
    }

    public void testTagFromXMLTwoTags() {
        String input = "<tagger><foo>This should be tagged</foo>This should not<bar>This should also be tagged</bar></tagger>";
        String output = "<tagger> <foo> This_DT should_MD be_VB tagged_VBN </foo> This should not<bar> This_DT should_MD also_RB be_VB tagged_VBN </bar> </tagger>";
        MaxentTaggerITest.runTagFromXMLTest(input, output, "foo", "bar");
    }

    public void testTagFromXMLNested() {
        String input = "<tagger><foo><bar>This should be tagged</bar></foo></tagger>";
        String output = "<tagger> <foo> This_DT should_MD be_VB tagged_VBN </foo> </tagger>";
        MaxentTaggerITest.runTagFromXMLTest(input, output, "foo", "bar");
    }

    public void testTagFromXMLSingleTag() {
        String input = "<tagger><foo>I have no idea what this will output</foo><bar/>but this should not be tagged<bar>this should be tagged</bar></tagger>";
        String output = "<tagger> <foo> I_PRP have_VBP no_DT idea_NN what_WP this_DT will_MD output_NN </foo> <bar> </bar> but this should not be tagged<bar> this_DT should_MD be_VB tagged_VBN </bar> </tagger> ";
        MaxentTaggerITest.runTagFromXMLTest(input, output, "foo", "bar");
    }

    public void testTagFromXMLEscaping() {
        String input = "<tagger><foo>A simple math formula is 5 &lt; 6</foo> which is the same as 6 &gt; 5</tagger>";
        String output = "<tagger> <foo> A_DT simple_JJ math_NN formula_NN is_VBZ 5_CD &lt;_JJR 6_CD </foo> which is the same as 6 &gt; 5</tagger>";
        MaxentTaggerITest.runTagFromXMLTest(input, output, "foo", "bar");
    }

    public void testTagString() {
        String input = "My dog is fluffy and white and has a fluffy tail.";
        String expectedOutput = "My_PRP$ dog_NN is_VBZ fluffy_JJ and_CC white_JJ and_CC has_VBZ a_DT fluffy_JJ tail_NN ._.";
        String output = tagger.tagString(input).trim();
        MaxentTaggerITest.assertEquals((String)expectedOutput, (String)output);
    }

    public void testTagCoreLabels() {
        String[] testWords;
        ArrayList<CoreLabel> words = new ArrayList<CoreLabel>();
        for (String word : testWords = new String[]{"I", "think", "I", "'ll", "go", "to", "Boston", "."}) {
            CoreLabel label = new CoreLabel(new Word(word));
            label.setWord(label.value());
            words.add(label);
        }
        tagger.tagCoreLabels(words);
        String[] expectedTags = new String[]{"PRP", "VBP", "PRP", "MD", "VB", "TO", "NNP", "."};
        MaxentTaggerITest.assertEquals((int)expectedTags.length, (int)words.size());
        for (int i = 0; i < expectedTags.length; ++i) {
            MaxentTaggerITest.assertEquals((String)expectedTags[i], (String)((CoreLabel)words.get(i)).tag());
        }
    }

    public void testTaggerWrapper() {
        TaggerConfig config = new TaggerConfig(MaxentTaggerITest.tagger.config);
        config.setProperty("tokenize", "false");
        MaxentTagger.TaggerWrapper wrapper = new MaxentTagger.TaggerWrapper(tagger);
        String query = "This is a test . What is the result of two sentences ?";
        String expectedResult = "This_DT is_VBZ a_DT test_NN ._. What_WP is_VBZ the_DT result_NN of_IN two_CD sentences_NNS ?_.";
        String result = wrapper.apply(query).trim();
        MaxentTaggerITest.assertEquals((String)expectedResult, (String)result);
    }
}

