/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.TestCase;

public class TreePrintTest
extends TestCase {
    public void testConll2007() {
        Tree test = Tree.valueOf("((S (NP (PRP It)) (VP (VBZ is) (RB not) (ADJP (JJ normal)) (SBAR (IN for) (S (NP (NNS dogs)) (VP (TO to) (VP (VB be) (VP (VBG vomiting)))))))))");
        String[] words = new String[]{"It", "is", "not", "normal", "for", "dogs", "to", "be", "vomiting"};
        String[] tags = new String[]{"PRP", "VBZ", "RB", "JJ", "IN", "NNS", "TO", "VB", "VBG"};
        TreePrint treePrint = new TreePrint("conll2007");
        StringWriter writer = new StringWriter();
        PrintWriter wrapped = new PrintWriter(writer);
        treePrint.printTree(test, wrapped);
        wrapped.close();
        String out2 = writer.toString();
        String[] lines = out2.trim().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] pieces = lines[i].trim().split("\\s+");
            int lineNum = Integer.valueOf(pieces[0]);
            TreePrintTest.assertEquals((int)(i + 1), (int)lineNum);
            TreePrintTest.assertEquals((String)words[i], (String)pieces[1]);
            TreePrintTest.assertEquals((String)tags[i], (String)pieces[3]);
            TreePrintTest.assertEquals((String)tags[i], (String)pieces[4]);
        }
    }
}

