/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureConversionUtils;
import edu.stanford.nlp.trees.PennTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.pennchinese.UniversalChineseGrammaticalRelations;
import edu.stanford.nlp.trees.international.pennchinese.UniversalChineseGrammaticalStructure;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Pair;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;

public class UniversalChineseGrammaticalStructureTest
extends TestCase {
    private static String C(String ... items) {
        StringBuilder out2 = new StringBuilder();
        for (String x : items) {
            out2.append(x);
            out2.append('\n');
        }
        return out2.toString();
    }

    private static Pair<String, String> T(String tree, String ans) {
        return new Pair<String, String>(tree, ans);
    }

    public void testBasicRelations() {
        Pair[] examples = (Pair[])ErasureUtils.uncheckedCast(new Pair[]{UniversalChineseGrammaticalStructureTest.T("(NP (DNP (NP (NP (NR \u6d66\u4e1c)) (NP (NN \u5f00\u53d1))) (DEG \u7684)) (ADJP (JJ \u6709\u5e8f)) (NP (NN \u8fdb\u884c)))", UniversalChineseGrammaticalStructureTest.C("nmod:assmod(\u5f00\u53d1-2, \u6d66\u4e1c-1)", "nmod:assmod(\u8fdb\u884c-5, \u5f00\u53d1-2)", "case(\u5f00\u53d1-2, \u7684-3)", "amod(\u8fdb\u884c-5, \u6709\u5e8f-4)", "root(ROOT-0, \u8fdb\u884c-5)")), UniversalChineseGrammaticalStructureTest.T("(ROOT (IP (NP (NP (NR \u4e0a\u6d77) (NR \u6d66\u4e1c)) (NP (NN \u5f00\u53d1) (CC \u4e0e) (NN \u6cd5\u5236) (NN \u5efa\u8bbe))) (VP (VV \u540c\u6b65))))", UniversalChineseGrammaticalStructureTest.C("name(\u6d66\u4e1c-2, \u4e0a\u6d77-1)", "nmod:assmod(\u5efa\u8bbe-6, \u6d66\u4e1c-2)", "conj(\u5efa\u8bbe-6, \u5f00\u53d1-3)", "cc(\u5efa\u8bbe-6, \u4e0e-4)", "compound:nn(\u5efa\u8bbe-6, \u6cd5\u5236-5)", "nsubj(\u540c\u6b65-7, \u5efa\u8bbe-6)", "root(ROOT-0, \u540c\u6b65-7)")), UniversalChineseGrammaticalStructureTest.T("(LCP (NP (NT \u8fd1\u5e74)) (LC \u6765))", UniversalChineseGrammaticalStructureTest.C("root(ROOT-0, \u8fd1\u5e74-1)", "case(\u8fd1\u5e74-1, \u6765-2)")), UniversalChineseGrammaticalStructureTest.T("(PP (P \u6839\u636e) (NP (DNP (NP (NP (NN \u56fd\u5bb6)) (CC \u548c) (NP (NR \u4e0a\u6d77\u5e02))) (DEG \u7684)) (ADJP (JJ \u6709\u5173)) (NP (NN \u89c4\u5b9a))))", UniversalChineseGrammaticalStructureTest.C("case(\u89c4\u5b9a-7, \u6839\u636e-1)", "conj(\u4e0a\u6d77\u5e02-4, \u56fd\u5bb6-2)", "cc(\u4e0a\u6d77\u5e02-4, \u548c-3)", "nmod:assmod(\u89c4\u5b9a-7, \u4e0a\u6d77\u5e02-4)", "case(\u4e0a\u6d77\u5e02-4, \u7684-5)", "amod(\u89c4\u5b9a-7, \u6709\u5173-6)", "root(ROOT-0, \u89c4\u5b9a-7)")), UniversalChineseGrammaticalStructureTest.T("(IP (NP (NN \u5efa\u7b51)) (VP (VC \u662f) (NP (CP (IP (VP (VV \u5f00\u53d1) (NP (NR \u6d66\u4e1c)))) (DEC \u7684)) (QP (CD \u4e00) (CLP (M \u9879))) (ADJP (JJ \u4e3b\u8981)) (NP (NN \u7ecf\u6d4e) (NN \u6d3b\u52a8)))))", UniversalChineseGrammaticalStructureTest.C("nsubj(\u6d3b\u52a8-10, \u5efa\u7b51-1)", "cop(\u6d3b\u52a8-10, \u662f-2)", "acl(\u6d3b\u52a8-10, \u5f00\u53d1-3)", "dobj(\u5f00\u53d1-3, \u6d66\u4e1c-4)", "mark(\u5f00\u53d1-3, \u7684-5)", "nummod(\u6d3b\u52a8-10, \u4e00-6)", "mark:clf(\u4e00-6, \u9879-7)", "amod(\u6d3b\u52a8-10, \u4e3b\u8981-8)", "compound:nn(\u6d3b\u52a8-10, \u7ecf\u6d4e-9)", "root(ROOT-0, \u6d3b\u52a8-10)")), UniversalChineseGrammaticalStructureTest.T("(IP (NP (NN \u954d)) (VP (SB \u88ab) (VP (VV \u79f0\u4f5c) (NP (PU \u201c) (DNP (NP (ADJP (JJ \u73b0\u4ee3)) (NP (NN \u5de5\u4e1a))) (DEG \u7684)) (NP (NN \u7ef4\u751f\u7d20)) (PU \u201d)))))", UniversalChineseGrammaticalStructureTest.C("nsubjpass(\u79f0\u4f5c-3, \u954d-1)", "auxpass(\u79f0\u4f5c-3, \u88ab-2)", "root(ROOT-0, \u79f0\u4f5c-3)", "punct(\u7ef4\u751f\u7d20-8, \u201c-4)", "amod(\u5de5\u4e1a-6, \u73b0\u4ee3-5)", "nmod:assmod(\u7ef4\u751f\u7d20-8, \u5de5\u4e1a-6)", "case(\u5de5\u4e1a-6, \u7684-7)", "dobj(\u79f0\u4f5c-3, \u7ef4\u751f\u7d20-8)", "punct(\u7ef4\u751f\u7d20-8, \u201d-9)")), UniversalChineseGrammaticalStructureTest.T("(IP (VP (VP (ADVP (AD \u4e00)) (VP (VV \u51fa\u73b0))) (VP (ADVP (AD \u5c31)) (VP (SB \u88ab) (VP (VV \u7eb3\u5165) (NP (NN \u6cd5\u5236) (NN \u8f68\u9053)))))))))))", UniversalChineseGrammaticalStructureTest.C("advmod(\u51fa\u73b0-2, \u4e00-1)", "root(ROOT-0, \u51fa\u73b0-2)", "advmod(\u7eb3\u5165-5, \u5c31-3)", "auxpass(\u7eb3\u5165-5, \u88ab-4)", "conj(\u51fa\u73b0-2, \u7eb3\u5165-5)", "compound:nn(\u8f68\u9053-7, \u6cd5\u5236-6)", "dobj(\u7eb3\u5165-5, \u8f68\u9053-7)")), UniversalChineseGrammaticalStructureTest.T("(IP (NP (NP (NR \u683c\u6797\u67ef\u5c14)) (NP (NN \u5236\u51b7\u5242)) (PRN (PU \uff08) (NP (NR \u4e2d\u56fd)) (PU \uff09)) (ADJP (JJ \u6709\u9650)) (NP (NN \u516c\u53f8))) (VP (VC \u662f) (NP (CP (CP (IP (NP (NP (NR \u683c\u6797\u67ef\u5c14) (NN \u96c6\u56e2) (NR \u5317\u7f8e) (NN \u516c\u53f8)) (CC \u4e0e) (NP (NP (NR \u4e2d\u56fd) (NR \u5929\u6d25)) (NP (NN \u5f00\u53d1\u533a)) (ADJP (JJ \u603b)) (NP (NN \u516c\u53f8))) (CC \u548c) (NP (NP (NR \u4e2d\u56fd)) (NP (NR \u5357\u65b9)) (NP (NN \u8bc1\u5238)) (ADJP (JJ \u6709\u9650)) (NP (NN \u516c\u53f8)))) (VP (VV \u5408\u5efa))) (DEC \u7684))) (ADJP (JJ \u5408\u8d44)) (NP (NN \u4f01\u4e1a)))) (PU \u3002))", UniversalChineseGrammaticalStructureTest.C("compound:nn(\u516c\u53f8-7, \u683c\u6797\u67ef\u5c14-1)", "compound:nn(\u516c\u53f8-7, \u5236\u51b7\u5242-2)", "punct(\u4e2d\u56fd-4, \uff08-3)", "parataxis:prnmod(\u516c\u53f8-7, \u4e2d\u56fd-4)", "punct(\u4e2d\u56fd-4, \uff09-5)", "amod(\u516c\u53f8-7, \u6709\u9650-6)", "nsubj(\u4f01\u4e1a-28, \u516c\u53f8-7)", "cop(\u4f01\u4e1a-28, \u662f-8)", "compound:nn(\u516c\u53f8-12, \u683c\u6797\u67ef\u5c14-9)", "compound:nn(\u516c\u53f8-12, \u96c6\u56e2-10)", "compound:nn(\u516c\u53f8-12, \u5317\u7f8e-11)", "conj(\u516c\u53f8-24, \u516c\u53f8-12)", "cc(\u516c\u53f8-24, \u4e0e-13)", "name(\u5929\u6d25-15, \u4e2d\u56fd-14)", "compound:nn(\u516c\u53f8-18, \u5929\u6d25-15)", "compound:nn(\u516c\u53f8-18, \u5f00\u53d1\u533a-16)", "amod(\u516c\u53f8-18, \u603b-17)", "conj(\u516c\u53f8-24, \u516c\u53f8-18)", "cc(\u516c\u53f8-24, \u548c-19)", "compound:nn(\u516c\u53f8-24, \u4e2d\u56fd-20)", "compound:nn(\u516c\u53f8-24, \u5357\u65b9-21)", "compound:nn(\u516c\u53f8-24, \u8bc1\u5238-22)", "amod(\u516c\u53f8-24, \u6709\u9650-23)", "nsubj(\u5408\u5efa-25, \u516c\u53f8-24)", "acl(\u4f01\u4e1a-28, \u5408\u5efa-25)", "mark(\u5408\u5efa-25, \u7684-26)", "amod(\u4f01\u4e1a-28, \u5408\u8d44-27)", "root(ROOT-0, \u4f01\u4e1a-28)", "punct(\u4f01\u4e1a-28, \u3002-29)")), UniversalChineseGrammaticalStructureTest.T("(IP (NP (NR \u6c55\u5934) (NN \u673a\u573a)) (VP (VV \u5f00\u901a) (NP (NN \u56fd\u9645) (NN \u56fd\u5185) (NN \u822a\u7ebf)) (QP (CD \u56db\u5341\u56db) (CLP (M \u6761)))) (PU \u3002))", UniversalChineseGrammaticalStructureTest.C("compound:nn(\u673a\u573a-2, \u6c55\u5934-1)", "nsubj(\u5f00\u901a-3, \u673a\u573a-2)", "root(ROOT-0, \u5f00\u901a-3)", "compound:nn(\u822a\u7ebf-6, \u56fd\u9645-4)", "compound:nn(\u822a\u7ebf-6, \u56fd\u5185-5)", "dobj(\u5f00\u901a-3, \u822a\u7ebf-6)", "nmod:range(\u5f00\u901a-3, \u56db\u5341\u56db-7)", "mark:clf(\u56db\u5341\u56db-7, \u6761-8)", "punct(\u5f00\u901a-3, \u3002-9)")), UniversalChineseGrammaticalStructureTest.T("(VP (NP (NT \u4ee5\u524d)) (ADVP (AD \u4e0d)) (ADVP (AD \u66fe)) (VP (VV \u9047\u5230) (AS \u8fc7))))", UniversalChineseGrammaticalStructureTest.C("nmod:tmod(\u9047\u5230-4, \u4ee5\u524d-1)", "neg(\u9047\u5230-4, \u4e0d-2)", "advmod(\u9047\u5230-4, \u66fe-3)", "root(ROOT-0, \u9047\u5230-4)", "aux:asp(\u9047\u5230-4, \u8fc7-5)")), UniversalChineseGrammaticalStructureTest.T("( (IP (ADVP (AD \u9996\u5148)) (NP (PN \u6211\u4eec)) (VP (ADVP (AD \u5148)) (VP (VV \u6765) (VP (VV \u5173\u5fc3) (NP (DNP (NP (NR \u5357\u65af\u62c9\u592b)) (NP (NN \u603b\u7edf) (NN \u5927\u9009)) (DEG \u7684)) (NP (NN \u72b6\u51b5)))))) (PU \u3002))) ", UniversalChineseGrammaticalStructureTest.C("advmod(\u5173\u5fc3-5, \u9996\u5148-1)", "nsubj(\u5173\u5fc3-5, \u6211\u4eec-2)", "advmod(\u5173\u5fc3-5, \u5148-3)", "xcomp(\u5173\u5fc3-5, \u6765-4)", "root(ROOT-0, \u5173\u5fc3-5)", "dep(\u5927\u9009-8, \u5357\u65af\u62c9\u592b-6)", "compound:nn(\u5927\u9009-8, \u603b\u7edf-7)", "nmod:assmod(\u72b6\u51b5-10, \u5927\u9009-8)", "case(\u5927\u9009-8, \u7684-9)", "dobj(\u5173\u5fc3-5, \u72b6\u51b5-10)", "punct(\u5173\u5fc3-5, \u3002-11)")), UniversalChineseGrammaticalStructureTest.T("( (IP (ADVP (AD \u800c)) (NP (NR \u82f1\u56fd) (NN \u5916\u4ea4\u90e8)) (VP (NP (NT \uff15\u53f7)) (ADVP (AD \u5219)) (PP (P \u5bf9) (IP (NP (NR \u5357\u56fd) (NN \u5baa\u6cd5) (NN \u6cd5\u5ead)) (VP (VV \u88c1\u51b3) (IP (NP (NR \u5357\u56fd)) (VP (ADVP (AD \u5c06)) (ADVP (AD \u91cd\u65b0)) (VP (VV \u4e3e\u884c) (NP (NN \u603b\u7edf) (NN \u9009\u4e3e)))))))) (VP (VV \u8868\u793a) (IP (VP (VV \u8c34\u8d23))))) (PU \u3002)))", UniversalChineseGrammaticalStructureTest.C("advmod(\u8868\u793a-17, \u800c-1)", "compound:nn(\u5916\u4ea4\u90e8-3, \u82f1\u56fd-2)", "nsubj(\u8868\u793a-17, \u5916\u4ea4\u90e8-3)", "nmod:tmod(\u8868\u793a-17, \uff15\u53f7-4)", "advmod(\u8868\u793a-17, \u5219-5)", "case(\u88c1\u51b3-10, \u5bf9-6)", "compound:nn(\u6cd5\u5ead-9, \u5357\u56fd-7)", "compound:nn(\u6cd5\u5ead-9, \u5baa\u6cd5-8)", "nsubj(\u88c1\u51b3-10, \u6cd5\u5ead-9)", "nmod:prep(\u8868\u793a-17, \u88c1\u51b3-10)", "nsubj(\u4e3e\u884c-14, \u5357\u56fd-11)", "advmod(\u4e3e\u884c-14, \u5c06-12)", "advmod(\u4e3e\u884c-14, \u91cd\u65b0-13)", "ccomp(\u88c1\u51b3-10, \u4e3e\u884c-14)", "compound:nn(\u9009\u4e3e-16, \u603b\u7edf-15)", "dobj(\u4e3e\u884c-14, \u9009\u4e3e-16)", "root(ROOT-0, \u8868\u793a-17)", "ccomp(\u8868\u793a-17, \u8c34\u8d23-18)", "punct(\u8868\u793a-17, \u3002-19)")), UniversalChineseGrammaticalStructureTest.T("( (IP (NP (NP (NP (NR \u83f2\u5f8b\u5bbe)) (NP (NN \u603b\u7edf))) (NP (NR \u57c3\u65af\u7279\u62c9\u8fbe))) (VP (NP (NT \uff12\u53f7)) (PP (P \u900f\u8fc7) (NP (NP (NR \u9a6c\u5c3c\u62c9)) (NP (NN \u5f53\u5730) (NN \u7535\u53f0)))) (VP (VSB (VV \u5ba3\u5e03) (VV \u8bf4)) (PU \uff0c) (IP (PP (P \u5728) (LCP (NP (CP (CP (IP (VP (ADVP (AD \u4ecd)) (VP (VV \u906d\u5230) (IP (NP (CP (CP (IP (VP (VA \u6fc0\u8fdb))) (DEC \u7684))) (NP (NP (NP (NN \u56de\u6559) (NN \u963f\u535c)) (NP (NR \u6c99\u8036\u592b))) (NP (NN \u7ec4\u7ec7)))) (VP (VV \u7f81\u62bc) (PP (P \u5728) (NP (NP (NP (NR \u975e\u56fd)) (NP (NN \u5357\u90e8))) (NP (NR \u548c\u843d\u5c9b))))))))) (DEC \u7684))) (NP (QP (CD \uff11\uff16) (CLP (M \u540d))) (NP (NN \u4eba\u8d28)))) (LC \u5f53\u4e2d))) (PU \uff0c) (NP (NN \u519b\u65b9)) (VP (ADVP (AD \u5df2\u7ecf)) (VP (VRD (VV \u8425\u6551) (VV \u51fa)) (AS \u4e86) (NP (QP (CD \uff11\uff11) (CLP (M \u540d))) (NP (NP (NR \u83f2\u5f8b\u5bbe)) (NP (NN \u4eba\u8d28))))))))) (PU \u3002))) ", UniversalChineseGrammaticalStructureTest.C("nmod:assmod(\u603b\u7edf-2, \u83f2\u5f8b\u5bbe-1)", "appos(\u57c3\u65af\u7279\u62c9\u8fbe-3, \u603b\u7edf-2)", "nsubj(\u8bf4-10, \u57c3\u65af\u7279\u62c9\u8fbe-3)", "nmod:tmod(\u8bf4-10, \uff12\u53f7-4)", "case(\u7535\u53f0-8, \u900f\u8fc7-5)", "nmod:assmod(\u7535\u53f0-8, \u9a6c\u5c3c\u62c9-6)", "compound:nn(\u7535\u53f0-8, \u5f53\u5730-7)", "nmod:prep(\u8bf4-10, \u7535\u53f0-8)", "compound:vc(\u8bf4-10, \u5ba3\u5e03-9)", "root(ROOT-0, \u8bf4-10)", "punct(\u8bf4-10, \uff0c-11)", "case(\u4eba\u8d28-29, \u5728-12)", "advmod(\u906d\u5230-14, \u4ecd-13)", "acl(\u4eba\u8d28-29, \u906d\u5230-14)", "amod(\u7ec4\u7ec7-20, \u6fc0\u8fdb-15)", "mark(\u6fc0\u8fdb-15, \u7684-16)", "compound:nn(\u963f\u535c-18, \u56de\u6559-17)", "appos(\u6c99\u8036\u592b-19, \u963f\u535c-18)", "compound:nn(\u7ec4\u7ec7-20, \u6c99\u8036\u592b-19)", "nsubj(\u7f81\u62bc-21, \u7ec4\u7ec7-20)", "ccomp(\u906d\u5230-14, \u7f81\u62bc-21)", "case(\u548c\u843d\u5c9b-25, \u5728-22)", "nmod:assmod(\u5357\u90e8-24, \u975e\u56fd-23)", "nmod(\u548c\u843d\u5c9b-25, \u5357\u90e8-24)", "nmod:prep(\u7f81\u62bc-21, \u548c\u843d\u5c9b-25)", "mark(\u906d\u5230-14, \u7684-26)", "nummod(\u4eba\u8d28-29, \uff11\uff16-27)", "mark:clf(\uff11\uff16-27, \u540d-28)", "nmod:prep(\u8425\u6551-34, \u4eba\u8d28-29)", "case(\u4eba\u8d28-29, \u5f53\u4e2d-30)", "punct(\u8425\u6551-34, \uff0c-31)", "nsubj(\u8425\u6551-34, \u519b\u65b9-32)", "advmod(\u8425\u6551-34, \u5df2\u7ecf-33)", "ccomp(\u8bf4-10, \u8425\u6551-34)", "advmod:rcomp(\u8425\u6551-34, \u51fa-35)", "aux:asp(\u8425\u6551-34, \u4e86-36)", "nummod(\u4eba\u8d28-40, \uff11\uff11-37)", "mark:clf(\uff11\uff11-37, \u540d-38)", "nmod:assmod(\u4eba\u8d28-40, \u83f2\u5f8b\u5bbe-39)", "dobj(\u8425\u6551-34, \u4eba\u8d28-40)", "punct(\u8bf4-10, \u3002-41)")), UniversalChineseGrammaticalStructureTest.T("( (IP (IP (NP (NR \u57c3\u65af\u7279\u62c9\u8fbe)) (LCP (IP (VP (NP (NT \uff12\u53f7)) (VP (VV \u63a5\u53d7) (IP (NP (NP (NP (NR \u83f2\u5f8b\u5bbe)) (QP (CD \u4e00) (CLP (M \u5bb6))) (NP (NN \u7535\u53f0)))) (VP (VV \u8bbf\u95ee)))))) (LC \u65f6)) (VP (VV \u8bf4) (PU \uff0c) (IP (NP (NP (NN \u4e09\u519b) (NN \u53c2\u8c0b\u603b\u957f)) (NP (NR \u96f7\u8036\u4e1d))) (VP (VP (VV \u6253) (NP (NN \u7535\u8bdd))) (VP (PP (P \u5411) (NP (PN \u4ed6))) (VP (VSB (VV \u62a5\u544a) (VV \u8bf4)) (PU \uff0c) (IP (NP (NP (NR \u963f\u7f8e\u8fbe)) (CC \u548c) (NP (PN \u5176) (NN \u968f\u884c\u8005))) (VP (ADVP (AD \u5df2\u7ecf)) (VP (VV \u5728) (NP (DNP (NP (NR \u548c\u843d\u5c9b) (NR \u5854\u91cc\u73ed)) (DEG \u7684)) (NP (NR \u9a6c\u5df4)))))))))))) (PU \u2026) (PU \u2026) (IP (VP (VV \u7ee7\u7eed) (VP (VC \u662f) (NP (CP (CP (IP (VP (VA \u91cd\u8981))) (DEC \u7684))) (NP (NN \u56fd\u9645) (NN \u65b0\u95fb)))))) (PU \u3002))) ", UniversalChineseGrammaticalStructureTest.C("nsubj(\u8bf4-10, \u57c3\u65af\u7279\u62c9\u8fbe-1)", "nmod:tmod(\u63a5\u53d7-3, \uff12\u53f7-2)", "advcl:loc(\u8bf4-10, \u63a5\u53d7-3)", "nmod(\u7535\u53f0-7, \u83f2\u5f8b\u5bbe-4)", "nummod(\u7535\u53f0-7, \u4e00-5)", "mark:clf(\u4e00-5, \u5bb6-6)", "nsubj(\u8bbf\u95ee-8, \u7535\u53f0-7)", "ccomp(\u63a5\u53d7-3, \u8bbf\u95ee-8)", "case(\u63a5\u53d7-3, \u65f6-9)", "root(ROOT-0, \u8bf4-10)", "punct(\u8bf4-10, \uff0c-11)", "compound:nn(\u53c2\u8c0b\u603b\u957f-13, \u4e09\u519b-12)", "appos(\u96f7\u8036\u4e1d-14, \u53c2\u8c0b\u603b\u957f-13)", "nsubj(\u6253-15, \u96f7\u8036\u4e1d-14)", "ccomp(\u8bf4-10, \u6253-15)", "dobj(\u6253-15, \u7535\u8bdd-16)", "case(\u4ed6-18, \u5411-17)", "nmod:prep(\u8bf4-20, \u4ed6-18)", "compound:vc(\u8bf4-20, \u62a5\u544a-19)", "conj(\u6253-15, \u8bf4-20)", "punct(\u8bf4-20, \uff0c-21)", "conj(\u968f\u884c\u8005-25, \u963f\u7f8e\u8fbe-22)", "cc(\u968f\u884c\u8005-25, \u548c-23)", "nmod:poss(\u968f\u884c\u8005-25, \u5176-24)", "nsubj(\u5728-27, \u968f\u884c\u8005-25)", "advmod(\u5728-27, \u5df2\u7ecf-26)", "ccomp(\u8bf4-20, \u5728-27)", "name(\u5854\u91cc\u73ed-29, \u548c\u843d\u5c9b-28)", "nmod:assmod(\u9a6c\u5df4-31, \u5854\u91cc\u73ed-29)", "case(\u5854\u91cc\u73ed-29, \u7684-30)", "dobj(\u5728-27, \u9a6c\u5df4-31)", "punct(\u8bf4-10, \u2026-32)", "punct(\u8bf4-10, \u2026-33)", "xcomp(\u65b0\u95fb-39, \u7ee7\u7eed-34)", "cop(\u65b0\u95fb-39, \u662f-35)", "amod(\u65b0\u95fb-39, \u91cd\u8981-36)", "mark(\u91cd\u8981-36, \u7684-37)", "compound:nn(\u65b0\u95fb-39, \u56fd\u9645-38)", "conj(\u8bf4-10, \u65b0\u95fb-39)", "punct(\u8bf4-10, \u3002-40)")), UniversalChineseGrammaticalStructureTest.T("( (IP (IP (NP (NN \u793a\u5a01) (NN \u4eba\u7fa4)) (VP (VP (VV \u6324\u8fdb) (AS \u4e86) (NP (DNP (NP (NR \u8d1d\u5c14\u683c\u52d2)) (DEG \u7684)) (NP (DP (DT \u5404) (CLP (M \u4e2a))) (ADJP (JJ \u4e3b\u8981)) (NP (NN \u8857\u9053) (CC \u548c) (NN \u516c\u56ed))))) (VP (VV \u8fdb\u884c) (NP (NN \u6297\u8bae))))) (PU \uff0c) (IP (ADVP (AD \u800c)) (NP (NP (NR \u5357\u56fd)) (NP (NN \u56fd\u4f1a) (NN \u5927\u53a6))) (VP (VC \u662f) (NP (CP (CP (IP (VP (VP (VV \u6297\u8bae)))) (DEC \u7684))) (NP (ADJP (JJ \u4e3b\u8981)) (NP (NN \u4e2d\u5fc3)))))) (PU \u3002))) ", UniversalChineseGrammaticalStructureTest.C("compound:nn(\u4eba\u7fa4-2, \u793a\u5a01-1)", "nsubj(\u6324\u8fdb-3, \u4eba\u7fa4-2)", "root(ROOT-0, \u6324\u8fdb-3)", "aux:asp(\u6324\u8fdb-3, \u4e86-4)", "nmod:assmod(\u516c\u56ed-12, \u8d1d\u5c14\u683c\u52d2-5)", "case(\u8d1d\u5c14\u683c\u52d2-5, \u7684-6)", "det(\u516c\u56ed-12, \u5404-7)", "mark:clf(\u5404-7, \u4e2a-8)", "amod(\u516c\u56ed-12, \u4e3b\u8981-9)", "conj(\u516c\u56ed-12, \u8857\u9053-10)", "cc(\u516c\u56ed-12, \u548c-11)", "dobj(\u6324\u8fdb-3, \u516c\u56ed-12)", "conj(\u6324\u8fdb-3, \u8fdb\u884c-13)", "dobj(\u8fdb\u884c-13, \u6297\u8bae-14)", "punct(\u6324\u8fdb-3, \uff0c-15)", "advmod(\u4e2d\u5fc3-24, \u800c-16)", "nmod:assmod(\u5927\u53a6-19, \u5357\u56fd-17)", "compound:nn(\u5927\u53a6-19, \u56fd\u4f1a-18)", "nsubj(\u4e2d\u5fc3-24, \u5927\u53a6-19)", "cop(\u4e2d\u5fc3-24, \u662f-20)", "acl(\u4e2d\u5fc3-24, \u6297\u8bae-21)", "mark(\u6297\u8bae-21, \u7684-22)", "amod(\u4e2d\u5fc3-24, \u4e3b\u8981-23)", "conj(\u6324\u8fdb-3, \u4e2d\u5fc3-24)", "punct(\u6324\u8fdb-3, \u3002-25)")), UniversalChineseGrammaticalStructureTest.T("( (IP (IP (NP (DP (DT \u8fd9\u4e9b)) (CP (CP (IP (VV \u793a\u5a01)) (DEC \u7684))) (NP (NN \u6c11\u4f17))) (VP (VV \u6765\u81ea) (NP (CP (CP (IP (VP (VA \u4e0d\u540c))) (DEC \u7684))) (NP (NN \u7701\u4efd))))) (PU \uff0c) (IP (NP (PN \u4ed6\u4eec)) (VP (VP (VV \u5439) (AS \u7740) (NP (NN \u53e3\u54e8))) (PU \uff0c) (VP (VV \u6572) (AS \u7740) (NP (ADJP (JJ \u5c0f)) (NP (NN \u9f13)))) (PU \uff0c) (VP (VV \u9ad8\u558a) (CP (IP (NP (NR \u7c73\u6d1b\u820d\u7ef4\u5947)) (VP (ADVP (AD \u5df2\u7ecf)) (VP (VV \u5b8c\u86cb)))) (SP \u4e86))))) (PU \u3002))) ", UniversalChineseGrammaticalStructureTest.C("det(\u6c11\u4f17-4, \u8fd9\u4e9b-1)", "acl(\u6c11\u4f17-4, \u793a\u5a01-2)", "mark(\u793a\u5a01-2, \u7684-3)", "nsubj(\u6765\u81ea-5, \u6c11\u4f17-4)", "root(ROOT-0, \u6765\u81ea-5)", "amod(\u7701\u4efd-8, \u4e0d\u540c-6)", "mark(\u4e0d\u540c-6, \u7684-7)", "dobj(\u6765\u81ea-5, \u7701\u4efd-8)", "punct(\u6765\u81ea-5, \uff0c-9)", "nsubj(\u5439-11, \u4ed6\u4eec-10)", "conj(\u6765\u81ea-5, \u5439-11)", "aux:asp(\u5439-11, \u7740-12)", "dobj(\u5439-11, \u53e3\u54e8-13)", "punct(\u5439-11, \uff0c-14)", "conj(\u5439-11, \u6572-15)", "aux:asp(\u6572-15, \u7740-16)", "amod(\u9f13-18, \u5c0f-17)", "dobj(\u6572-15, \u9f13-18)", "punct(\u5439-11, \uff0c-19)", "conj(\u5439-11, \u9ad8\u558a-20)", "nsubj(\u5b8c\u86cb-23, \u7c73\u6d1b\u820d\u7ef4\u5947-21)", "advmod(\u5b8c\u86cb-23, \u5df2\u7ecf-22)", "ccomp(\u9ad8\u558a-20, \u5b8c\u86cb-23)", "discourse(\u5b8c\u86cb-23, \u4e86-24)", "punct(\u6765\u81ea-5, \u3002-25)")), UniversalChineseGrammaticalStructureTest.T("( (IP (NP (NR \u666e\u4eac)) (VP (PP (P \u5728) (LCP (IP (VP (VV \u56de\u56fd))) (LC \u4e4b\u540e))) (ADVP (AD \u5c06)) (ADVP (AD \u52aa\u529b)) (VP (VV \u5e73\u606f) (NP (NP (NR \u5357\u65af\u62c9\u592b)) (CP (CP (IP (VP (PP (P \u56e0\u4e3a) (NP (NN \u603b\u7edf) (NN \u5927\u9009))) (VP (MSP \u6240) (VP (VV \u5f15\u7206) )))) (DEC \u7684))) (NP (NN \u653f\u6cbb) (NN \u5371\u673a))))) (PU \u3002))) ", UniversalChineseGrammaticalStructureTest.C("nsubj(\u5e73\u606f-7, \u666e\u4eac-1)", "case(\u56de\u56fd-3, \u5728-2)", "nmod:prep(\u5e73\u606f-7, \u56de\u56fd-3)", "case(\u56de\u56fd-3, \u4e4b\u540e-4)", "advmod(\u5e73\u606f-7, \u5c06-5)", "advmod(\u5e73\u606f-7, \u52aa\u529b-6)", "root(ROOT-0, \u5e73\u606f-7)", "nmod(\u5371\u673a-16, \u5357\u65af\u62c9\u592b-8)", "case(\u5927\u9009-11, \u56e0\u4e3a-9)", "compound:nn(\u5927\u9009-11, \u603b\u7edf-10)", "nmod:prep(\u5f15\u7206-13, \u5927\u9009-11)", "aux:prtmod(\u5f15\u7206-13, \u6240-12)", "acl(\u5371\u673a-16, \u5f15\u7206-13)", "mark(\u5f15\u7206-13, \u7684-14)", "compound:nn(\u5371\u673a-16, \u653f\u6cbb-15)", "dobj(\u5e73\u606f-7, \u5371\u673a-16)", "punct(\u5e73\u606f-7, \u3002-17)"))});
        HashSet<String> ignoreRelations = new HashSet<String>(Arrays.asList("subj", "obj", "mod"));
        HashSet<String> testedRelations = new HashSet<String>();
        for (Pair ex : examples) {
            for (String item : ((String)ex.second).split("\n")) {
                testedRelations.add(item.substring(0, item.indexOf(40)));
            }
        }
        for (String relation : UniversalChineseGrammaticalRelations.shortNameToGRel.keySet()) {
            if (testedRelations.contains(relation) || ignoreRelations.contains(relation)) continue;
            System.err.println("WARNING: relation '" + relation + "' not tested");
        }
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        for (Pair ex : examples) {
            String testTree = (String)ex.first;
            String testAnswer = (String)ex.second;
            Tree tree = Tree.valueOf(testTree, trf);
            UniversalChineseGrammaticalStructure gs = new UniversalChineseGrammaticalStructure(tree, Filters.acceptFilter());
            UniversalChineseGrammaticalStructureTest.assertEquals((String)("Unexpected CC processed dependencies for tree " + testTree), (String)testAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependenciesCCprocessed(GrammaticalStructure.Extras.MAXIMAL), tree, false, false, false));
        }
    }
}

