/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    private static final char[] escapeInputs = new char[]{'\\', '\\', '\\', '\\', '\\', '\\', '\\', '\\', '\\', '\\', '\"', '\"', '\"'};
    private static final String[] csvInputs = new String[]{"", ",", "foo", "foo,bar", "foo,    bar", ",foo,bar,", "foo,\"bar\"", "\"foo,foo2\"", "1997, \"Ford\" ,E350", "foo,\"\",bar", "1999,Chevy,\"Venture \"\"Extended Edition, Large\"\"\",,5000.00", "\"\"\",foo,\"", "\"\"\"\",foo"};
    private static final String[][] csvOutputs = new String[][]{new String[0], {""}, {"foo"}, {"foo", "bar"}, {"foo", "    bar"}, {"", "foo", "bar"}, {"foo", "bar"}, {"foo,foo2"}, {"1997", " Ford ", "E350"}, {"foo", "", "bar"}, {"1999", "Chevy", "Venture \"Extended Edition, Large\"", "", "5000.00"}, {"\",foo,"}, {"\"", "foo"}};

    @Test
    public void testTr() {
        Assert.assertEquals((Object)StringUtils.tr("chris", "irs", "mop"), (Object)"chomp");
    }

    @Test
    public void testGetBaseName() {
        Assert.assertEquals((Object)StringUtils.getBaseName("/u/wcmac/foo.txt"), (Object)"foo.txt");
        Assert.assertEquals((Object)StringUtils.getBaseName("/u/wcmac/foo.txt", ""), (Object)"foo.txt");
        Assert.assertEquals((Object)StringUtils.getBaseName("/u/wcmac/foo.txt", ".txt"), (Object)"foo");
        Assert.assertEquals((Object)StringUtils.getBaseName("/u/wcmac/foo.txt", ".pdf"), (Object)"foo.txt");
    }

    @Test
    public void testArgsToProperties() {
        Properties p1 = new Properties();
        p1.setProperty("fred", "-2");
        p1.setProperty("", "joe");
        Properties p2 = new Properties();
        p2.setProperty("fred", "true");
        p2.setProperty("2", "joe");
        HashMap<String, Integer> argNums = new HashMap<String, Integer>();
        argNums.put("fred", 1);
        Assert.assertEquals((Object)p2, (Object)StringUtils.argsToProperties("-fred", "-2", "joe"));
        Assert.assertEquals((Object)StringUtils.argsToProperties(new String[]{"-fred", "-2", "joe"}, argNums), (Object)p1);
    }

    @Test
    public void testValueSplit() {
        List<String> vals1 = StringUtils.valueSplit("arg(a,b),foo(d,e,f)", "[a-z]*(?:\\([^)]*\\))?", "\\s*,\\s*");
        List<String> ans1 = Arrays.asList("arg(a,b)", "foo(d,e,f)");
        Assert.assertEquals((String)"Split failed", ans1, vals1);
        vals1 = StringUtils.valueSplit("arg(a,b) , foo(d,e,f) , ", "[a-z]*(?:\\([^)]*\\))?", "\\s*,\\s*");
        Assert.assertEquals((String)"Split failed", ans1, vals1);
        vals1 = StringUtils.valueSplit(",arg(a,b),foo(d,e,f)", "[a-z]*(?:\\([^)]*\\))?", "\\s*,\\s*");
        List<String> ans2 = Arrays.asList("", "arg(a,b)", "foo(d,e,f)");
        Assert.assertEquals((String)"Split failed", ans2, vals1);
        List<String> vals3 = StringUtils.valueSplit("\"quoted,comma\",\"with \\\"\\\" quote\" , \"stuff\",or not,quoted,", "\"(?:[^\"\\\\]+|\\\\\")*\"|[^,\"]+", "\\s*,\\s*");
        List<String> ans3 = Arrays.asList("\"quoted,comma\"", "\"with \\\"\\\" quote\"", "\"stuff\"", "or not", "quoted");
        Assert.assertEquals((String)"Split failed", ans3, vals3);
    }

    @Test
    public void testLongestCommonSubstring() {
        Assert.assertEquals((long)12L, (long)StringUtils.longestCommonSubstring("Jo3seph Smarr!", "Joseph R Smarr"));
        Assert.assertEquals((long)12L, (long)StringUtils.longestCommonSubstring("Joseph R Smarr", "Jo3seph Smarr!"));
    }

    @Test
    public void testEditDistance() {
        Assert.assertEquals((long)4L, (long)StringUtils.editDistance("Hi!", "Hi you!"));
        Assert.assertEquals((long)5L, (long)StringUtils.editDistance("Hi!", "Hi you!?"));
        Assert.assertEquals((long)1L, (long)StringUtils.editDistance("sdf", "asdf"));
        Assert.assertEquals((long)1L, (long)StringUtils.editDistance("asd", "asdf"));
        Assert.assertEquals((long)4L, (long)StringUtils.editDistance("Hi you!", "Hi!"));
        Assert.assertEquals((long)5L, (long)StringUtils.editDistance("Hi you!?", "Hi!"));
        Assert.assertEquals((long)1L, (long)StringUtils.editDistance("asdf", "asd"));
        Assert.assertEquals((long)1L, (long)StringUtils.editDistance("asdf", "sdf"));
        Assert.assertEquals((long)3L, (long)StringUtils.editDistance("Hi you!", "Hi Sir!"));
        Assert.assertEquals((long)5L, (long)StringUtils.editDistance("Hi you!", "Hi Sir!!!"));
        Assert.assertEquals((long)2L, (long)StringUtils.editDistance("hello", "hlelo"));
        Assert.assertEquals((long)2L, (long)StringUtils.editDistance("asdf", "adsf"));
        Assert.assertEquals((long)2L, (long)StringUtils.editDistance("asdf", "sadf"));
        Assert.assertEquals((long)2L, (long)StringUtils.editDistance("asdf", "asfd"));
        Assert.assertEquals((long)0L, (long)StringUtils.editDistance("", ""));
        Assert.assertEquals((long)3L, (long)StringUtils.editDistance("", "bar"));
        Assert.assertEquals((long)3L, (long)StringUtils.editDistance("foo", ""));
    }

    @Test
    public void testSplitOnChar() {
        Assert.assertEquals((long)3L, (long)StringUtils.splitOnChar("hello\tthere\tworld", '\t').length);
        Assert.assertEquals((long)2L, (long)StringUtils.splitOnChar("hello\tworld", '\t').length);
        Assert.assertEquals((long)1L, (long)StringUtils.splitOnChar("hello", '\t').length);
        Assert.assertEquals((Object)"hello", (Object)StringUtils.splitOnChar("hello\tthere\tworld", '\t')[0]);
        Assert.assertEquals((Object)"there", (Object)StringUtils.splitOnChar("hello\tthere\tworld", '\t')[1]);
        Assert.assertEquals((Object)"world", (Object)StringUtils.splitOnChar("hello\tthere\tworld", '\t')[2]);
        Assert.assertEquals((long)1L, (long)StringUtils.splitOnChar("hello\tthere\tworld\n", ' ').length);
        Assert.assertEquals((Object)"hello\tthere\tworld\n", (Object)StringUtils.splitOnChar("hello\tthere\tworld\n", ' ')[0]);
        Assert.assertEquals((long)5L, (long)StringUtils.splitOnChar("a\tb\tc\td\te", '\t').length);
        Assert.assertEquals((long)5L, (long)StringUtils.splitOnChar("\t\t\t\t", '\t').length);
        Assert.assertEquals((Object)"", (Object)StringUtils.splitOnChar("\t\t\t\t", '\t')[0]);
        Assert.assertEquals((Object)"", (Object)StringUtils.splitOnChar("\t\t\t\t", '\t')[1]);
        Assert.assertEquals((Object)"", (Object)StringUtils.splitOnChar("\t\t\t\t", '\t')[4]);
    }

    @Test
    public void testStringIsNullOrEmpty() {
        Assert.assertTrue((boolean)StringUtils.isNullOrEmpty(null));
        Assert.assertTrue((boolean)StringUtils.isNullOrEmpty(""));
        Assert.assertFalse((boolean)StringUtils.isNullOrEmpty(" "));
        Assert.assertFalse((boolean)StringUtils.isNullOrEmpty("foo"));
    }

    @Test
    public void testNormalize() {
        Assert.assertEquals((Object)"can't", (Object)StringUtils.normalize("can't"));
        Assert.assertEquals((Object)"Beyonce", (Object)StringUtils.normalize("Beyonc\u00e9"));
        Assert.assertEquals((Object)"krouzek", (Object)StringUtils.normalize("krou\u017eek"));
        Assert.assertEquals((Object)"office", (Object)StringUtils.normalize("o\ufb03ce"));
        Assert.assertEquals((Object)"DZ", (Object)StringUtils.normalize("\u01c4"));
        Assert.assertEquals((Object)"1\u20444", (Object)StringUtils.normalize("\u00bc"));
        Assert.assertEquals((Object)"\ud55c\uad6d\uc5b4", (Object)StringUtils.normalize("\ud55c\uad6d\uc5b4"));
        Assert.assertEquals((Object)"\uc870\uc120\ub9d0", (Object)StringUtils.normalize("\uc870\uc120\ub9d0"));
        Assert.assertEquals((Object)"\u304c", (Object)StringUtils.normalize("\u304c"));
        Assert.assertEquals((Object)"\u304b", (Object)StringUtils.normalize("\u304b"));
    }

    @Test
    public void testCSV() {
        Assert.assertEquals((String)"Bung test", (long)csvInputs.length, (long)csvOutputs.length);
        for (int i = 0; i < csvInputs.length; ++i) {
            Object[] answer = StringUtils.splitOnCharWithQuoting(csvInputs[i], ',', '\"', escapeInputs[i]);
            Assert.assertTrue((String)("Bad CSV line handling of ex " + i + ": " + Arrays.toString(csvOutputs[i]) + " vs. " + Arrays.toString(answer)), (boolean)Arrays.equals(csvOutputs[i], answer));
        }
    }

    @Test
    public void testGetCharacterNgrams() {
        StringUtilsTest.testCharacterNgram("abc", 0, 0, new String[0]);
        StringUtilsTest.testCharacterNgram("abc", 1, 1, "a", "b", "c");
        StringUtilsTest.testCharacterNgram("abc", 2, 2, "ab", "bc");
        StringUtilsTest.testCharacterNgram("abc", 1, 2, "a", "b", "c", "ab", "bc");
        StringUtilsTest.testCharacterNgram("abc", 1, 3, "a", "b", "c", "ab", "bc", "abc");
        StringUtilsTest.testCharacterNgram("abc", 1, 4, "a", "b", "c", "ab", "bc", "abc");
    }

    private static void testCharacterNgram(String string, int min, int max, String ... expected) {
        System.out.println(StringUtilsTest.makeSet(expected));
        System.out.println(StringUtils.getCharacterNgrams(string, min, max));
        Assert.assertEquals(StringUtilsTest.makeSet(expected), new HashSet<String>(StringUtils.getCharacterNgrams(string, min, max)));
    }

    @SafeVarargs
    private static <T> Set<T> makeSet(T ... elems) {
        return new HashSet<T>(Arrays.asList(elems));
    }

    @Test
    public void testExpandEnvironmentVariables() {
        HashMap<String, String> env = new HashMap<String, String>(){
            {
                this.put("A", "[outA]");
                this.put("A_B", "[outA_B]");
                this.put("a_B", "[outa_B]");
                this.put("a_B45", "[outa_B45]");
                this.put("_A", "[out_A]");
                this.put("3A", "[out_3A]");
            }
        };
        Assert.assertEquals((Object)"xxx [outA] xxx", (Object)StringUtils.expandEnvironmentVariables("xxx $A xxx", (Map<String, String>)env));
        Assert.assertEquals((Object)"xxx[outA] xxx", (Object)StringUtils.expandEnvironmentVariables("xxx$A xxx", (Map<String, String>)env));
        Assert.assertEquals((Object)"xxx[outA]xxx", (Object)StringUtils.expandEnvironmentVariables("xxx${A}xxx", (Map<String, String>)env));
        Assert.assertEquals((Object)"xxx [outA_B] xxx", (Object)StringUtils.expandEnvironmentVariables("xxx $A_B xxx", (Map<String, String>)env));
        Assert.assertEquals((Object)"xxx [outa_B] xxx", (Object)StringUtils.expandEnvironmentVariables("xxx $a_B xxx", (Map<String, String>)env));
        Assert.assertEquals((Object)"xxx [outa_B45] xxx", (Object)StringUtils.expandEnvironmentVariables("xxx $a_B45 xxx", (Map<String, String>)env));
        Assert.assertEquals((Object)"xxx [out_A] xxx", (Object)StringUtils.expandEnvironmentVariables("xxx $_A xxx", (Map<String, String>)env));
        Assert.assertEquals((Object)"xxx $3A xxx", (Object)StringUtils.expandEnvironmentVariables("xxx $3A xxx", (Map<String, String>)env));
        Assert.assertEquals((Object)"xxx  xxx", (Object)StringUtils.expandEnvironmentVariables("xxx $UNDEFINED xxx", (Map<String, String>)env));
    }

    @Test
    public void testDecodeArray() throws IOException {
        String tempFile1 = Files.createTempFile("test", "tmp", new FileAttribute[0]).toString();
        String tempFile2 = Files.createTempFile("test", "tmp", new FileAttribute[0]).toString();
        String[] decodedArray = StringUtils.decodeArray("'" + tempFile1 + "','" + tempFile2 + "'");
        Assert.assertEquals((long)2L, (long)decodedArray.length);
        Assert.assertEquals((Object)tempFile1, (Object)decodedArray[0]);
        Assert.assertEquals((Object)tempFile2, (Object)decodedArray[1]);
        String[] test10 = new String[]{"\"C:\\Users\\BELLCH~1\\AppData\\Local\\Temp\\bill-ie5804201486895318826regex_rules.txt\"", "[\"C:\\Users\\BELLCH~1\\AppData\\Local\\Temp\\bill-ie5804201486895318826regex_rules.txt\"]"};
        String[] ans10 = new String[]{"C:\\Users\\BELLCH~1\\AppData\\Local\\Temp\\bill-ie5804201486895318826regex_rules.txt"};
        String[] test11 = new String[]{"C:\\Users\\BELLCH~1\\AppData\\Local\\Temp\\bill-ie5804201486895318826regex_rules.txt", "[C:\\Users\\BELLCH~1\\AppData\\Local\\Temp\\bill-ie5804201486895318826regex_rules.txt]"};
        String[] ans11 = new String[]{"C:UsersBELLCH~1AppDataLocalTempbill-ie5804201486895318826regex_rules.txt"};
        for (String s : test10) {
            Assert.assertEquals(Arrays.asList(ans10), Arrays.asList(StringUtils.decodeArray(s)));
        }
        for (String s : test11) {
            Assert.assertEquals(Arrays.asList(ans11), Arrays.asList(StringUtils.decodeArray(s)));
        }
    }

    @Test
    public void testRegexGroups() {
        List<String> ans = Arrays.asList("42", "123", "1965");
        Assert.assertEquals(ans, StringUtils.regexGroups(Pattern.compile("(\\d+)\\D*(\\d+)\\D*(\\d+)"), "abc-x42!123   -1965."));
    }

    @Test
    public void testEscapeJsonString() {
        Assert.assertEquals((Object)"\\u0001\\b\\r\\u001D\\u001Fz", (Object)StringUtils.escapeJsonString("\u0001\b\r\u001d\u001fz"));
        Assert.assertEquals((Object)"food", (Object)StringUtils.escapeJsonString("food"));
        Assert.assertEquals((Object)"\\\\\\\"here\\u0000goes\\b\\u000B", (Object)StringUtils.escapeJsonString("\\\"here\u0000goes\b\u000b"));
    }
}

