/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.hybrid.demo;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ChineseHcorefDemo {
    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        String text = "\u4fc4\u7f57\u65af \u822a\u7a7a \u516c\u53f8 \u4e00 \u540d \u5b98\u5458 \u5728 \uff19\u53f7 \u8bf4 \uff0c \u7c73\u6d1b\u820d\u7ef4\u5947 \u7684 \u513f\u5b50 \u9a6c\u53ef\u00b7\u7c73\u6d1b\u820d\u7ef4\u5947 \uff19\u53f7 \u65e9\u4e0a \u6301 \u5916\u4ea4 \u62a4\u7167 \u4ece \u4fc4\u56fd \u9996\u90fd \u83ab\u65af\u79d1 \u642d\u673a \u98de\u5f80 \u4e2d\u56fd \u5927\u9646 \u5317\u4eac \uff0c \u53ef\u662f \u5c31 \u5728 \u7a0d\u540e \u5c31 \u8fd4\u56de \u83ab\u65af\u79d1 \u3002 \u8fd9 \u540d \u4fc4\u56fd \u822a\u7a7a \u516c\u53f8 \u5b98\u5458 \u8bf4 \u9a6c\u53ef \u662f \u56e0\u4e3a \u62a4\u7167 \u95ee\u9898 \u800c \u5728 \u5317\u4eac \u673a\u573a \u88ab \u4e2d\u5171 \u9063\u8fd4 \u83ab\u65af\u79d1 \u3002 \u5317\u4eac \u673a\u573a \u65b9\u9762 \u7684 \u8fd9 \u9879 \u4e3e\u52a8 \u6e05\u695a \u663e\u793a \u4e2d\u5171 \u6709\u610f \u653e\u5f03 \u5728 \u603b\u7edf \u5927\u9009 \u843d\u8d25 \u7684 \u524d \u5357\u65af\u62c9\u592b \u603b\u7edf \u7c73\u6d1b\u820d\u7ef4\u5947 \uff0c \u56e0\u6b64 \u4ed6 \u5728 \u5357\u65af\u62c9\u592b \u53d7\u5230 \u6c11\u4f17 \u538c\u6076 \u7684 \u513f\u5b50 \u9a6c\u53ef \u624d \u4f1a \u5728 \u5317\u4eac \u673a\u573a \u88ab \u4e2d\u5171 \u5f53\u5c40 \u9001\u56de \u83ab\u65af\u79d1 \u3002 \u9a6c\u53ef \u6301 \u5916\u4ea4 \u62a4\u7167 \u80fd\u591f \u987a\u5229 \u642d\u673a \u79bb\u5f00 \u83ab\u65af\u79d1 \uff0c \u4f46\u662f \u5374 \u5728 \u5317\u4eac \u53d7\u963b \uff0c \u53ef \u7b97\u662f \u8e22\u5230 \u4e86 \u94c1\u677f \u3002 \u53ef\u662f \u8fd9 \u9879 \u6d88\u606f \u548c \u5148\u524d \u5916\u754c \u8c23\u4f20 \u4e2d\u5171 \u5f53\u5c40 \u51c6\u5907 \u63d0\u4f9b \u7c73\u6d1b\u820d\u7ef4\u5947 \u548c \u4ed6 \u7684 \u5bb6\u4eba \u5b89\u5168 \u5e87\u62a4\u6240 \u6709 \u7740 \u5f88 \u5927 \u7684 \u51fa\u5165 , \u4e00\u822c \u8ba4\u4e3a \u5728 \u53bb\u5e74 \u7c73\u6d1b\u820d\u7ef4\u5947 \u6325\u5175 \u653b\u6253 \u79d1\u7d22\u6c83 \u5883\u5185 \u963f\u5c14\u5df4\u5c3c\u4e9a \u4e00 \u5206\u79bb\u4e3b\u4e49 \u5206\u5b50 \u7684 \u65f6\u5019 \uff0c \u5f3a\u529b \u53cd\u5bf9 \u5317\u7ea6 \u7ec4\u7ec7 \u653b\u51fb \u5357\u65af\u62c9\u592b \u7684 \u4e2d\u5171 \uff0c \u4f1a \u5168\u529b \u4fdd\u62a4 \u7c73\u6d1b\u820d\u7ef4\u5947 \u548c \u4ed6 \u7684 \u5bb6\u4eba \u53ca \u4eb2\u4fe1 \u3002 \u53ef\u662f \u4ece \uff19\u53f7 \u9a6c\u53ef \u88ab \u9001\u56de \u83ab\u65af\u79d1 \u4e00 \u4e8b \u770b \u8d77\u6765 \uff0c \u4e2d\u5171 \u5f88 \u53ef\u80fd \u4f1a \u653e\u5f03 \u7c73\u6d1b\u820d\u7ef4\u5947 \u3002";
        args = new String[]{"-props", "edu/stanford/nlp/hcoref/properties/zh-coref-default.properties"};
        Annotation document = new Annotation(text);
        Properties props = StringUtils.argsToProperties(args);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(document);
        System.out.println("---");
        System.out.println("coref chains");
        for (CorefChain cc : ((Map)document.get(CorefCoreAnnotations.CorefChainAnnotation.class)).values()) {
            System.out.println("\t" + cc);
        }
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            System.out.println("---");
            System.out.println("mentions");
            for (Mention m : (List)sentence.get(CorefCoreAnnotations.CorefMentionsAnnotation.class)) {
                System.out.println("\t" + m);
            }
        }
        long endTime = System.currentTimeMillis();
        long time = (endTime - startTime) / 1000L;
        System.out.println("Running time " + time / 60L + "min " + time % 60L + "s");
    }
}

