/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.Rules;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SentenceUtils;
import java.util.List;
import junit.framework.TestCase;

public class RulesTest
extends TestCase {
    List<CoreLabel> IBM = SentenceUtils.toCoreLabelList("IBM");
    List<CoreLabel> IBM2 = SentenceUtils.toCoreLabelList("International", "Business", "Machines");
    List<CoreLabel> IBMM = SentenceUtils.toCoreLabelList("IBMM");
    List<CoreLabel> MIBM = SentenceUtils.toCoreLabelList("MIBM");

    public void testIsAcronym() {
        RulesTest.assertTrue((boolean)Rules.isAcronym(this.IBM, this.IBM2));
        RulesTest.assertTrue((boolean)Rules.isAcronym(this.IBM2, this.IBM));
        RulesTest.assertFalse((boolean)Rules.isAcronym(this.IBM, this.IBMM));
        RulesTest.assertFalse((boolean)Rules.isAcronym(this.IBM2, this.IBMM));
        RulesTest.assertFalse((boolean)Rules.isAcronym(this.IBM, this.MIBM));
        RulesTest.assertFalse((boolean)Rules.isAcronym(this.IBM2, this.MIBM));
    }

    public void testMentionMatchesSpeakerAnnotation() {
        Mention g1 = new Mention(0, 0, 0, null);
        Mention m1 = new Mention(0, 0, 0, null);
        Mention m2 = new Mention(0, 0, 0, null);
        Mention m3 = new Mention(0, 0, 0, null);
        Mention m4 = new Mention(0, 0, 0, null);
        Mention m5 = new Mention(0, 0, 0, null);
        Mention m6 = new Mention(0, 0, 0, null);
        Mention m7 = new Mention(0, 0, 0, null);
        Mention m8 = new Mention(0, 0, 0, null);
        Mention g2 = new Mention(0, 0, 0, null);
        Mention g3 = new Mention(0, 0, 0, null);
        Mention g4 = new Mention(0, 0, 0, null);
        g1.headWord = new CoreLabel();
        g1.headWord.set(CoreAnnotations.SpeakerAnnotation.class, "john abraham bauer");
        m1.headString = "john";
        m2.headString = "bauer";
        m3.headString = "foo";
        m4.headString = "abraham";
        m5.headString = "braham";
        m6.headString = "zabraham";
        m7.headString = "abraha";
        m8.headString = "abrahamz";
        g2.headWord = new CoreLabel();
        g2.headWord.set(CoreAnnotations.SpeakerAnnotation.class, "john");
        g3.headWord = new CoreLabel();
        g3.headWord.set(CoreAnnotations.SpeakerAnnotation.class, "joh");
        g4.headWord = new CoreLabel();
        g4.headWord.set(CoreAnnotations.SpeakerAnnotation.class, "johnz");
        RulesTest.assertTrue((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g1, m1));
        RulesTest.assertTrue((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g1, m2));
        RulesTest.assertFalse((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g1, m3));
        RulesTest.assertTrue((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g1, m4));
        RulesTest.assertFalse((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g1, m5));
        RulesTest.assertFalse((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g1, m6));
        RulesTest.assertFalse((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g1, m7));
        RulesTest.assertFalse((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g1, m8));
        RulesTest.assertTrue((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g2, m1));
        RulesTest.assertFalse((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g3, m1));
        RulesTest.assertFalse((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(g4, m1));
        RulesTest.assertFalse((boolean)Rules.antecedentMatchesMentionSpeakerAnnotation(m1, g1));
    }
}

