/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;

public class FloatFactorTable {
    private static final Redwood.RedwoodChannels log = Redwood.channels(FloatFactorTable.class);
    private final int numClasses;
    private final int windowSize;
    private final float[] table;

    public FloatFactorTable(int numClasses, int windowSize) {
        this.numClasses = numClasses;
        this.windowSize = windowSize;
        this.table = new float[SloppyMath.intPow(numClasses, windowSize)];
        Arrays.fill(this.table, Float.NEGATIVE_INFINITY);
    }

    public boolean hasNaN() {
        return ArrayMath.hasNaN(this.table);
    }

    public String toProbString() {
        StringBuilder sb = new StringBuilder("{\n");
        for (int i = 0; i < this.table.length; ++i) {
            sb.append(Arrays.toString(this.toArray(i)));
            sb.append(": ");
            sb.append(this.prob(this.toArray(i)));
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString(Index<?> classIndex) {
        StringBuilder sb = new StringBuilder("{\n");
        for (int i = 0; i < this.table.length; ++i) {
            sb.append(this.toString(this.toArray(i), classIndex));
            sb.append(": ");
            sb.append(this.getValue(i));
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        for (int i = 0; i < this.table.length; ++i) {
            sb.append(Arrays.toString(this.toArray(i)));
            sb.append(": ");
            sb.append(this.getValue(i));
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toString(int[] array, Index<?> classIndex) {
        ArrayList l = new ArrayList();
        for (int anArray : array) {
            l.add(classIndex.get(anArray));
        }
        return ((Object)l).toString();
    }

    private int[] toArray(int index) {
        int[] indices = new int[this.windowSize];
        for (int i = indices.length - 1; i >= 0; --i) {
            indices[i] = index % this.numClasses;
            index /= this.numClasses;
        }
        return indices;
    }

    private int indexOf(int[] entry) {
        int index = 0;
        for (int anEntry : entry) {
            index *= this.numClasses;
            index += anEntry;
        }
        return index;
    }

    private int indexOf(int[] front, int end) {
        int index = 0;
        for (int aFront : front) {
            index *= this.numClasses;
            index += aFront;
        }
        index *= this.numClasses;
        return index += end;
    }

    private int[] indicesEnd(int[] entries) {
        int[] indices = new int[SloppyMath.intPow(this.numClasses, this.windowSize - entries.length)];
        int offset = SloppyMath.intPow(this.numClasses, entries.length);
        int index = 0;
        for (int entry : entries) {
            index *= this.numClasses;
            index += entry;
        }
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = index;
            index += offset;
        }
        return indices;
    }

    private int[] indicesFront(int[] entries) {
        int i;
        int[] indices = new int[SloppyMath.intPow(this.numClasses, this.windowSize - entries.length)];
        int offset = SloppyMath.intPow(this.numClasses, this.windowSize - entries.length);
        int start = 0;
        for (int entry : entries) {
            start *= this.numClasses;
            start += entry;
        }
        start *= offset;
        int end = 0;
        for (i = 0; i < entries.length; ++i) {
            end *= this.numClasses;
            end += entries[i];
            if (i != entries.length - 1) continue;
            ++end;
        }
        end *= offset;
        for (i = start; i < end; ++i) {
            indices[i - start] = i;
        }
        return indices;
    }

    public int windowSize() {
        return this.windowSize;
    }

    public int numClasses() {
        return this.numClasses;
    }

    private int size() {
        return this.table.length;
    }

    public float totalMass() {
        return ArrayMath.logSum(this.table);
    }

    public float unnormalizedLogProb(int[] label) {
        return this.getValue(label);
    }

    public float logProb(int[] label) {
        return this.unnormalizedLogProb(label) - this.totalMass();
    }

    public float prob(int[] label) {
        return (float)Math.exp(this.unnormalizedLogProb(label) - this.totalMass());
    }

    public float conditionalLogProb(int[] given, int of) {
        if (given.length != this.windowSize - 1) {
            log.info("error computing conditional log prob");
            System.exit(0);
        }
        int[] label = this.indicesFront(given);
        float[] masses = new float[label.length];
        for (int i = 0; i < masses.length; ++i) {
            masses[i] = this.table[label[i]];
        }
        float z = ArrayMath.logSum(masses);
        return this.table[this.indexOf(given, of)] - z;
    }

    public float unnormalizedLogProbFront(int[] label) {
        label = this.indicesFront(label);
        float[] masses = new float[label.length];
        for (int i = 0; i < masses.length; ++i) {
            masses[i] = this.table[label[i]];
        }
        return ArrayMath.logSum(masses);
    }

    public float logProbFront(int[] label) {
        return this.unnormalizedLogProbFront(label) - this.totalMass();
    }

    public float unnormalizedLogProbEnd(int[] label) {
        label = this.indicesEnd(label);
        float[] masses = new float[label.length];
        for (int i = 0; i < masses.length; ++i) {
            masses[i] = this.table[label[i]];
        }
        return ArrayMath.logSum(masses);
    }

    public float logProbEnd(int[] label) {
        return this.unnormalizedLogProbEnd(label) - this.totalMass();
    }

    public float unnormalizedLogProbEnd(int label) {
        int[] l = new int[]{label};
        l = this.indicesEnd(l);
        float[] masses = new float[l.length];
        for (int i = 0; i < masses.length; ++i) {
            masses[i] = this.table[l[i]];
        }
        return ArrayMath.logSum(masses);
    }

    public float logProbEnd(int label) {
        return this.unnormalizedLogProbEnd(label) - this.totalMass();
    }

    private float getValue(int index) {
        return this.table[index];
    }

    public float getValue(int[] label) {
        return this.table[this.indexOf(label)];
    }

    private void setValue(int index, float value) {
        this.table[index] = value;
    }

    public void setValue(int[] label, float value) {
        this.table[this.indexOf((int[])label)] = value;
    }

    public void incrementValue(int[] label, float value) {
        int n = this.indexOf(label);
        this.table[n] = this.table[n] + value;
    }

    private void logIncrementValue(int index, float value) {
        this.table[index] = SloppyMath.logAdd(this.table[index], value);
    }

    public void logIncrementValue(int[] label, float value) {
        int index = this.indexOf(label);
        this.table[index] = SloppyMath.logAdd(this.table[index], value);
    }

    public void multiplyInFront(FloatFactorTable other) {
        int divisor = SloppyMath.intPow(this.numClasses, this.windowSize - other.windowSize());
        for (int i = 0; i < this.table.length; ++i) {
            int n = i;
            this.table[n] = this.table[n] + other.getValue(i / divisor);
        }
    }

    public void multiplyInEnd(FloatFactorTable other) {
        int divisor = SloppyMath.intPow(this.numClasses, other.windowSize());
        for (int i = 0; i < this.table.length; ++i) {
            int n = i;
            this.table[n] = this.table[n] + other.getValue(i % divisor);
        }
    }

    public FloatFactorTable sumOutEnd() {
        FloatFactorTable ft = new FloatFactorTable(this.numClasses, this.windowSize - 1);
        for (int i = 0; i < this.table.length; ++i) {
            ft.logIncrementValue(i / this.numClasses, this.table[i]);
        }
        return ft;
    }

    public FloatFactorTable sumOutFront() {
        FloatFactorTable ft = new FloatFactorTable(this.numClasses, this.windowSize - 1);
        int mod = SloppyMath.intPow(this.numClasses, this.windowSize - 1);
        for (int i = 0; i < this.table.length; ++i) {
            ft.logIncrementValue(i % mod, this.table[i]);
        }
        return ft;
    }

    public void divideBy(FloatFactorTable other) {
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == Float.NEGATIVE_INFINITY && other.table[i] == Float.NEGATIVE_INFINITY) continue;
            int n = i;
            this.table[n] = this.table[n] - other.table[i];
        }
    }

    public static void main(String[] args) {
        int j;
        int i;
        int[] b;
        FloatFactorTable ft = new FloatFactorTable(6, 3);
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int j2 = 0; j2 < 6; ++j2) {
                for (int k = 0; k < 6; ++k) {
                    b = new int[]{i2, j2, k};
                    ft.setValue(b, (float)(i2 * 4 + j2 * 2 + k));
                }
            }
        }
        FloatFactorTable ft2 = new FloatFactorTable(6, 2);
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                b = new int[]{i, j};
                ft2.setValue(b, (float)(i * 6 + j));
            }
        }
        System.out.println(ft);
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                b = new int[]{i, j};
                float t = 0.0f;
                for (int k = 0; k < 6; ++k) {
                    t = (float)((double)t + Math.exp(ft.conditionalLogProb(b, k)));
                    log.info(k + "|" + i + "," + j + " : " + Math.exp(ft.conditionalLogProb(b, k)));
                }
                System.out.println(t);
            }
        }
    }
}

