/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class FileFilters {
    private FileFilters() {
    }

    public static FileFilter conjunctionFileFilter(FileFilter a, FileFilter b) {
        return new ConjunctionFileFilter(a, b);
    }

    public static FileFilter negationFileFilter(FileFilter a) {
        return new NegationFileFilter(a);
    }

    public static FileFilter findRegexFileFilter(String regex) {
        return new FindRegexFileFilter(regex);
    }

    private static class FindRegexFileFilter
    implements FileFilter {
        private final Pattern p;

        public FindRegexFileFilter(String regex) {
            this.p = Pattern.compile(regex);
        }

        @Override
        public boolean accept(File file) {
            return this.p.matcher(file.getName()).find();
        }
    }

    private static class NegationFileFilter
    implements FileFilter {
        private final FileFilter f1;

        public NegationFileFilter(FileFilter a) {
            this.f1 = a;
        }

        @Override
        public boolean accept(File file) {
            return !this.f1.accept(file);
        }
    }

    private static class ConjunctionFileFilter
    implements FileFilter {
        private final FileFilter f1;
        private final FileFilter f2;

        public ConjunctionFileFilter(FileFilter a, FileFilter b) {
            this.f1 = a;
            this.f2 = b;
        }

        @Override
        public boolean accept(File file) {
            return this.f1.accept(file) && this.f2.accept(file);
        }
    }
}

